%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% SVAR: This file replicates Table 4
disp(' --------------------------------------------------------------------')
disp('  ')
disp(' Structural VAR - Instrumental Variable ')
disp('  ')
disp('              Table 4')
disp('  ')
disp(' --------------------------------------------------------------------')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all; close all;
addpath('auxiliary files')


% Age groups
init_group = 2;
end_group  = 8;

% Loop over age groups
for entry_variable=init_group:end_group

CONTROLS            = xlsread('data/FF_DATA.xlsx','CONTROLS');
NARR                = xlsread('data/FF_DATA.xlsx','FF PROXIES'); 
PROX                = NARR(:,entry_variable);
PROX(isnan(PROX))   = 0;

URATE_AGE           = xlsread('data/FF_DATA.xlsx','URATE'); 
PRATE_AGE           = xlsread('data/FF_DATA.xlsx','PRATE');
ATR_AGE             = xlsread('data/FF_DATA.xlsx','ATR'); 
AMTR_AGE            = xlsread('data/FF_DATA.xlsx','AMTR'); 

AMTR_AGE(:,2:end) = log(AMTR_AGE(:,2:end));
URATE_AGE         = log(URATE_AGE);
PRATE_AGE         = log(PRATE_AGE);
ATR_AGE           = log(ATR_AGE);


DATASET.TSERIES = [AMTR_AGE(:,1) AMTR_AGE(:,entry_variable) URATE_AGE(:,entry_variable) PRATE_AGE(:,entry_variable) CONTROLS(:,2)  CONTROLS(:,6:10)   PROX ATR_AGE(:,2) ];
DATASET.LABEL   = {'DATES','AMTR_AGE','UR_AGE','PR_AGE','RGDP','GOV_TOT','STPRICE','DDEBT','AVTAX','DFFR','PROX', 'ATR_AGE'};
DATASET.UNIT    = [     0     1           1       1       2        1         1        1      1       2        2       1 ];
DATASET.FIGLABELS= [{'year' ,'Average Marginal Tax Rate','Unemployment Rate Age','Participation Rate Age','Real GDP', ...
                    'Government Spending','Real Stock Prices', 'DlogDebt','Avg Tax','DFFR','AMTR proxy','Avg Tax Age'}];  
                
DATASET.MAP = containers.Map(DATASET.LABEL,1:size(DATASET.TSERIES,2));

% Specification
SPEC.sb              = 1961;  % Sample start year
SPEC.se              = 2012;  % Sample end year
TSERIES              = DATASET.TSERIES((DATASET.TSERIES(:,1)>=SPEC.sb)&(DATASET.TSERIES(:,1)<=SPEC.se),:);
SPEC.dates           = TSERIES(:,1);
SPEC.DET             = [  ones(size(TSERIES,1),1)]; % Deterministic Terms (Put constant last)
SPEC.p               = 2; % Lag length
SPEC.NWlags          = 8; % Newey-West Lags
SPEC.irhor           = 5; % Length of IR horizon 
SPEC.select_variables = {'AMTR_AGE','ATR_AGE','RGDP','GOV_TOT','DDEBT','STPRICE','DFFR','UR_AGE','PR_AGE'};
plotdisplay = {'UR_AGE','PR_AGE','AMTR_AGE'};
SPEC.vars            = TSERIES(:,cell2mat(values(DATASET.MAP,SPEC.select_variables)));
SPEC.taxshocks       = TSERIES(:,cell2mat(values(DATASET.MAP,{'PROX'})));
SPEC.MAP             = containers.Map([SPEC.select_variables],[1:size(SPEC.vars,2)]);   


% Estimate SVARIV model
SVARIV               = SPEC;
SVARIV               = doProxySVAR(SVARIV); 

% Inference:
clevel              = [95 68];    % CI Percentiles
nboot               = 5000;
SVARIVci            = doProxySVARci(SVARIV,clevel,3,nboot);

% Make Plot 
name = '_SVARIV';

display1= cell2mat(values(SVARIV.MAP,plotdisplay));
% Save Output from every iteration
FF_SVARIV(:,:,entry_variable) = SVARIV.irs(:,display1);% time,UR or PR,age group
FF_SVARIVciL(:,:,:,entry_variable) = squeeze(SVARIVci.irsL(:,display1,:));% time,UR or PR,age group
FF_SVARIVciH(:,:,:,entry_variable) = squeeze(SVARIVci.irsH(:,display1,:));% time,UR or PR,age group
end

% LFSHARE 16-20	LF SHARE 20-24	LF SHARE 25-34	LF SHARE 35-44	LF SHARE 45-54	LF SHARE 55-64	LF SHARE 65+
% 0.06816192	    0.118210594	    0.239691958	    0.227484149	    0.194639995	    0.118291552	    0.033519832
avg_lf_share = [ (0.067613748+0.114089218)	0.237455049	0.228682514	0.195562158	0.120387512	0.036209801];

idx_ur = 1;
plot_style_estimated = 'o-';

FIGLABELS_UR = {'SHOULD NOT HAPPEN!','A. Unemployment Rate 16+  ','B. Unemployment Rate 16-24','C. Unemployment Rate 25-34','D. Unemployment Rate 35-44','E. Unemployment Rate 45-54','F. Unemployment Rate 55-64','G. Unemployment Rate 65+  '};
numrows =2;
numcols =3;
approx_digit = '%.3f';

%% IRFS Unemployment Rate by Age
for nvar = init_group:end_group
                  
            disp([ FIGLABELS_UR{nvar}  ' Impact : ' num2str(FF_SVARIV(1,idx_ur,nvar),approx_digit) '; 1-Lag  : ' num2str(FF_SVARIV(2,idx_ur,nvar),approx_digit) ])
            if nvar==2
                dur_agg =FF_SVARIV(:,idx_ur,nvar);
            else
                dur_age(:,nvar-init_group+1)=FF_SVARIV(:,idx_ur,nvar);
            end                
end

