

global RMsub manutrade trade t eta gamma alfa mu l aM aMs delta aA ksi1A ksi1M ksi1Ms ksi2 Lbar kappaq avTgr avMgr avAgr avTsgr avMsgr avAsgr fc aY aH ar tdum
global w rp rw rr zeta p_E Z_M Z_A Z_T zA zM Z_M_Mor Z_A_Mor c_M c_A p_M p_A M A L_T L_M L_Ms L_A L R_M R_Ms R_A phi_M phi_Ms phi_A theta Po_M Po_A ES_M Ubar RI AN AS phiMhat phiAhat LMMer LAAer LMmis
global nR_M nR_Ms nR_A nC xT infra T dT gammaT gain LTsub TTsub TS boldkappaq

%tic

%clear gain

Perms = nan(2^(nC-1),nC,nC);

Yl(:,1) = Z_M_Mor(:,t);
Yl(:,2) = Z_A_Mor(:,t);
Yl(:,3) = p_E(:);

Zp(1) = ksi1A;     %A innov. fixed cost
Zp(2) = ksi1M;      %M innov. fixed cost
Zp(3) = ksi1Ms;      %M slow innov. fixed cost

Zp(4) = beta;
Zp(5) = Lbar;
Zp(6) = T;
Zp(7) = mu;           %manu labour share (fix)
Zp(8) = alfa;         %agri labour share (fix)
Zp(9) = eta;          %agri exponent in preferences
Zp(10) = gamma;        %agri minimum
Zp(11) = ksi2;    %innov. marginal cost
Zp(12) = deltaA;
Zp(13) = deltaM;
Zp(14) = aM;          %manu Pareto coefficient
Zp(15) = aA;          %agri Pareto coefficient
Zp(16) = aMs;          %slow manu Pareto coefficient
Zp(17) = wuknorm;

%transport labour
Zp(18) = tdum; %1 is with tertiary labour
Zp(19) = zeta;
Zp(20) = rr;
Zp(21) = Z_T(t);

Zp(22) = t;

Zp(23) = RMsub;
Zp(24) = trade;
Zp(25) = LTsub;
Zp(26) = TTsub;

Zp(27) = boldkappaq;


RIhold1 = nan(size(Perms,1),1);
RIhold2 = nan(size(Perms,1),1);

%need pass all other vars here


for County = 1:nC
    
    tc = [t County]
    
    if County == 1 % initial permutations for counties other than 1
        
        Perms(:,2:nC,1) = dec2bin(0:(2^(nC-1))-1)-'0';   %permutations for counties other than 1
        
        % kappa candidates
        
        kappaperm = ones(length(l),length(Perms),2);
        for i=1:length(l)
            for j=1:length(Perms)
                if t==1
                    kappaperm(i,j,1) = (exp(-dT(t)*Perms(j,lCounty(i),County)))*kappaq(i,t);
                    kappaperm(i,j,2) = (exp(-dT(t)*Perms(j,lCounty(i),County)))*kappaq(i,t);
                    TSp(i,j,1) = TS(i,t)+dT(t)*Perms(j,lCounty(i),County);
                    TSp(i,j,2) = TS(i,t)+dT(t)*Perms(j,lCounty(i),County);
                else
                    kappaperm(i,j,1) = (exp(-dT(t)*Perms(j,lCounty(i),County)))*kappaq(i,t-1);
                    kappaperm(i,j,2) = (exp(-dT(t)*Perms(j,lCounty(i),County)))*kappaq(i,t-1);
                    TSp(i,j,1) = TS(i,t-1)+dT(t)*Perms(j,lCounty(i),County);
                    TSp(i,j,2) = TS(i,t-1)+dT(t)*Perms(j,lCounty(i),County);
                end
            end
        end
        
        % parfor on/off invest in county 1 in each perm
        
        [xC yC] = find(lCounty==County);
        
        for j=1:length(Perms)
            %run without invest at county given Perm for other counties
            for i = xC
                if t==1
                    kappaperm(i,j,1) = kappaq(i,t);
                    TSp(i,j,1) = TS(i,t);
                else
                    kappaperm(i,j,1) = kappaq(i,t-1);
                    TSp(i,j,1) = TS(i,t-1);
                end
            end
            
            %run with invest at county given Perm for other counties
            for i = xC
                if t==1
                    kappaperm(i,j,2) = (exp(-dT(t)))*kappaq(i,t);
                    TSp(i,j,2) = TS(i,t) + dT(t);
                else
                    kappaperm(i,j,2) = (exp(-dT(t)))*kappaq(i,t-1);
                    TSp(i,j,2) = TS(i,t-1) + dT(t);
                end
            end
        end
        
        parfor (j=1:length(Perms),parp)  %parfor if parp>0
            
            %Y1(:,1) = kappaperm(:,j,1);
            
            Y = [Yl kappaperm(:,j,1) TSp(:,j,1)];
            
            F=@(R)EISTinfrasys(R, Y, Zp);
            options=optimset('MaxFunEvals',1000000000,'TolFun',0.0001,'MaxIter',1000000,'Display','off');
            X = fsolve(F,X0,options);
            
            % evaluate with solution (http://www.mathworks.com/matlabcentral/answers/7443-additional-output-with-fsolve
            [X Xout] = F(X);
            
            thetap = Xout(:,1);
            R_Mp = Xout(:,2);
            R_Ap = Xout(:,3);
            wp = Xout(:,4);
            L_Tp = Xout(:,5);
            
            off(j) = (sum(thetap(xC).*(R_Mp(xC))) + sum((1-thetap(xC)).*R_Ap(xC)));
            
            Y = [Yl kappaperm(:,j,2) TSp(:,j,2)];
            
            F=@(R)EISTinfrasys(R, Y, Zp);
            options=optimset('MaxFunEvals',1000000000,'TolFun',0.0001,'MaxIter',1000000,'Display','off');
            X = fsolve(F,X0,options);
            
            [X Xout] = F(X);
            
            thetap = Xout(:,1);
            R_Mp = Xout(:,2);
            R_Ap = Xout(:,3);
            wp = Xout(:,4);
            L_Tp = Xout(:,5);
            
            on(j) = (sum(thetap(xC).*(R_Mp(xC))) + sum((1-thetap(xC)).*R_Ap(xC)));
            
            gain(t,j,County) = on(j)-off(j);
            
            %tcj=[t County j]
            
        end
        
        % calculate whether invest gain > xT
        
        for j = 1:length(Perms)
            if gain(t,j,County) > xT
                Perms(j,County,County) = 1;
            else
                Perms(j,County,County) = 0;
            end
        end
        
        % pass possible permutations to next county
        
        Prm = [Perms(:,1,County) nan(length(Perms),1) Perms(:,3:nC,County)];
        Prm(isnan(Prm))=inf;
        Prm = unique(Prm,'rows');
        Prm(isinf(Prm))=nan;
        
        Perms(1:length(Prm),:,2) = Prm;
        
    else
        
        nPerms = length(Perms)-sum(isnan(Perms(:,1,County)));
        
        clear kappaperm;
        
        % kappa candidates
        
        kappaperm = ones(length(l),nPerms,2);  %set perms in other counties
        for i=1:length(l)
            for j=1:nPerms
                if t==1
                    kappaperm(i,j,1) = (exp(-dT(t)*Perms(j,lCounty(i),County)))*kappaq(i,t);
                    kappaperm(i,j,2) = (exp(-dT(t)*Perms(j,lCounty(i),County)))*kappaq(i,t);
                    TSp(i,j,1) = TS(i,t)+dT(t)*Perms(j,lCounty(i),County);
                    TSp(i,j,2) = TS(i,t)+dT(t)*Perms(j,lCounty(i),County);
                else
                    kappaperm(i,j,1) = (exp(-dT(t)*Perms(j,lCounty(i),County)))*kappaq(i,t-1);
                    kappaperm(i,j,2) = (exp(-dT(t)*Perms(j,lCounty(i),County)))*kappaq(i,t-1);
                    TSp(i,j,1) = TS(i,t-1)+dT(t)*Perms(j,lCounty(i),County);
                    TSp(i,j,2) = TS(i,t-1)+dT(t)*Perms(j,lCounty(i),County);
                end
            end
        end
        
        % parfor on/off invest in county 1 in each perm
        
        [xC yC] = find(lCounty==County);
        
        for j=1:nPerms   %set perms in this county
            %run without invest at county given Perm for other counties
            for i = xC
                if t==1
                    kappaperm(i,j,1) = kappaq(i,t);
                    TSp(i,j,1) = TS(i,t);
                else
                    kappaperm(i,j,1) = kappaq(i,t-1);
                    TSp(i,j,1) = TS(i,t-1);
                end
            end
            
            %run with invest at county given Perm for other counties
            for i = xC
                if t==1
                    kappaperm(i,j,2) = (exp(-dT(t)))*kappaq(i,t);
                    TSp(i,j,2) = TS(i,t) + dT(t);
                else
                    kappaperm(i,j,2) = (exp(-dT(t)))*kappaq(i,t-1);
                    TSp(i,j,2) = TS(i,t-1) + dT(t);
                end
            end
        end
        
        if County<nC
            
            parfor (j=1:nPerms,parp)  %parfor if parp>0
                
                Y = [Yl kappaperm(:,j,1) TSp(:,j,1)];
                
                F=@(R)EISTinfrasys(R,Y,Zp);
                options=optimset('MaxFunEvals',1000000000,'TolFun',0.0001,'MaxIter',1000000,'Display','off');
                X = fsolve(F,X0,options);
                
                % using this trick: http://www.mathworks.com/matlabcentral/answers/7443-additional-output-with-fsolve
                [X, Xout1, Xout2] = F(X);
                
                thetap = Xout1(:,1);
                R_Mp = Xout1(:,2);
                R_Ap = Xout1(:,3);
                wp = Xout1(:,4);
                L_Tp = Xout1(:,5);
                
                off(j) = (sum(thetap(xC).*(R_Mp(xC))) + sum((1-thetap(xC)).*R_Ap(xC)));
                % at final county, track RI across permutations
                
                Y = [Yl kappaperm(:,j,2) TSp(:,j,1)];
                
                F=@(R)EISTinfrasys(R, Y, Zp);
                options=optimset('MaxFunEvals',1000000000,'TolFun',0.0001,'MaxIter',1000000,'Display','off');
                X = fsolve(F,X0,options);
                
                [X, Xout1, Xout2] = F(X);
                
                thetap = Xout1(:,1);
                R_Mp = Xout1(:,2);
                R_Ap = Xout1(:,3);
                wp = Xout1(:,4);
                L_Tp = Xout1(:,5);
                
                
                on(j) = (sum(thetap(xC).*(R_Mp(xC))) + sum((1-thetap(xC)).*R_Ap(xC)));
                
                gain(t,j,County) = on(j)-off(j);
                
                %tcj=[t County j]
            end
        else
            for j=1:nPerms  % at final county, track RI across perms
                
                Y = [Yl kappaperm(:,j,1) TSp(:,j,1)];
                
                F=@(R)EISTinfrasys(R,Y,Zp);
                options=optimset('MaxFunEvals',1000000000,'TolFun',0.0001,'MaxIter',1000000,'Display','off');
                X = fsolve(F,X0,options);
                
                % using this trick: http://www.mathworks.com/matlabcentral/answers/7443-additional-output-with-fsolve
                [X, Xout1, Xout2] = F(X);
                
                thetap = Xout1(:,1);
                R_Mp = Xout1(:,2);
                R_Ap = Xout1(:,3);
                wp = Xout1(:,4);
                L_Tp = Xout1(:,5);
                
                RIhold1(j) = Xout2;
                
                off(j) = (sum(thetap(xC).*(R_Mp(xC))) + sum((1-thetap(xC)).*R_Ap(xC)));
                
                Y = [Yl kappaperm(:,j,2) TSp(:,j,1)];
                
                F=@(R)EISTinfrasys(R, Y, Zp);
                options=optimset('MaxFunEvals',1000000000,'TolFun',0.0001,'MaxIter',1000000,'Display','off');
                X = fsolve(F,X0,options);
                
                [X, Xout1, Xout2] = F(X);
                
                thetap = Xout1(:,1);
                R_Mp = Xout1(:,2);
                R_Ap = Xout1(:,3);
                wp = Xout1(:,4);
                L_Tp = Xout1(:,5);
                
                RIhold2(j) = Xout2;
                
                on(j) = (sum(thetap(xC).*(R_Mp(xC))) + sum((1-thetap(xC)).*R_Ap(xC)));
                
                gain(t,j,County) = on(j)-off(j);
                
                %tcj=[t County j]
            end
        end
        
        % calculate whether invest gain > xT
        
        for j = 1:nPerms
            if gain(t,j,County) > xT
                Perms(j,County,County) = 1;
            else
                Perms(j,County,County) = 0;
            end
        end
        
        
        % pass possible permutations to next county
        if County < nC
            
            %knock out Perms not in previous Perms
            for j=1:nPerms
                if isempty(find(ismember(Perms(:,:,(County-1)),Perms(j,:,County),'rows'),1)) == 1
                    Perms(j,:,County) = NaN;
                    %Perms(:,:,County) = [Perms(1:j-1,:,County); Perms(j+1:size(Perms,1),:,County); nan(1,nC)];
                end
            end
            
            %consolidate to unique remaining Perms
            
            Prm = [Perms(:,1:(County),County) nan(length(Perms),1) Perms(:,(County+2):nC,County)];
            Prm(isnan(Prm))=inf;
            Prm = unique(Prm,'rows');
            Prm(isinf(Prm))=nan;
            Prm=Prm(1:(size(Prm,1)-1),:);
            
            %pass to next County
            Perms(1:size(Prm,1),:,County+1) = Prm;
        end
        
        % if at last County, select among Perms by RI
        
        if County == nC
            
            %knock out Perms not in previous Perms
            for j=1:nPerms
                if isempty(find(ismember(Perms(:,:,(County-1)),Perms(j,:,County),'rows'),1)) == 1
                    Perms(j,:,County) = NaN;
                    %Perms(:,:,County) = [Perms(1:j-1,:,County); Perms(j+1:size(Perms,1),:,County); nan(1,nC)];
                    %RIhold1 = [RIhold1(1:j-1); RIhold1(j+1:size(RIhold1,1)); NaN];
                    %RIhold2 = [RIhold2(1:j-1); RIhold2(j+1:size(RIhold2,1)); NaN];
                end
            end
            
            if nPerms == 1
                jp=1;
            else
                maxRI = 0;
                for i=1:nPerms
                    if Perms(i,County,County) == 0
                        if RIhold1(i) > maxRI
                            jp=i;
                            maxRI = RIhold1(i);
                        end
                    else
                        if RIhold2(i) > maxRI
                            jp=i;
                            maxRI = RIhold2(i);
                        end
                    end
                end
            end
        end
    end
end

if isnan(Perms(jp,1,nC)) == 1  %if there is no solution, set infra to zero
    Perms(jp,:,nC) = 0;
end

% pass infra and kappa back to main

for i=1:length(l)
    if t == 1
        TS(i,t) = TS(i,t) + dT(t)*Perms(jp,lCounty(i),nC);
        kappaq(i,t) = kappaq(i,t)*(exp(-dT(t)*Perms(jp,lCounty(i),nC)));
    else
        TS(i,t) = TS(i,t-1) + dT(t)*Perms(jp,lCounty(i),nC);
        kappaq(i,t) = kappaq(i,t-1)*(exp(-dT(t)*Perms(jp,lCounty(i),nC)));
    end
    infradum(i,t) = Perms(jp,lCounty(i),nC);
end

Perms(jp,:,nC)

%toc