/********************************* 

Net present value calculations for Charging Ahead
AEJ:Applied
See readme.txt file for further detail

*********************************/

********************************
* Preliminaries 
********************************

set more off
clear all
set matsize 1000
set seed 5925169

/* 
* cap cd // change user directory

* ssc install boottest // user written command for wild bootstrap

* Set macros

global resdir  // destination for tables and figures
global bootrep 500 // change to desired number 

* Read in analysis file

use "../workingdata_analysis.dta", clear

*/

********************************
* Main NPV estimates and SEs
********************************


// Table 5 //

** Estimate inputs to NPV calculation

			cap file close iv1
				file open iv1 using ///
					"$resdir/MP_PV.tex", ///
					write text replace
				file write iv1 "\begin{tabular}{l cc}"	_n
				file write iv1 "\hline" _n
				file write iv1 " & Postpaid & Prepaid \\ " _n
				file write iv1 "  \hline" _n
				file write iv1 " \\" _n

preserve

	drop if switchmonthD == 1
	keep if shortrun == 1
	
	xi:xtivreg revenue (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen rev_0 = _b[1._at]
	local rev_0 : display %-4.2f _b[1._at]
	local se_0  : display %-4.2f _se[1._at]
	gen rev_1 = _b[2._at]
	local rev_1 : display %-4.2f _b[2._at]
	local se_1  : display %-4.2f _se[2._at]
	
	
	file write iv1 " & \multicolumn{2}{c}{Revenue estimate} \\ " _n
			
	file write iv1 "Revenue $(pq^m)$ & `rev_0' & `rev_1' \\ " _n
	file write iv1 " & (`se_0') & (`se_1') \\ " _n

	file write iv1 " \hline " _n
	file write iv1 " \\ " _n

	
	xi:xtivreg timing (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen timing_0 = _b[1._at]
	local timing_0 : display %-4.2f _b[1._at]
	local se_0  : display %-4.2f _se[1._at]
	gen timing_1 = _b[2._at]
	local timing_1 : display %-4.2f _b[2._at]
	local se_1  : display %-4.2f _se[2._at]


	file write iv1 " & \multicolumn{2}{c}{Payment timing estimate} \\ " _n
			
	file write iv1 "Months since consumption $(s^m)$ & `timing_0' & `timing_1' \\ " _n
	file write iv1 " & (`se_0') & (`se_1') \\ " _n
	file write iv1 " \hline " _n
	file write iv1 " \\ " _n

		
	xi:xtivreg cost (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen cost_0 = _b[1._at]
	local cost_0 : display %-4.2f _b[1._at]
	local se_0  : display %-4.2f _se[1._at]
	gen cost_1 = _b[2._at]
	local cost_1 : display %-4.2f _b[2._at]
	local se_1  : display %-4.2f _se[2._at]


	file write iv1 " & \multicolumn{2}{c}{Cost estimate} \\ " _n
			
	file write iv1 "Cost $(cq^m + b^m)$ & `cost_0' & `cost_1' \\ " _n
	file write iv1 " & (`se_0') & (`se_1') \\ " _n
	file write iv1 "Includes: & & \\ " _n
	file write iv1 "- Meter reading & 0.91 & 0 \\ " _n
	file write iv1 "- Billing & 0.85 & 0 \\ " _n
	file write iv1 "- Vendor commission & 0 & 0.002/kWh \\ " _n
	file write iv1 "- Losses (percent) & 11.25 & 11.25 \\ " _n
	file write iv1 "- Disconnections & 90 & 0 \\ " _n
	file write iv1 " \hline " _n
	file write iv1 "\\"
	
	sum rev_* cost_* timing_*

	gen NPV_0 = 0 
	gen NPV_1 = 0
	
	cap gen i = .
	replace i = 1+.00643 // annual rate of 8%
	
	
	
		forval m = 0/1 {
	
		replace NPV_`m' = NPV_`m' + (rev_`m' / (i^(1+timing_`m'))) - ((cost_`m') / (i ^ 1)) 
		
		}

	
	gen NPV_diff = NPV_1 / abs(NPV_0)	
	sum NPV_0 
	local pv_0 : display %-4.2f `r(mean)'
	sum NPV_1 
	local pv_1 : display %-4.2f `r(mean)'
	sum NPV_diff
	
	file write iv1 "Present value & `pv_0' & `pv_1' \\ " _n
	
restore

// Standard errors // 

local r = 100 

* program for postpaid
xtset, clear

capture program drop myboot0
program define myboot0, rclass
preserve

	bsample, cluster(id) idcluster(newid)
	xtset newid monthyear
 
	xtivreg revenue (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post

	gen rev_0 = _b[1._at]
	gen rev_1 = _b[2._at]
	
	xtivreg cost (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen cost_0 = _b[1._at]
	gen cost_1 = _b[2._at]
	
	xtivreg timing (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen timing_0 = _b[1._at]
	gen timing_1 = _b[2._at]
		
	keep if _n == 1
	sum rev_* cost_* timing_*


	gen NPV_0 = 0 
	gen NPV_1 = 0
	gen NPV_diff = .
	
	gen i = 1+.00643 
	

		forval m = 0/1 {
	
		replace NPV_`m' = NPV_`m' + (rev_`m' / (i^(1+timing_`m'))) - ((cost_`m') / (i ^ 1)) 
		
		}
		replace NPV_diff = (NPV_1) / abs(NPV_0)	
	
	sum NPV_0
    return scalar NPV = r(mean)
   restore
   
end 

* same program for prepaid
xtset, clear
capture program drop myboot1
program define myboot1, rclass
preserve

	bsample, cluster(id) idcluster(newid)
	xtset newid monthyear
 
	xtivreg revenue (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post

	gen rev_0 = _b[1._at]
	gen rev_1 = _b[2._at]
	
	xtivreg cost (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen cost_0 = _b[1._at]
	gen cost_1 = _b[2._at]
	
	xtivreg timing (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen timing_0 = _b[1._at]
	gen timing_1 = _b[2._at]
		
	keep if _n == 1
	sum rev_* cost_* timing_*

	gen NPV_0 = 0 
	gen NPV_1 = 0
	gen NPV_diff = .
	
	gen i = 1+.00643 
	

		forval m = 0/1 {
	
		replace NPV_`m' = NPV_`m' + (rev_`m' / (i^(1+timing_`m'))) - ((cost_`m') / (i ^ 1)) 
		
		}
		replace NPV_diff = (NPV_1) / abs(NPV_0)	
	
	sum NPV_1
    return scalar NPV = r(mean)
   restore
   
end 


cap file close NPV_diff
file open NPV_diff using "$IN/Data/admin_data/NPV_diff.txt", write text replace
file write NPV_diff "Characteristic" _tab "decile" _tab "observed" _tab "bootstrap" ///
	_tab "se" _tab "ci normal lb" _tab "ci normal ub" _tab "ci bias lb" _tab "ci bias ub" _n
file close NPV_diff

xtset id monthyear 

foreach i in 0 1 {

tempfile all_v
save `all_v', replace

drop if switchmonth == monthyear
keep if shortrun == 1
cap drop rev_* cost_* timing_* NPV* i

// get the observed statistic

	xtivreg revenue (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen rev_0 = _b[1._at]
	gen rev_1 = _b[2._at]
	
	xtivreg cost (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen cost_0 = _b[1._at]
	gen cost_1 = _b[2._at]
	
	xtivreg timing (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen timing_0 = _b[1._at]
	gen timing_1 = _b[2._at]
	
	sum rev_* cost_* timing_*

	gen NPV_0 = 0 
	gen NPV_1 = 0
	gen NPV_diff = .
	
	gen i = 1+.00643 

		forval m = 0/1 {
	
		replace NPV_`m' = NPV_`m' + (rev_`m' / (i^(1+timing_`m'))) - ((cost_`m') / (i ^ 1)) 
		
		}
		replace NPV_diff = (NPV_1) / abs(NPV_0)	
	
	sum NPV_`i'
	
	local observed = r(mean)
	local n = r(N)

drop NPV_* i rev_* cost_* timing_*

* bootstrap SEs for each meter type estimate

simulate mean=r(NPV), seed(5925169) reps(`r') : myboot`i'

bstat, stat(`observed') n(`n')

local b 	: display %-4.3f _b[mean]
local se 	: display %-4.3f _se[mean]
matrix bs = e(b_bs)
local bs 	= bs[1,1]
matrix ci_n = e(ci_normal)
local ci_n_lb = ci_n[1,1]
local ci_n_ub = ci_n[2,1]
matrix ci_b = e(ci_bc)
local ci_b_lb = ci_b[1,1]
local ci_b_ub = ci_b[2,1]

cap file close NPV_diff
file open NPV_diff using "$IN/Data/admin_data/NPV_diff.txt", write text append

file write NPV_diff "NPV_`i'" _tab "" _tab "`b'" _tab "`bs'" _tab ///
	"`se'" _tab "`ci_n_lb'" _tab "`ci_n_ub'" _tab "`ci_b_lb'" _tab "`ci_b_ub'" _n
	
file close NPV_diff

use `all_v', replace
}

// Put it all together in table
				
preserve
	
	insheet using "$IN/Data/admin_data/NPV_diff.txt", tab clear names
	drop if characteristic == "Characteristic"
	destring se, replace
	sum se if characteristic == "NPV_0"
	local se_0 : display %-4.2f `r(mean)'
	sum se if characteristic == "NPV_1"
	local se_1 : display %-4.2f `r(mean)'
	
	file write iv1 " & (`se_0') & (`se_1') \\ " _n
	file write iv1 " \hline " _n
	file write iv1 "\end{tabular}" _n
	file close iv1
	
restore



********************************
* NPV est under diff assumptions 
********************************

// Different annual rates

cap file close NPV_int
file open NPV_int using "$IN/Data/admin_data/NPV_int.txt", write text replace

file write NPV_int "rate" _tab "NPV_0" _tab "NPV_1"  _n

// interests rates from 0 to 25% annual, in intervals of 3%

foreach int of numlist 0 0.00247 0.00487 0.00721 0.00949 0.01171 0.01389 0.01601 0.01877 {

preserve

	drop if switchmonth == monthyear
	keep if shortrun == 1
	
	xi:xtivreg revenue (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen rev_0 = _b[1._at]
	gen rev_1 = _b[2._at]
	
	xi:xtivreg cost (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen cost_0 = _b[1._at]
	gen cost_1 = _b[2._at]
	
	xi:xtivreg timing (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen timing_0 = _b[1._at]
	gen timing_1 = _b[2._at]

	keep if _n == 1
	sum rev_* cost_* timing_*


	gen NPV_0 = 0 
	gen NPV_1 = 0
	
	gen i = 1+`int' 

		forval m = 0/1 {
	
		replace NPV_`m' = NPV_`m' + (rev_`m' / (i^(1+timing_`m'))) - ((cost_`m') / (i ^ 1)) 
		
		}
	
	sum i
	local i = r(mean)
	sum NPV_0
	local post = r(mean)
	sum NPV_1 
	local pre = r(mean)
	
	file write NPV_int "`i'" _tab "`post'" _tab "`pre'"  _n
restore
}

cap file close NPV_int


// Different average marginal cost //

cap file close NPV_cost
file open NPV_cost using "$IN/Data/admin_data/NPV_cost.txt", write text replace

file write NPV_cost "mcX" _tab "NPV_0" _tab "NPV_1"  _n

foreach cost of numlist 0 0.5 1 1.5 2 2.5 3 {

preserve

	drop if switchmonth == monthyear
	keep if shortrun == 1
	replace cost = 1.1125 * mcons_30 * mc * `cost'
	label var cost "Average supply cost including recovery"

	replace cost = cost + 90 if disconnection_cr == 1 
	replace cost = cost + 1.74*(1-pp) // billing costs for postpaid
	replace cost = cost + (mcons_30 * vendor * pp)
	
	xi:xtivreg revenue (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen rev_0 = _b[1._at]
	gen rev_1 = _b[2._at]
	
	xi:xtivreg cost (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen cost_0 = _b[1._at]
	gen cost_1 = _b[2._at]
	
	xi:xtivreg timing (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen timing_0 = _b[1._at]
	gen timing_1 = _b[2._at]
	

	keep if _n == 1
	sum rev_* cost_* timing_*


	gen NPV_0 = 0 
	gen NPV_1 = 0
	
	gen i = 1+0.00643 
	
		forval m = 0/1 {
	
		replace NPV_`m' = NPV_`m' + (rev_`m' / (i^(1+timing_`m'))) - ((cost_`m') / (i ^ 1)) 
		
		}
	

	sum NPV_0
	local post = r(mean)
	sum NPV_1 
	local pre = r(mean)
	
	file write NPV_cost "`cost'" _tab "`post'" _tab "`pre'"  _n
restore
}

cap file close NPV_cost



// Different impact on losses //


cap file close NPV_loss
file open NPV_loss using "$IN/Data/admin_data/NPV_loss.txt", write text replace

file write NPV_loss "lossX" _tab "NPV_0" _tab "NPV_1"  _n

foreach loss of numlist 0 1 2 3 4 {

preserve

	drop if switchmonth == monthyear
	keep if shortrun == 1
	replace cost = (1 + .1125) * mcons_30 * mc
	replace cost = (1 + (.1125 * `loss')) * mcons_30 * mc if pp == 1
	label var cost "Average supply cost including recovery"

	replace cost = cost + 90 if disconnection_cr == 1 
	replace cost = cost + 1.74*(1-pp) // billing costs for postpaid
	replace cost = cost + (mcons_30 * vendor * pp)
	
	xi:xtivreg revenue (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen rev_0 = _b[1._at]
	gen rev_1 = _b[2._at]
	
	xi:xtivreg cost (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen cost_0 = _b[1._at]
	gen cost_1 = _b[2._at]
	
	xi:xtivreg timing (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen timing_0 = _b[1._at]
	gen timing_1 = _b[2._at]
	

	keep if _n == 1
	sum rev_* cost_* timing_*


	gen NPV_0 = 0 
	gen NPV_1 = 0
	
	gen i = 1+0.00643 
	

		forval m = 0/1 {
	
		replace NPV_`m' = NPV_`m' + (rev_`m' / (i^(1+timing_`m'))) - ((cost_`m') / (i ^ 1)) 
		
		}
	

	sum NPV_0
	local post = r(mean)
	sum NPV_1 
	local pre = r(mean)
	
	file write NPV_loss "`loss'" _tab "`post'" _tab "`pre'"  _n
restore
}

cap file close NPV_loss

 
// Figure A.10 // 

preserve

	* by interest rate
	
	insheet using "$IN/Data/admin_data/NPV_int.txt", tab clear
	gen annual = ((_n-1)*3) / 100
	
	twoway (line npv_0 annual) (line npv_1 annual , lpattern(dash)) , ///
		xtitle(Annual interest rate) ytitle(Monthly net revenue (USD2014)) ///
		legend(order(1 "Postpaid" 2 "Prepaid" )) xline(0.08, lpattern(dot) lcolor(black)) ///
		graphregion(fcolor(white) lcolor(white))
		
		graph export "$resdir/MP_NPVvsinterest.pdf", replace

	
	* by marginal cost
	
	insheet using "$IN/Data/admin_data/NPV_cost.txt", tab clear
	
	twoway (line npv_0 mcx) (line npv_1 mcx , lpattern(dash)) , ///
		xtitle(X times marginal costs (USD)) ytitle(Monthly net revenue (USD2014)) ///
		legend(order(1 "Postpaid" 2 "Prepaid" )) xline(1, lpattern(dot) lcolor(black)) ///
		graphregion(fcolor(white) lcolor(white))
		
		graph export "$resdir/MP_NPVvscost.pdf", replace

	
	* by loss
	
	insheet using "$IN/Data/admin_data/NPV_loss.txt", tab clear
	
	twoway (line npv_0 lossx) (line npv_1 lossx , lpattern(dash)) , ///
		xtitle(Prepaid impact on losses (USD)) ytitle(Monthly net revenue (USD2014)) ///
		legend(order(1 "Postpaid" 2 "Prepaid" )) xline(1, lpattern(dot) lcolor(black)) ///
		graphregion(fcolor(white) lcolor(white))
		
		graph export "$resdir/MP_NPVvsloss.pdf", replace

restore



********************************
* NPV heterogeneity
********************************

cap file close NPV_het
file open NPV_het using "$IN/Data/admin_data/NPV_het.txt", write text replace // replace

file write NPV_het "Result" _tab "Shortrun" _tab "Characteristic" _tab "High" _tab "observed" _tab "bootstrap" ///
	_tab "se" _tab "ci normal lb" _tab "ci normal ub" _tab "ci bias lb" _tab "ci bias ub" _n

tempfile orig
save `orig', replace

xtset, clear

* block bootstrap SEs
capture program drop boot
program define boot, rclass
preserve

	bsample, cluster(id) idcluster(newid)
	xtset newid monthyear
 
	xtivreg revenue (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen rev_0 = _b[1._at]
	gen rev_1 = _b[2._at]
	
	xtivreg cost (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen cost_0 = _b[1._at]
	gen cost_1 = _b[2._at]
	
	xtivreg timing (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
	margins, at(pp = (0 1)) post
	gen timing_0 = _b[1._at]
	gen timing_1 = _b[2._at]
	
	keep if _n == 1
	sum rev_* cost_* timing_*


	gen NPV_0 = 0 
	gen NPV_1 = 0
	gen NPV_diff = .
	
	gen i = 1+.00643 
	
		forval m = 0/1 {
	
		replace NPV_`m' = NPV_`m' + (rev_`m' / (i^(1+timing_`m'))) - ((cost_`m') / (i ^ 1)) 
		
		}
		
		replace NPV_diff = NPV_1 / abs(NPV_0)
	
	
	sum NPV_diff
    return scalar NPV = r(mean)

	restore
   
end


* observed stats
drop if switchmonth == monthyear

	xtset, clear
	
	tempfile all
	save `all', replace
	
foreach var of varlist mlifeline_switch below_medkwh pval300 outstanding1 usuallylate ever_disconnected_cr { //  
	
	keep if shortrun == 1

		forval h = 0/1 {
		
				di "var is `var'"
				di "q is `q'"
	
				keep if `var' == `h'
				
							xtset id monthyear
							
							xtivreg revenue (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
							margins, at(pp = (0 1)) post
							gen rev_0 = _b[1._at]
							gen rev_1 = _b[2._at]
							
							xtivreg cost (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
							margins, at(pp = (0 1)) post
							gen cost_0 = _b[1._at]
							gen cost_1 = _b[2._at]
							
							xtivreg timing (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
							margins, at(pp = (0 1)) post
							gen timing_0 = _b[1._at]
							gen timing_1 = _b[2._at]
						
							sum rev_* cost_* timing_*
							
						
							gen NPV_0 = 0  
							gen NPV_1 = 0
							gen NPV_diff = .
							
							gen i = 1+.00643 
							
								forval m = 0/1 {
							
								replace NPV_`m' = NPV_`m' + (rev_`m' / (i^(1+timing_`m'))) - ((cost_`m') / (i ^ 1)) 
								
								}
								replace NPV_diff = NPV_1 / abs(NPV_0)
							
							
							sum NPV_diff
							
							local observed = r(mean)
							local n = r(N)
						
							drop NPV_* i rev_* cost_* timing_*
							
				xtset, clear
				simulate mean=r(NPV), seed(5925169) reps(`r') : boot
	
				bstat, stat(`observed') n(`n')
				
				local b 	: display %-4.3f _b[mean]
				local se 	: display %-4.3f _se[mean]
				matrix bs = e(b_bs)
				local bs 	= bs[1,1]
				matrix ci_n = e(ci_normal)
				local ci_n_lb = ci_n[1,1]
				local ci_n_ub = ci_n[2,1]
				matrix ci_b = e(ci_bc)
				local ci_b_lb = ci_b[1,1]
				local ci_b_ub = ci_b[2,1]
				
				file write NPV_het "NPV_diff" _tab "`shortrun'" _tab "`var'" _tab "`h'" _tab "`b'" _tab "`bs'" _tab ///
					"`se'" _tab "`ci_n_lb'" _tab "`ci_n_ub'" _tab "`ci_b_lb'" _tab "`ci_b_ub'" _n
		
						
				use `all', clear
			
				} 
				
	} 

file close NPV_het 


// Figure 5 and Table A.9 // 

preserve

drop if switchmonthD == 1
keep if shortrun == 1

cap file close NPV_het_base
file open NPV_het_base using "$IN/Data/admin_data/NPV_het_base.txt", write text replace

file write NPV_het_base "Characteristic" _tab "high" _tab "NPV_0" _tab "NPV_1" _n

	
foreach var of varlist mlifeline_switch below_medkwh pval300 outstanding1 usuallylate ever_disconnected_cr { 

	xtset, clear
	
	tempfile all
	save `all', replace

	forval h = 0/1 {
	
			di "var is `var'"
			di "q is `q'"

			keep if `var' == `h'
			
						xtset id monthyear
						
						xtivreg revenue (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
						margins, at(pp = (0 1)) post
					
						gen rev_0 = _b[1._at]
						gen rev_1 = _b[2._at]
						
						xtivreg cost (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
						margins, at(pp = (0 1)) post
						gen cost_0 = _b[1._at]
						gen cost_1 = _b[2._at]
						
						xtivreg timing (pp = c.group#mp#monthyear) i.monthyear lifeline tariff_error, fe vce(cluster group)
						margins, at(pp = (0 1)) post
						gen timing_0 = _b[1._at]
						gen timing_1 = _b[2._at]
					
						sum rev_* cost_* timing_*
					
						gen NPV_0 = 0 
						gen NPV_1 = 0
						gen NPV_diff = .
						
						gen i = 1+.00643 
						
						
							forval m = 0/1 {
						
							replace NPV_`m' = NPV_`m' + (rev_`m' / (i^(1+timing_`m'))) - ((cost_`m') / (i ^ 1)) 
							
							}
							replace NPV_diff = (NPV_1 ) / abs(NPV_0)
						
						
						sum NPV_0
						local NPV_0 : display %8.0fc `r(mean)'
						
						sum NPV_1
						local NPV_1 : display %8.0fc `r(mean)'
			
			file write NPV_het_base "`var'" _tab "`h'" _tab "`NPV_0'" _tab "`NPV_1'" _n
		
			use `all', clear
			
		} 
	
	} 

file close NPV_het_base 
	
restore

preserve

	insheet using "$IN/Data/admin_data/NPV_het_base.txt", tab clear

	tempfile het
	save `het', replace

	insheet using "$IN/Data/admin_data/NPV_het.txt", tab clear
	sort characteristic high shortrun
	merge m:1 characteristic high using `het'
		
	gen x = . 
	replace x = 1 if characteristic == "mlifeline_switch" & high == 0
	replace x = 2 if characteristic == "mlifeline_switch" & high == 1
	
	replace x = 4 if characteristic == "below_medkwh" & high == 0
	replace x = 5 if characteristic == "below_medkwh" & high == 1
	
	replace x = 7 if characteristic == "pval300" & high == 0
	replace x = 8 if characteristic == "pval300" & high == 1
		
	replace x = 10 if characteristic == "usuallylate" & high == 0
	replace x = 11 if characteristic == "usuallylate" & high == 1
	
	replace x = 13 if characteristic == "outstanding1" & high == 0
	replace x = 14 if characteristic == "outstanding1" & high == 1
	
	replace x = 16 if characteristic == "ever_disconnected_cr" & high == 0
	replace x = 17 if characteristic == "ever_disconnected_cr" & high == 1
	
	gen label = -.2

		
		twoway (bar observed x,  barwidth(.75)) (rcap cinormallb cinormalub x, ) ///
			(scatter label x,  mlabel(npv_0)  mlabcolor(black) msymbol(none) mlabposition(6) ), ///
			yline(1, lcolor(black) lpattern(dash)) yline(0, lcolor(black)) yscale(range(-0.5(.5)5)) xtitle("") ///
			ylabel(-0.4 "Postpaid PV" 0 "0" 1 "100%" 2 "200%" 3 "300%" 4 "400%" 5 "500%", angle(0) labsize(small) noticks nogrid) ///
			xlabel(1 "Domestic" 2 "Lifeline" 4 "High kWh" 5 "Low kWh" 7 "High prop val" 8 "Low prop val" ///
			10 "Usually on time" 11 "Usually late" 13 "No debts" 14 "Outstanding debts" 16 "Never disconnected" 17 "Disconnected" ///
			, angle(90))  ytitle("Prepaid returns relative to postpaid") legend(off)  graphregion(fcolor(white) lcolor(white)) 
			
			graph export "$resdir/NPV_het.pdf", replace	



		cap file close het
        file open het using "$resdir/MP_NPV_het.tex", write text replace
        file write het "\begin{tabular}{l cc} " _n
        file write het "\hline" _n
        file write het " & Average returns & Relative returns \\ " _n
        file write het " & Postpaid & Pre / Post \\ \hline " _n

        file write het " \\" _n
		
		cap destring npv_0, replace ignore(",")
		
		foreach char in mlifeline_switch below_medkwh pval300 usuallylate outstanding1 ever_disconnected_cr {
			forval h = 0/1 {
				sum observed if characteristic == "`char'" & high == `h'
                local b`char'`h' : display %-9.2f `r(mean)'
                sum se if characteristic == "`char'" & high == `h'
                local se`char'`h' : display %-4.2f `r(mean)'
				
				sum npv_0 if characteristic == "`char'" & high == `h'
				local v`char'`h' : display %-9.0fc `r(mean)'
				
				}
			}
			
		
		file write het "Domestic & `vmlifeline_switch0' & `bmlifeline_switch0' \\ " _n
		file write het " & & (`semlifeline_switch0') \\ " _n
		file write het "Lifeline & `vmlifeline_switch1' & `bmlifeline_switch1' \\ " _n
		file write het " & & (`semlifeline_switch1') \\ " _n
		file write het " \\ " _n
		file write het "Above median kWh & `vbelow_medkwh0' & `bbelow_medkwh0' \\ " _n
		file write het " & & (`sebelow_medkwh0') \\ " _n
		file write het "Below median kWh & `vbelow_medkwh1' & `bbelow_medkwh1' \\ " _n
		file write het " & & (`sebelow_medkwh1') \\ " _n
		file write het " \\ " _n
		file write het "High prop value & `vpval3000' & `bpval3000' \\ " _n
		file write het " & & (`sepval3000') \\ " _n
		file write het "Low prop value & `vpval3001' & `bpval3001' \\ " _n
		file write het " & & (`sepval3001') \\ " _n
		file write het " \\ " _n
		file write het "Usually on time & `vusuallylate0' & `busuallylate0' \\ " _n
		file write het " & & (`seusuallylate0') \\ " _n
		file write het "Usually late & `vusuallylate1' & `busuallylate1' \\ " _n
		file write het " & & (`seusuallylate1') \\ " _n
		file write het " \\ " _n
		file write het "No debts & `voutstanding10' & `boutstanding10' \\ " _n
		file write het " & & (`seoutstanding10') \\ " _n
		file write het "Outstanding debts & `voutstanding11' & `boutstanding11' \\ " _n
		file write het " & & (`seoutstanding11') \\ " _n
		file write het " \\ " _n
		file write het "Never disconnected & `vever_disconnected_cr0' & `bever_disconnected_cr0' \\ " _n
		file write het " & & (`seever_disconnected_cr0') \\ " _n
		file write het "Ever disconnected & `vever_disconnected_cr1' & `bever_disconnected_cr1' \\ " _n
		file write het " & & (`seever_disconnected_cr1') \\ " _n
		file write het " \hline " _n
		file write het "\end{tabular}" _n
		file close het		
			
restore
