
* create frequency data
cap program drop donow1
program define donow1
use if age<=65 using "${dir3}mergedCF1_noPA", clear
bysort id: egen tot=count(year)
keep if tot!=. & tot!=1
drop tot
bysort CF1 c_b year: egen pippo=count(year)
bysort CF1 c_b: egen fr_c_new=median(pippo)
collapse (mean) fr_c_new, by(c_b p_b r_b CF1)
save "${dir3}fr_c_new.dta", replace

* load data
use "${dir3}INPS_temp_noPA.dta", clear
keep if age<=65
drop if year==2012

g empl=n_paid_m>0 if n_paid_m<.
for any empl n_paid_m tot_wg : replace X=.  if age==.
bysort id: egen sum_empl=sum(empl)
drop if sum_empl==0 | sum_empl==.
bysort id: egen sum_tot_wg=sum(tot_wg)
drop if sum_tot_wg==0 | sum_tot_wg==.
drop sum*

merge m:1 f_id using "${dir3}sectors.dta", keep(master matched) keepusing(sector_pellegrino pellegrino ateco81)
drop _m
replace pellegrino=.03197188 if ateco81==24
replace sector_pellegrino=2 if ateco81==24
drop sector_pellegrino ateco81 
gen sector_pellegrino=.
replace sector_pellegrino=1 if pellegrino<0.03
replace sector_pellegrino=2 if pellegrino>=0.03 & pellegrino!=.
drop pellegrino

rename c_bth_i codice_comune_istat_num103
merge m:1 codice_comune_istat_num103 using "${dir1}DEMO_cat.dta",keep(master matched) keepusing(c_exp_discr_avg_pp)
rename  codice_comune_istat_num103 c_bth_i
gen spending=.
replace spending=1 if c_exp_discr_avg_pp<=629365
replace spending=2 if c_exp_discr_avg_pp>629365 & c_exp_discr_avg_pp!=.
drop c_exp_discr_avg_pp

cap drop yob
g yob=year-age

cap drop _m
merge m:1 CF1 r_bth_i p_bth_i c_bth_i year using "${dir1}POL19852011_cat_CF1.dta", keepusing(n_pols_ing n_pols_ing_p_n n_pols_ing_p_r n_pols_ing_p_p n_pols_ing_p_c n_pols_ing_p_mal_young n_pols_ing_p_mal_mid n_pols_ing_p_mal_old n_pols_ing_p_fem_young n_pols_ing_p_fem_mid n_pols_ing_p_fem_old n_pols_ing_p_top n_pols_ing_p_cou n_pols_ing_p_ten_c_t_01 n_pols_ing_p_ten_c_t_12 n_pols_ing_p_ten_c_t_gt2 n_pols_out) keep(master matched)
rename n_pols_ing n_pols_ing_p_tot
gen age1=age>=16 & age<=35
gen age2=age>=36 & age<=55
gen age3=age>=56 & age<=65
gen n_pols_ing_p_young=n_pols_ing_p_tot*age1
gen n_pols_ing_p_mid=n_pols_ing_p_tot*age2
gen n_pols_ing_p_old=n_pols_ing_p_tot*age3
end

cap program drop donow2
program define donow2
bysort id: egen max_m=max(_m)
keep if max_m==3
drop max_m
rename n_pols_ing_p_${var} n_pols_ing

for any n_pols_ing : replace X=0 if _m==1
rename r_bth_i r_b
rename p_bth_i p_b

* rescale by fr_c in the sample
cap drop _m
merge m:1 CF1 r_b p_b c_b using "${dir3}fr_c_new.dta", keepusing(fr_c_new) keep(master matched)
keep if fr_c_new<=30
drop _m fr_c_new

egen id1=group(id)
cap drop max*

cap drop newage
cap drop tmp
g tmp=floor((age-16)/10)
egen newage=group(tmp)
drop tmp

g oldage=age
replace age=newage

egen cf1=group(CF1)
egen gr2=group(p_b year)
tsset ,clear
cap drop _m

cap drop tmp*

cap drop tmp*
g tmp_in=n_pols_ing
g tmp_out=n_pols_o 

replace tmp_in=floor(tmp_in+.9999)
replace tmp_out=floor(tmp_ou+.9999)

*identifies rank of entry/exit episodes
cap drop diffin
sort id year
qui by id: g diffin=tmp_in-tmp_in[_n-1]
cap drop posdiffin
g posdiffin=diffin>0 & diffin<.
sort id posdiffin year
cap drop rankin
qui by id posdiffin: g rankin=_n if posdiffin

cap drop diffout
sort id year
qui by id: g diffout=tmp_ou-tmp_ou[_n-1]
cap drop posdiffo
g posdiffo=diffo>0 & diffo<.
sort id posdiffo year
cap drop ranko
qui by id posdiffo: g ranko=_n if posdiffo

egen gr3=group(p_b r_b c_b CF1)

saveold "${dir3}tmp", replace


*appends entry and exit episodes for each individual
u "${dir3}tmp", replace
keep if rankin<.
su rankin
global maxin=r(max)
reshape clear
reshape cons id
reshape groups rankin 1-$maxin
rename year yearin
reshape vars diffin yearin
reshape wide
compress
merge 1:m id using "${dir3}tmp
cap drop _m
saveold "${dir3}tmp", replace

u "${dir3}tmp", replace
keep if ranko<.
su ranko
global maxout=r(max)
reshape clear
reshape cons id
compress
reshape groups ranko 1-$maxout
rename year yearout
reshape vars diffo yearout
cap drop _m
reshape wide
compress
merge 1:m id using "${dir3}tmp
drop _m
saveold "${dir3}tmp", replace

end

*first entry/exit episodes

cap program drop eventstudy
program define eventstudy
preserve
donow2
u "${dir3}tmp", replace
g ${z}_pell1=${z}*(sector_pellegrino==1)
g ${z}_pell2=${z}*(sector_pellegrino==2)
g ${z}_spending1=${z}*(spending==1)
g ${z}_spending2=${z}*(spending==2)
g ${z}_occ1=${z}*(occ_gr==2)+${z}*(occ_gr==3)
g ${z}_occ2=${z}*(occ_gr==4)+${z}*(occ_gr==5)
g ${z}_occ3=${z}*(occ_gr==6)
keep if $y<.

global maxj=11
global half=($maxj-1)/2+1

set more 1


cap drop minrankin
egen minrankin=min(rankin), by(id) 

cap drop maxranko
egen maxranko=max(ranko), by(id) 

*assigns entry and exit at differents leads and lags from the first entry/last exist episodes
cap drop newyin
g newyin=.
global i=1
while $i<=$maxin {
replace newyi=yearin$i if minranki==$i
global i =$i+1
}

cap drop newyout
g newyout=.
global i=1
while $i<=$maxout {
replace newyout=yearout$i if maxranko==$i
global i =$i+1
}

cap drop newyin1
g newyin1=.
global i=1
while $i<=$max-1 {
global g=$i+1
replace newyin1=year$g if minrankin==$i
global i =$i+1
}

cap drop diffin
g diffin=.
global i=1
while $i<=$maxin {
replace diffin=diffin$i if minranki==$i
global i =$i+1
}

cap drop diffo
g diffo=.d
global i=1
while $i<=$maxout {
replace diffo=diffo$i if maxranko==$i
global i =$i+1
}

global k=1
while $k<=$maxj {
cap drop newdiffin$k
g newdiffin$k=(year==newyin-$half+$k)*diffin
global k=$k+1
}

global k=1
while $k<=$maxj {
cap drop newdiffo$k
g newdiffo$k=(year==newyo-$half+$k)*diffo
global k=$k+1
}

global l=$half-1
global m=$half+1
drop newdiffin$l
drop newdiffo$m

cap drop _m
reghdfe $y newdiffin* $controls  if year>=newyi-$half+1 & year<=newyi+$half-1 /*& year>1985+5 & year<2011-5*/ $if, a(id1 gr2 age) vce(cluster gr3)

cap drop coefin
cap drop sein
g coefin=0 in 1/$maxj
g sein=. in 1/$maxj
global k=1
while $k<=$maxj {
if $k==$l {
global k=$k+1
}
else  {
replace coefin=_coef[newdiffin$k] in $k/$k
replace sein=_se[newdiffin$k] in $k/$k
global k=$k+1
}
}

cap drop tmp
g tmp=tmp_in-tmp_out

cap drop _m
reghdfe tmp newdiffin* $controls  if year>=newyi-$half+1 & year<=newyi+$half-1 /*& year>1985+5 & year<2011-5*/ $if, a(id1 gr2 age) vce(cluster gr3)

cap drop coefin2
cap drop sein2
g coefin2=0 in 1/$maxj
g sein2=. in 1/$maxj
global k=1
while $k<=$maxj {
if $k==$l {
global k=$k+1
}
else  {
replace coefin2=_coef[newdiffin$k] in $k/$k
replace sein2=_se[newdiffin$k] in $k/$k
global k=$k+1
}
}

reghdfe $y newdiffo* $controls  if year>=newyo-$half+1 & year<=newyo+$half-1 /*& year>1985+5 & year<2011-5*/ $if, a(id1 gr2 age) vce(cluster gr3)

cap drop coefout
cap drop seout
g coefout=0 in 1/$maxj
g seout=. in 1/$maxj
global k=1
while $k<=$maxj {
if $k==$m {
global k=$k+1
}
else  {
replace coefo=_coef[newdiffo$k] in $k/$k
replace seo=_se[newdiffo$k] in $k/$k
global k=$k+1
}
}

cap drop _m
reghdfe tmp newdiffo* $controls if year>=newyo-$half+1 & year<=newyo+$half-1 /*& year>1985+5 & year<2011-5*/ $if, a(id1 gr2 age) vce(cluster gr3)

cap drop coefout2
cap drop seout2
g coefout2=0 in 1/$maxj
g seout2=. in 1/$maxj
global k=1
while $k<=$maxj {
if $k==$m {
global k=$k+1
}
else  {
replace coefout2=_coef[newdiffo$k] in $k/$k
replace seout2=_se[newdiffo$k] in $k/$k
global k=$k+1
}
}

cap drop n
g n=_n
replace n=n-$half
global half2=0

label var coefin  "$ylabel"
label var n "Years to/from event"

cap drop lbin ubin 
g lbin=coefin-1.95*sein 
g ubin=coefin+1.95*sein 
replace lbin=0 if n==-1
replace ubin=0 if n==-1
twoway (scatter coefin lbin ubin n if n<$half , c(i l l l l) s(O i i i i) lpattern(l - -)), xline($half2) yline(0, lcolor(black)) xlabel(-5 (1) 5) saving("${dir5}estudy1_in_${y}_${var}.gph", replace) title("$title") legend(off)
graph export "${dir5}estudy1_in_${y}_${var}.eps", replace fontface(Times)

cap drop lbin2 ubin2 
g lbin2=coefin2-1.95*sein2 
g ubin2=coefin2+1.95*sein2 
replace lbin2=0 if n==-1
replace ubin2=0 if n==-1
scatter diffcoefin lbin2 ubin2  n if n<$half, c(i l l l l) s(O i i i i) xline($half2) yline(0, lcolor(black)) xlabel(-5 (1) 5) saving(${dir5}estudy2_in_${y}_${var}.gph", replace) /*title("Entry: $title2")*/ legend(off) lpattern(l - -) ylabel(0 (.4) 1.2)
graph export ${dir5}estudy2_in_${y}_${var}.eps", replace fontface(Times)

label var coefout  "$ylabel"
label var n "Years to/from event"

cap drop lbout ubout 
g lbout=coefout-1.95*seout 
g ubout=coefout+1.95*seout 
replace lbout=0 if n==1
replace ubout=0 if n==1
twoway (scatter coefout lbout ubout n if n<$half , c(i l l l l) s(O i i i i) lpattern(l - -)), xline($half2) yline(0, lcolor(black)) xlabel(-5 (1) 5) saving("${dir5}estudy1_out_${y}_${var}.gph", replace) title("$title") legend(off)
graph export ${dir5}estudy1_out_${y}_${var}.eps, replace fontface(Times)

cap drop lbout2 ubout2 
g lbout2=coefout2-1.95*seout2 
g ubout2=coefout2+1.95*seout2 
replace lbout2=0 if n==1
replace ubout2=0 if n==1
scatter diffcoefout lbout2 ubout2 n if n<$half, c(i l l l l) s(O i i i i) xline($half2) yline(0, lcolor(black)) xlabel(-5 (1) 5) saving(${dir5}estudy2_out_${y}_${var}.gph", replace) /*title("Exit: $title2")*/ legend(off) lpattern(l - -) ylabel(0 (.4) 1.2)
graph export ${dir5}estudy2_out_${y}_${var}.esp", replace fontface(Times)

restore
end


** Figures 6, 7, 8

donow1
global controls=""
global y="tot_wg"
global if=""
global ylabel="Yearly earnings"
global title1=""
global title2="National"
global title3="Regional"
global title4="Provincial"
global title5="Municipal"
global title6="Head + Executive"
global title7="Council"
global title8="1 Term"
global title9="2 Terms"
global title10="> 2 Terms"
global title11="National"
local counter=1
local group tot n r p c top cou ten_c_t_01 ten_c_t_12 ten_c_t_gt2 
foreach c of local group {
global var="`c'"
global title="${title`counter'}"
local counter=`counter'+1
eventstudy
}
global y="tot_wg"
graph combine ${dir5}estudy1_in_${y}_c.gph ${dir5}estudy1_in_${y}_p.gph ${dir5}estudy1_in_${y}_r.gph ${dir5}estudy1_in_${y}_n.gph, ycommon
graph save ${dir5}estudy1_in_${y}_gov.gph, replace
graph export ${dir5}estudy1_in_${y}_gov.eps, replace fontface(Times)
graph combine ${dir5}estudy1_in_${y}_cou.gph ${dir5}estudy1_in_${y}_top.gph, ycommon ysize(2) iscale(1.5)
graph save ${dir5}estudy1_in_${y}_off.gph, replace
graph export ${dir5}estudy1_in_${y}_off.eps, replace fontface(Times)
graph combine ${dir5}estudy1_in_${y}_ten_c_t_01.gph ${dir5}estudy1_in_${y}_ten_c_t_12.gph ${dir5}estudy1_in_${y}_ten_c_t_gt2.gph, ycommon
graph save ${dir5}estudy1_in_${y}_tenure.gph, replace
graph export ${dir5}estudy1_in_${y}_tenure.eps, replace fontface(Times)


donow1
global controls=""
global y="n_paid_m"
global if=""
global ylabel="Months of work in the year"
global title1=""
global title2="National"
global title3="Regional"
global title4="Provincial"
global title5="Municipal"
global title6="Head + Executive"
global title7="Council"
global title8="1 Term"
global title9="2 Terms"
global title10="> 2 Terms"
global title11="National"
local counter=1
local group tot n r p c top cou ten_c_t_01 ten_c_t_12 ten_c_t_gt2 
foreach c of local group {
global var="`c'"
global title="${title`counter'}"
local counter=`counter'+1
eventstudy
}
global y="n_paid_m"
graph combine ${dir5}estudy1_in_${y}_c.gph ${dir5}estudy1_in_${y}_p.gph ${dir5}estudy1_in_${y}_r.gph ${dir5}estudy1_in_${y}_n.gph, ycommon
graph save ${dir5}estudy1_in_${y}_gov.gph, replace
graph export ${dir5}estudy1_in_${y}_gov.eps, replace fontface(Times)
graph combine ${dir5}estudy1_in_${y}_cou.gph ${dir5}estudy1_in_${y}_top.gph, ycommon ysize(2) iscale(1.5)
graph save ${dir5}estudy1_in_${y}_off.gph, replace
graph export ${dir5}estudy1_in_${y}_off.eps, replace fontface(Times)
graph combine ${dir5}estudy1_in_${y}_ten_c_t_01.gph ${dir5}estudy1_in_${y}_ten_c_t_12.gph ${dir5}estudy1_in_${y}_ten_c_t_gt2.gph, ycommon
graph save ${dir5}estudy1_in_${y}_tenure.gph, replace
graph export ${dir5}estudy1_in_${y}_tenure.eps, replace fontface(Times)


donow1
global controls=""
global y="empl"
global if=""
global ylabel="Employment"
global title1=""
global title2="National"
global title3="Regional"
global title4="Provincial"
global title5="Municipal"
global title6="Head + Executive"
global title7="Council"
global title8="1 Term"
global title9="2 Terms"
global title10="> 2 Terms"
global title11="National"
local counter=1
local group tot n r p c top cou ten_c_t_01 ten_c_t_12 ten_c_t_gt2 
foreach c of local group {
global var="`c'"
global title="${title`counter'}"
local counter=`counter'+1
eventstudy
}
global y="empl"
graph combine ${dir5}estudy1_in_${y}_c.gph ${dir5}estudy1_in_${y}_p.gph ${dir5}estudy1_in_${y}_r.gph ${dir5}estudy1_in_${y}_n.gph, ycommon
graph save ${dir5}estudy1_in_${y}_gov.gph, replace
graph export ${dir5}estudy1_in_${y}_gov.eps, replace fontface(Times)
graph combine ${dir5}estudy1_in_${y}_cou.gph ${dir5}estudy1_in_${y}_top.gph, ycommon ysize(2) iscale(1.5)
graph save ${dir5}estudy1_in_${y}_off.gph, replace
graph export ${dir5}estudy1_in_${y}_off.eps, replace fontface(Times)
graph combine ${dir5}estudy1_in_${y}_ten_c_t_01.gph ${dir5}estudy1_in_${y}_ten_c_t_12.gph ${dir5}estudy1_in_${y}_ten_c_t_gt2.gph, ycommon
graph save ${dir5}estudy1_in_${y}_tenure.gph, replace
graph export ${dir5}estudy1_in_${y}_tenure.eps, replace fontface(Times)


** Figures 3, 4

donow1
global controls=""
global z="tot_wg"
global if=""
global title1="Blue collar"
global title2="White collar"
global title3="Manager"
global ylabel="Yearly earnings"
local group tot 
foreach c of local group {
forvalues counter=1(1)3 {
global y="${z}_occ`counter'"
global var="`c'"
global title="${title`counter'}"
eventstudy
local counter=`counter'+1
}
}
global z="tot_wg"
graph combine ${dir5}estudy1_in_${z}_occ1_tot.gph ${dir5}estudy1_in_${z}_occ2_tot.gph ${dir5}estudy1_in_${z}_occ3_tot.gph, ycommon
graph save ${dir5}estudy1_in_${z}_occ.gph, replace
graph export ${dir5}estudy1_in_${z}_occ.eps, replace fontface(Times)


donow1
global controls=""
global y="tot_wg"
global z="tot_wg"
global if=""
global ylabel="Yearly earnings"
global title1="Young"
global title2="Mid"
global title3="Old"
local counter=1
local group young mid old 
foreach c of local group {
global var="`c'"
global title="${title`counter'}"
local counter=`counter'+1
eventstudy
}
global y="tot_wg"
graph combine ${dir5}estudy1_in_${y}_young.gph ${dir5}estudy1_in_${y}_mid.gph ${dir5}estudy1_in_${y}_old.gph, ycommon
graph save ${dir5}estudy1_in_${y}_age.gph, replace
graph export ${dir5}estudy1_in_${y}_age.eps, replace fontface(Times)

donow1
global controls=""
global y="tot_wg"
global z="tot_wg"
global if=""
global ylabel="Yearly earnings"
global if1="& [age==1 | age==2]"
global if2="& [age==3 | age==4]"
global if3="& age==5"
global title1="Young"
global title2="Mid"
global title3="Old"
local counter=1
local group age1 age2 age3
foreach c of local group {
global var="`c'"
global if="${if`counter'}"
global title="${title`counter'}"
eventstudy
local counter=`counter'+1
}
global y="tot_wg"
graph combine ${dir5}estudy1_in_${y}_age1.gph ${dir5}estudy1_in_${y}_age2.gph ${dir5}estudy1_in_${y}_age3.gph, ycommon
graph save ${dir5}estudy1_in_${y}_age.gph, replace
graph export ${dir5}estudy1_in_${y}_age.eps, replace fontface(Times)

donow1
global controls=""
global y="tot_wg"
global if="& age==2"
global ylabel="Yearly earnings"
global title1="Male 18-35"
global title2="Male 36-55"
global title3="Male 56-65"
global title4="Female 18-35"
global title5="Female 36-55"
global title6="Female 56-65"
local counter=1
local group mal_young mal_mid mal_old fem_young fem_mid fem_old 
foreach c of local group {
global var="`c'"
global title="${title`counter'}"
local counter=`counter'+1
eventstudy
}
global y="tot_wg"
graph combine ${dir5}estudy1_in_${y}_mal_young.gph ${dir5}estudy1_in_${y}_mal_mid.gph ${dir5}estudy1_in_${y}_mal_old.gph ${dir5}estudy1_in_${y}_fem_young.gph ${dir5}estudy1_in_${y}_fem_mid.gph ${dir5}estudy1_in_${y}_fem_old.gph
graph save ${dir5}estudy1_in_${y}_gen.gph, replace
graph export ${dir5}estudy1_in_${y}_gen.eps, replace fontface(Times)


donow1
global controls=""
global z="n_paid_m"
global if=""
global title1="Blue collar"
global title2="White collar"
global title3="Manager"
global ylabel="Months of work"
local group tot 
foreach c of local group {
forvalues counter=1(1)3 {
global y="${z}_occ`counter'"
global var="`c'"
global title="${title`counter'}"
eventstudy
}
}
global z="n_paid_m"
graph combine ${dir5}estudy1_in_${z}_occ1_tot.gph ${dir5}estudy1_in_${z}_occ2_tot.gph ${dir5}estudy1_in_${z}_occ3_tot.gph, ycommon
graph save ${dir5}estudy1_in_${z}_occ.gph, replace
graph export ${dir5}estudy1_in_${z}_occ.eps, replace fontface(Times)
*/

donow1
global controls=""
global y="n_paid_m"
global z="n_paid_m"
global if=""
global ylabel="Months of work"
global title1="Young"
global title2="Mid"
global title3="Old"
local counter=1
local group young mid old 
foreach c of local group {
global var="`c'"
global title="${title`counter'}"
local counter=`counter'+1
eventstudy
}
global y="n_paid_m"
graph combine ${dir5}estudy1_in_${y}_young.gph ${dir5}estudy1_in_${y}_mid.gph ${dir5}estudy1_in_${y}_old.gph, ycommon
graph save ${dir5}estudy1_in_${y}_age.gph, replace
graph export ${dir5}estudy1_in_${y}_age.eps, replace fontface(Times)


donow1
global controls=""
global y="n_paid_m"
global if=""
global ylabel="Months of work"
global if1="& [age==1 | age==2]"
global if2="& [age==3 | age==4]"
global if3="& age==5"
global title1="Young"
global title2="Mid"
global title3="Old"
local counter=1
local group age1 age2 age3
foreach c of local group {
global var="`c'"
global if="${if`counter'}"
global title="${title`counter'}"
eventstudy
local counter=`counter'+1
}
global y="n_paid_m"
graph combine ${dir5}estudy1_in_${y}_age1.gph ${dir5}estudy1_in_${y}_age2.gph ${dir5}estudy1_in_${y}_age3.gph, ycommon
graph save ${dir5}estudy1_in_${y}_age.gph, replace
graph export ${dir5}estudy1_in_${y}_age.eps, replace fontface(Times)


donow1
global controls=""
global y="n_paid_m"
global if="& age==2"
global ylabel="Months of work"
global title1="Male 18-35"
global title2="Male 36-55"
global title3="Male 56-65"
global title4="Female 18-35"
global title5="Female 36-55"
global title6="Female 56-65"
local counter=1
local group mal_young mal_mid mal_old fem_young fem_mid fem_old 
foreach c of local group {
global var="`c'"
global title="${title`counter'}"
eventstudy
local counter=`counter'+1
}
global y="n_paid_m"
graph combine ${dir5}estudy1_in_${y}_mal_young.gph ${dir5}estudy1_in_${y}_mal_mid.gph ${dir5}estudy1_in_${y}_mal_old.gph ${dir5}estudy1_in_${y}_fem_young.gph ${dir5}estudy1_in_${y}_fem_mid.gph ${dir5}estudy1_in_${y}_fem_old.gph
graph save ${dir5}estudy1_in_${y}_gen.gph, replace
graph export ${dir5}estudy1_in_${y}_gen.eps, replace fontface(Times)


donow1
global controls=""
global z="empl"
global if=""
global title1="Blue collar"
global title2="White collar"
global title3="Manager"
global ylabel="Employment"
local group tot 
foreach c of local group {
forvalues counter=1(1)3 {
global y="${z}_occ`counter'"
global var="`c'"
global title="${title`counter'}"
eventstudy
}
}
global z="empl"
graph combine ${dir5}estudy1_in_${z}_occ1_tot.gph ${dir5}estudy1_in_${z}_occ2_tot.gph ${dir5}estudy1_in_${z}_occ3_tot.gph, ycommon
graph save ${dir5}estudy1_in_${z}_occ.gph, replace
graph export ${dir5}estudy1_in_${z}_occ.eps, replace fontface(Times)


donow1
global controls=""
global y="empl"
global z="empl"
global if=""
global ylabel="Employment"
global title1="Young"
global title2="Mid"
global title3="Old"
local counter=1
local group young mid old 
foreach c of local group {
global var="`c'"
global title="${title`counter'}"
local counter=`counter'+1
eventstudy
}
global y="empl"
graph combine ${dir5}estudy1_in_${y}_young.gph ${dir5}estudy1_in_${y}_mid.gph ${dir5}estudy1_in_${y}_old.gph, ycommon
graph save ${dir5}estudy1_in_${y}_age.gph, replace
graph export ${dir5}estudy1_in_${y}_age.eps, replace fontface(Times)


donow1
global controls=""
global y="empl"
global if=""
global ylabel="Employment"
global if1="& [age==1 | age==2]"
global if2="& [age==3 | age==4]"
global if3="& age==5"
global title1="Young"
global title2="Mid"
global title3="Old"
local counter=1
local group age1 age2 age3
foreach c of local group {
global var="`c'"
global if="${if`counter'}"
global title="${title`counter'}"
local counter=`counter'+1
eventstudy
}
global y="empl"
graph combine ${dir5}estudy1_in_${y}_age1.gph ${dir5}estudy1_in_${y}_age2.gph ${dir5}estudy1_in_${y}_age3.gph, ycommon
graph save ${dir5}estudy1_in_${y}_age.gph, replace
graph export ${dir5}estudy1_in_${y}_age.eps, replace fontface(Times)


donow1
global controls=""
global y="empl"
global if="& age==2"
global ylabel="Employment"
global title1="Male 18-35"
global title2="Male 36-55"
global title3="Male 56-65"
global title4="Female 18-35"
global title5="Female 36-55"
global title6="Female 56-65"
local counter=1
local group mal_young mal_mid mal_old fem_young fem_mid fem_old 
foreach c of local group {
global var="`c'"
global title="${title`counter'}"
eventstudy
local counter=`counter'+1
}
global y="empl"
graph combine ${dir5}estudy1_in_${y}_mal_young.gph ${dir5}estudy1_in_${y}_mal_mid.gph ${dir5}estudy1_in_${y}_mal_old.gph ${dir5}estudy1_in_${y}_fem_young.gph ${dir5}estudy1_in_${y}_fem_mid.gph ${dir5}estudy1_in_${y}_fem_old.gph
graph save ${dir5}estudy1_in_${y}_gen.gph, replace
graph export ${dir5}estudy1_in_${y}_gen.eps, replace fontface(Times)


** Figure 9

donow1
global controls=""
global z="tot_wg"
global if=""
global title1="Low"
global title2="High"
forvalues m=1(1)2 {
global y="${z}_pell`m'"
global ylabel="Yearly earnings"
local group tot 
foreach c of local group {
global var="`c'"
global title="${title`m'}"
eventstudy
}
}
global z="tot_wg"
graph combine ${dir5}estudy1_in_${z}_pell1_tot.gph ${dir5}estudy1_in_${z}_pell2_tot.gph, ycommon ysize(2) iscale(1.5)
graph save ${dir5}estudy1_in_${z}_pell.gph, replace
graph export ${dir5}estudy1_in_${z}_pell.eps, replace fontface(Times)


donow1
global controls=""
global z="n_paid_m"
global if=""
global title1="Low"
global title2="High"
forvalues m=1(1)2 {
global y="${z}_pell`m'"
global ylabel="Months of work"
local group tot 
foreach c of local group {
global var="`c'"
global title="${title`m'}"
eventstudy
}
}
global z="n_paid_m"
graph combine ${dir5}estudy1_in_${z}_pell1_tot.gph ${dir5}estudy1_in_${z}_pell2_tot.gph, ycommon ysize(2) iscale(1.5)
graph save ${dir5}estudy1_in_${z}_pell.gph, replace
graph export ${dir5}estudy1_in_${z}_pell.eps, replace fontface(Times)


donow1
global controls=""
global z="empl"
global if=""
global title1="Low"
global title2="High"
forvalues m=1(1)2 {
global y="${z}_pell`m'"
global ylabel="Employment"
local group tot 
foreach c of local group {
global var="`c'"
global title="${title`m'}"
eventstudy
}
}
global z="empl"
graph combine ${dir5}estudy1_in_${z}_pell1_tot.gph ${dir5}estudy1_in_${z}_pell2_tot.gph, ycommon ysize(2) iscale(1.5)
graph save ${dir5}estudy1_in_${z}_pell.gph, replace
graph export ${dir5}estudy1_in_${z}_pell.eps, replace fontface(Times)


* Figure 5

donow1
global controls=""
global z="tot_wg"
global if=""
global title1="Low"
global title2="High"
forvalues m=1(1)2 {
global y="${z}_spending`m'"
global ylabel="Yearly earnings"
local group tot 
foreach c of local group {
global var="`c'"
global title="${title`m'}"
eventstudy
}
}
global z="tot_wg"
graph combine ${dir5}estudy1_in_${z}_spending1_tot.gph ${dir5}estudy1_in_${z}_spending2_tot.gph, ycommon ysize(2) iscale(1.5)
graph save ${dir5}estudy1_in_${z}_spending.gph, replace
graph export ${dir5}estudy1_in_${z}_spending.eps, replace fontface(Times)


donow1
global controls=""
global z="n_paid_m"
global if=""
global title1="Low"
global title2="High"
forvalues m=1(1)2 {
global y="${z}_spending`m'"
global ylabel="Months of work"
local group tot 
foreach c of local group {
global var="`c'"
global title="${title`m'}"
eventstudy
}
}
global z="n_paid_m"
graph combine ${dir5}estudy1_in_${z}_spending1_tot.gph ${dir5}estudy1_in_${z}_spending2_tot.gph, ycommon ysize(2) iscale(1.5)
graph save ${dir5}estudy1_in_${z}_spending.gph, replace
graph export ${dir5}estudy1_in_${z}_spending.eps, replace fontface(Times)


donow1
global controls=""
global z="empl"
global if=""
global title1="Low"
global title2="High"
forvalues m=1(1)2 {
global y="${z}_spending`m'"
global ylabel="Employment"
local group tot 
foreach c of local group {
global var="`c'"
global title="${title`m'}"
eventstudy
}
}
global z="empl"
graph combine ${dir5}estudy1_in_${z}_spending1_tot.gph ${dir5}estudy1_in_${z}_spending2_tot.gph, ycommon ysize(2) iscale(1.5)
graph save ${dir5}estudy1_in_${z}_spending.gph, replace
graph export ${dir5}estudy1_in_${z}_spending.eps, replace fontface(Times)

