function [] = plotIRFFigures(T,ss,tr,nSigma,ls)

close all

if nSigma>0
    figPrefix = 'IRF_z';
elseif nSigma ==0
    figPrefix = 'IRF_xi';
elseif nSigma == -2
    figPrefix = 'IRF_v';
elseif nSigma == -3
    figPrefix = 'IRF_lambda';
elseif nSigma == -4
    figPrefix = 'IRF_mu';
elseif nSigma == -5
    figPrefix = 'IRF_beta';
end



figPrefix = [figPrefix ls.figPrefix];

tGrid = 1:T-1;


yText = '';
xText = '';
legendText2 = {'Reposting', 'No Reposting', 'Full Crowd-Out, $k(v^{Inflow})$'};
figNum = 1;


%% *** Shock ***
figure(figNum)

if nSigma>0
    plot(tGrid,100*(tr{1}.z(tGrid)-1)/1,ls.lineSpec1{:})
elseif nSigma == -3
    plot(tGrid,100*(tr{1}.lambda(tGrid)-tr{1}.lambda(end))/tr{1}.lambda(end),ls.lineSpec1{:})
elseif nSigma == -4
    plot(tGrid,100*(tr{1}.mu(tGrid)-tr{1}.mu(end))/tr{1}.mu(end),ls.lineSpec1{:})
elseif nSigma == -5
    plot(tGrid,100*(tr{1}.beta(tGrid)-tr{1}.beta(end))/tr{1}.beta(end),ls.lineSpec1{:})
end

xlabel(xText)
ylabel(yText)
grid on
set(gca,ls.gridLineSpec{:})
set(gca,ls.fontSpec{:})
export_fig(figure(figNum),[ls.graphPath figPrefix '_shock'],'-pdf','-transparent');

figNum = figNum + 1;

%% *** Vacancy Multiplier ***
if nSigma>0
    v_multiplier = cumsum(tr{3}.v(tGrid) - tr{4}.v(tGrid))./cumsum(tr{3}.z(tGrid)-tr{3}.z(end));
elseif nSigma == -2
    v_multiplier = cumsum(tr{3}.v(tGrid) - tr{4}.v(tGrid))./(0.01*ss.v);
elseif nSigma == -3
    v_multiplier = cumsum(tr{3}.v(tGrid) - tr{4}.v(tGrid))./cumsum(tr{3}.lambda(tGrid)-tr{3}.lambda(end));
elseif nSigma == -4
    v_multiplier = cumsum(tr{3}.v(tGrid) - tr{4}.v(tGrid))./cumsum(tr{3}.mu(tGrid)-tr{3}.mu(end));
elseif nSigma == -5
    v_multiplier = cumsum(tr{3}.v(tGrid) - tr{4}.v(tGrid))./cumsum(tr{3}.beta(tGrid)-tr{3}.beta(end));
end

figure(figNum)

plot(tGrid,v_multiplier,ls.lineSpec1{:});
xlabel('Time')
ylabel('Cumulative Multiplier')
grid on
set(gca,ls.gridLineSpec{:})
set(gca,ls.fontSpec{:})

export_fig(figure(figNum),[ls.graphPath figPrefix '_multiplier'],'-pdf','-transparent');

figNum = figNum + 1;

%% *** Vacancies ***
figure(figNum)
plot(tGrid,100*(tr{3}.v(tGrid)-ss.v)/ss.v,ls.lineSpec1{:})
hold on
plot(tGrid,100*(tr{4}.v(tGrid)-ss.v)/ss.v,ls.lineSpec2{:})
plot(tGrid,100*(tr{5}.v(tGrid)-ss.v)/ss.v,ls.lineSpec3{:})
%plot(tGrid,100*(tr{6}.v(tGrid)-ss.v)/ss.v,ls.lineSpec4{:})
hold off

xlabel(xText)
ylabel(yText)
%legend(legendText2{:})
grid on
set(gca,ls.gridLineSpec{:})
set(gca,ls.fontSpec{:})

export_fig(figure(figNum),[ls.graphPath figPrefix '_quadratic_v'],'-pdf','-transparent');

figNum = figNum + 1;

%% *** New Openings ***

figure(figNum)
plot(tGrid,100*(tr{3}.n(tGrid)-ss.n)/ss.n,ls.lineSpec1{:})
hold on
plot(tGrid,100*(tr{4}.n(tGrid)-ss.n)/ss.n,ls.lineSpec2{:})
plot(tGrid,100*(tr{5}.n(tGrid)-ss.n)/ss.n,ls.lineSpec3{:})
%plot(tGrid,100*(tr{6}.n(tGrid)-ss.n)/ss.n,ls.lineSpec4{:})

hold off

xlabel(xText)
ylabel(yText)
if nSigma > 0 
    lgd = legend(legendText2{:});
    lgd.FontSize = 20;
end
grid on
set(gca,ls.gridLineSpec{:})
set(gca,ls.fontSpec{:})

export_fig(figure(figNum),[ls.graphPath figPrefix '_quadratic_n'],'-pdf','-transparent');

figNum = figNum + 1;

%% *** Unemployment ***

figure(figNum)
plot(tGrid,100*(tr{3}.u(tGrid)-ss.u)/ss.u,ls.lineSpec1{:})
hold on
plot(tGrid,100*(tr{4}.u(tGrid)-ss.u)/ss.u,ls.lineSpec2{:})
plot(tGrid,100*(tr{5}.u(tGrid)-ss.u)/ss.u,ls.lineSpec3{:})
%plot(tGrid,100*(tr{6}.u(tGrid)-ss.u)/ss.u,ls.lineSpec4{:})
hold off

xlabel(xText)
ylabel(yText)
%legend(legendText2{:})
grid on
set(gca,ls.gridLineSpec{:})
set(gca,ls.fontSpec{:})

export_fig(figure(figNum),[ls.graphPath figPrefix '_quadratic_u'],'-pdf','-transparent');

figNum = figNum + 1;

%% JJ transitions
figure(figNum)
plot(tGrid,100*(tr{3}.jjRate(tGrid)-ss.jjRate)/ss.jjRate,ls.lineSpec1{:})
hold on
plot(tGrid,100*(tr{4}.jjRate(tGrid)-ss.jjRate)/ss.jjRate,ls.lineSpec2{:})
plot(tGrid,100*(tr{5}.jjRate(tGrid)-ss.jjRate)/ss.jjRate,ls.lineSpec3{:})
%plot(tGrid,100*(tr{6}.u(tGrid)-ss.u)/ss.u,ls.lineSpec4{:})
hold off

xlabel(xText)
ylabel(yText)
%legend(legendText2{:})
grid on
set(gca,ls.gridLineSpec{:})
set(gca,ls.fontSpec{:})

export_fig(figure(figNum),[ls.graphPath figPrefix '_quadratic_jj'],'-pdf','-transparent');

figNum = figNum + 1;

end