

********************************************************
*Title: AEJPol-2018-0592_DATA_table_3-10.do
*Date: 28 June, 2018
*Author: Li Liu
********************************************************

*************Table 3. Placebo Tests of Pre-Reform Differential Trends***********

qui use "${cbt_datadir}\Exemption_MNE4reg", clear

keep if insample_foreign==1

global ctrl_firm lag_turn lag_cf lag_pm turn_g_lag 
global ctrl_host corp_rate lpop lunemp lgdp_capita host_governance host_stable_fi
global ctrl_home uo_gdpgrowth uo_gdppcap uo_governance uo_stable_fi


*PLACEBO TEST: Full sample:

estimates clear

forv j=2006/2011 {
gen year_`j'=(year==`j')
gen year_ukparent_`j'=year_`j'*uk_parent

eststo: reghdfe Irate_w99 year_ukparent_`j'  ${ctrl_firm} ${ctrl_host} if low_tax==1, absorb(i.id i.year#i.nace_1digit i.year#i.ctry) vce(cluster id)

qui drop year_* year_ukparent_*
}

qui estout est* using "${cbt_resultdir}\reg_placebo_lowtax.txt", cells(b(star fmt(%9.3f)) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01) ///
stats(r2 N,  fmt(%9.3f %9.0g) labels(R-squared)) label replace 

*PLACEBO TEST: Matched sample:

qui use "${cbt_datadir}\Exemption_MNEmatched", clear

gen insample_exemption=(uo_ctry!="IE" & uo_ctry != "IL" & uo_ctry !="KR" & uo_ctry != "MX" & uo_ctry != "PL" & uo_ctry !="US" & uo_ctry !="JP")
keep if insample_exemption==1

gen post=(year>=2009)
gen announced=(year==2008)

*the interaction term*
gen post_ukparent=uk_parent*post

*dummy indicators*
qui tab year, gen (year_d)
qui tab country, gen (country_d)

*firm-level controls*
xtset id year
bysort id: gen lag_turn=turnover_real[_n-1]
bysort id: gen lag_pm=profit_margin[_n-1]

*country-level controls*
qui replace pop=pop/1000
gen lpop=ln(pop)
gen lunemp=ln(unemp)
gen lgdp_capita=ln(gdp_capita)

*host-home country pair*
egen ctry=group(country)

global ctrl_firm lag_turn lag_cf lag_pm turn_g_lag 
global ctrl_host corp_rate lpop lunemp lgdp_capita host_governance host_stable_fi
global ctrl_home uo_gdpgrowth uo_gdppcap uo_governance uo_stable_fi

estimates clear
xtset id year


forv j=2006/2011 {
gen year_`j'=(year==`j')
gen year_ukparent_`j'=year_`j'*uk_parent

eststo: reghdfe Irate_w99 year_ukparent_`j' ${ctrl_firm} ${ctrl_host} if low_tax==1, absorb(i.id i.year#i.nace_1digit i.year#i.ctry) vce(cluster id)

qui drop year_* year_ukparent_*
}

qui estout est* using "${cbt_resultdir}\reg_placebo_lowtax.txt", cells(b(star fmt(%9.3f)) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01) ///
stats(r2 N,  fmt(%9.3f %9.0g) labels(R-squared)) label append


************Table 4. Investment Response in Low-Tax Countries: Baseline Results************

qui use "${cbt_datadir}\Exemption_MNE4reg_uo", clear

keep if insample_foreign==1

global ctrl_firm lag_turn lag_cf lag_pm turn_g_lag 
global ctrl_host corp_rate lpop lunemp lgdp_capita host_governance host_stable_fi
global ctrl_home uo_gdpgrowth uo_gdppcap uo_governance uo_stable_fi

estimates clear
xtset id year

*1. no controls
eststo: reghdfe Irate_w99 post_ukparent if low_tax==1, absorb(i.id i.year) vce(cluster id)

*2. + firm-level controls
eststo: reghdfe Irate_w99 post_ukparent ${ctrl_firm} if low_tax==1, absorb(i.id i.year) vce(cluster id)

*3. + firm-level controls and host-country industry-year FE
eststo: reghdfe Irate_w99 post_ukparent ${ctrl_firm} if low_tax==1, absorb(i.id i.year#i.nace_1digit) vce(cluster id)

*4. + firm-level controls and host-country industry-year FE + host-country level controls 
eststo: reghdfe Irate_w99 post_ukparent ${ctrl_firm} ${ctrl_host} if low_tax==1, absorb(i.id i.year#i.nace_1digit) vce(cluster id)

*5. + firm-level controls and host country-year fixed effects
eststo: reghdfe Irate_w99 post_ukparent ${ctrl_firm} ${ctrl_host} if low_tax==1, absorb(i.id i.year#i.nace_1digit i.year#i.ctry) vce(cluster id)

*6. + firm-level and host-country level controls + country-year fixed effects + host-country level controls
eststo: reghdfe Irate_w99 post_ukparent ${ctrl_firm} ${ctrl_host} ${ctrl_home} if low_tax==1, absorb(i.id i.year#i.nace_1digit i.year#i.ctry) vce(cluster id)

*7. replace DE dummy with the actual tax differential

eststo: reghdfe Irate_w99 post_ukparent ztax_diff_ukparentpost lag_turn turn_g_lag ${ctrl_home}   ///
if low_tax==1, absorb(i.id i.year#i.nace_2digit i.year#i.ctry) vce(cluster id)

*8. replace DE dummy with the actual tax differential; allowing for nonlinear effects

eststo: reghdfe Irate_w99 post_ukparent_q1 post_ukparent_q2 post_ukparent_q3 ${ctrl_firm} ${ctrl_home} if low_tax==1 , absorb(i.id i.year#i.nace_1digit i.year#i.ctry ) vce(cluster id)

qui estout est* using "${cbt_resultdir}\reg_lowtax.txt", cells(b(star fmt(%9.3f)) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01) ///
stats(N N_clust r2,  fmt(%9.3f %9.0g) labels(R-squared)) label replace 


************Table 5. Investment Response in Low-Tax Countries: Robustness Checks************

estimates clear
xtset id year

*0. replicating prefered result*
eststo: reghdfe Irate_w99 post_ukparent ${ctrl_firm} ${ctrl_host} ${ctrl_home} if low_tax==1 &insample_exemption==1, absorb(i.id i.year#i.nace_1digit i.year#i.ctry) vce(cluster id)

*1. standard errors clustered at country level*
eststo: reghdfe Irate_w99 post_ukparent ${ctrl_firm} ${ctrl_home} ${ctrl_host} if low_tax==1 & insample_exemption==1, absorb(i.id i.year#i.ctry i.year#i.nace_1digit) vce(cluster ctry guo_ctry)

*2. balaced sample
eststo: reghdfe Irate_w99 post_ukparent ${ctrl_firm} ${ctrl_home} ${ctrl_host} if low_tax==1 & insample_exemption==1 & obs>=6, absorb(i.id i.year#i.ctry  i.year#i.nace_1digit) vce(cluster id)

*3. top-10 UO countries
eststo: reghdfe Irate_w99 post_ukparent ${ctrl_firm} ${ctrl_home} ${ctrl_host} if low_tax==1 & insample_exemption==1 & obs_ctry2>=9000 , absorb(i.id i.year#i.ctry i.year#i.nace_1digit) vce(cluster id)

*4. Adding Switzerland

preserve
keep if insample_exemption==1
keep if low_tax==1 
append using "${cbt_datadir}\Exemption_MNE_CH"
cap drop ctry
egen ctry=group(country)

eststo: reghdfe Irate_w99 post_ukparent ${ctrl_firm} ${ctrl_home} , absorb(i.id i.year#i.ctry i.year#i.nace_1digit) vce(cluster id)

restore

keep if insample_exemption==1

*6. Use of investment rate winsorized at 2.5 percentile*
eststo: reghdfe Irate_w post_ukparent ${ctrl_firm} ${ctrl_home} if low_tax==1, absorb(i.id i.year#i.ctry i.year#i.nace_1digit) vce(cluster id)

*7. Use of net investment rate*
eststo: reghdfe Irate_net_w99 post_ukparent ${ctrl_firm} ${ctrl_home} ${ctrl_host} if low_tax==1, absorb(i.id i.year#i.ctry i.year#i.nace_1digit)  vce(cluster id)
eststo: reghdfe Irate_net_w post_ukparent ${ctrl_firm} ${ctrl_home} ${ctrl_host} if low_tax==1, absorb(i.id i.year#i.ctry i.year#i.nace_1digit)  vce(cluster id)

qui estout est* using "${cbt_resultdir}\reg_robustness_lowtax.txt", cells(b(star fmt(%9.3f)) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01) ///
stats(N N_clust r2,  fmt(%9.0g %9.0g %9.3f ) labels(N)) label replace 


****Other Outcomes***

estimates clear
xtset id year

*8. wage_rate_w*
eststo: reghdfe wage_rate_w post_ukparent wkrs turnover if low_tax==1, absorb(i.id i.year#i.ctry i.year#i.nace_1digit) vce(cluster id)

*9. employment*
eststo: reghdfe wkrs post_ukparent Irate_w99 turnover if low_tax==1, absorb(i.id i.year#i.ctry i.year#i.nace_1digit) vce(cluster id)

*10. productivity*
eststo: reghdfe productivity_w post_ukparent Irate_w99 if low_tax==1, absorb(i.id i.year#i.ctry i.year#i.nace_1digit) vce(cluster id)

*11. profitability*
eststo: reghdfe pmargin_w post_ukparent Irate_w99 if low_tax==1, absorb(i.id i.year#i.ctry i.year#i.nace_1digit) vce(cluster id)

qui estout est* using "${cbt_resultdir}\reg_robustness_lowtax.txt", cells(b(star fmt(%9.3f)) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01) ///
stats(N N_clust r2,  fmt(%9.0g %9.0g %9.3f ) labels(N)) keep(post_ukparent) label append

****Matched Sample***

qui use "${cbt_datadir}\Exemption_MNEmatched", clear

gen insample_exemption=(uo_ctry!="IE" & uo_ctry != "IL" & uo_ctry !="KR" & uo_ctry != "MX" & uo_ctry != "PL" & uo_ctry !="US" & uo_ctry !="JP")
keep if insample_exemption==1


gen post=(year>=2009)
gen announced=(year==2008)

*the interaction term*
gen post_ukparent=uk_parent*post
gen announced_ukparent=uk_parent*announced
gen tax_diff= corp_uk-corp_rate 
replace tax_diff=corp_rate-corp_uk if low_tax==0
gen tax_diff_ukparent=uk_parent*tax_diff*(post)

*dummy indicators*
qui tab year, gen (year_d)
qui tab country, gen (country_d)

*firm-level controls*
xtset id year
bysort id: gen lag_turn=turnover_real[_n-1]
bysort id: gen lag_pm=profit_margin[_n-1]

*country-level controls*
qui replace pop=pop/1000
gen lpop=ln(pop)
gen lunemp=ln(unemp)
gen lgdp_capita=ln(gdp_capita)

*host-home country pair*
egen ctry=group(country)

global ctrl_firm lag_turn lag_cf lag_pm turn_g_lag 
global ctrl_host corp_rate lpop lunemp lgdp_capita host_governance host_stable_fi
global ctrl_home uo_gdpgrowth uo_gdppcap uo_governance uo_stable_fi

estimates clear
xtset id year

*12. + firm-level and host-country industry-year FE, + host-country level controls 
eststo: reghdfe Irate_w99 post_ukparent ${ctrl_firm} ${ctrl_host} , absorb(i.id i.year#i.nace_1digit i.ctry) vce(cluster id)

qui estout est* using "${cbt_resultdir}\reg_robustness_lowtax.txt", cells(b(star fmt(%9.3f)) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01) ///
stats(N N_clust r2,  fmt(%9.0g %9.0g %9.3f ) labels(R-squared)) label replace 


************Table 6. Investment Response: Tripple-Difference Estimation************

qui use "${cbt_datadir}\Exemption4reg_MNE", clear

keep if insample_foreign==1

global ctrl_firm lag_turn lag_cf lag_pm turn_g_lag 
global ctrl_host corp_rate lpop lunemp lgdp_capita host_governance host_stable_fi
global ctrl_home uo_gdpgrowth uo_gdppcap uo_governance uo_stable_fi


estimates clear
xtset id year

*1. no controls
eststo: reghdfe Irate_w99 post_ukparent_low ukparent_low_tax post_ukparent post_low low_tax, absorb(i.id i.year) vce(cluster id) 

*2. + firm-level controls
eststo: reghdfe Irate_w99 post_ukparent_low ukparent_low_tax post_ukparent post_low low_tax ${ctrl_firm}, absorb(i.id i.year) vce(cluster id) 

*3. + firm-level and host-country industry-year FE
eststo: reghdfe Irate_w99 post_ukparent_low ukparent_low_tax post_ukparent post_low low_tax ${ctrl_firm}, absorb(i.id i.year#i.nace_1digit) vce(cluster id) 

*4. + firm-level and host-country industry-year FE, + host-country level controls 
eststo: reghdfe Irate_w99 post_ukparent_low ukparent_low_tax post_ukparent post_low low_tax ${ctrl_firm} ${ctrl_host}, absorb(i.id i.year#i.nace_1digit) vce(cluster id) 

*5. + firm-level and host-country level controls + country-year fixed effects
eststo: reghdfe Irate_w99 post_ukparent_low ukparent_low_tax post_ukparent post_low low_tax ${ctrl_firm} ${ctrl_host} ${ctrl_home}, absorb(i.id i.year#i.nace_1digit) vce(cluster id) 

*6. + firm-level and host-country level controls + country-year fixed effects + host-country level controls
eststo: reghdfe Irate_w99 post_ukparent_low ukparent_low_tax post_ukparent post_low low_tax ${ctrl_firm} ${ctrl_host}, absorb(i.id i.year#i.nace_1digit i.year#i.ctry_host) vce(cluster id) 

qui estout est* using "${cbt_resultdir}\reg_lowtax_tripdiff.txt", cells(b(star fmt(%9.3f)) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01) ///
stats(r2 N N_g,  fmt(%9.3f %9.0g) labels(R-squared)) label replace 


***********************Table 7. Separating the Anticipation Effect***********************

qui use "${cbt_datadir}\Exemption_MNE4reg", clear

keep if insample_foreign==1

global ctrl_firm lag_turn lag_cf lag_pm turn_g_lag 
global ctrl_host corp_rate lpop lunemp lgdp_capita host_governance host_stable_fi
global ctrl_home uo_gdpgrowth uo_gdppcap uo_governance uo_stable_fi

estimates clear
xtset id year

forv i=4/7 {
local j=`i'+2004
gen year`j'_ukparent=year_d`i'*uk_parent
}

forv j=2009/2011 {
gen post`j'=year>=`j'
gen post`j'_ukparent=post`j'*uk_parent
}

estimates clear
eststo: reghdfe Irate_w99 announced_ukparent post_ukparent ${ctrl_firm} ${ctrl_home}  if low_tax==1, absorb(i.id i.year#i.ctry i.year#i.nace_1digit) vce(cluster id)
eststo: reghdfe Irate_w99 announced_ukparent post_ukparent ${ctrl_firm} ${ctrl_home} ${ctrl_host} if low_tax==1, absorb(i.id i.year#i.ctry i.year#i.nace_1digit) vce(cluster id)
eststo: reghdfe Irate_w99 year2008_ukparent year2009_ukparent year2010_ukparent year2011_ukparent ${ctrl_firm} ${ctrl_home}  if low_tax==1, absorb(i.id i.year#i.ctry i.year#i.nace_1digit) vce(cluster id)

eststo: reghdfe Irate_net_w99 announced_ukparent post_ukparent ${ctrl_firm} ${ctrl_home} if low_tax==1, absorb(i.id i.year#i.ctry i.year#i.nace_1digit) vce(cluster id)
eststo: reghdfe Irate_net_w99 announced_ukparent post_ukparent ${ctrl_firm} ${ctrl_home} if low_tax==1, absorb(i.id i.year#i.ctry i.year#i.nace_1digit) vce(cluster id)
eststo: reghdfe Irate_net_w99 year2008_ukparent year2009_ukparent year2010_ukparent year2011_ukparent  ${ctrl_firm} ${ctrl_home}  if low_tax==1, absorb(i.id i.year#i.ctry i.year#i.nace_1digit) vce(cluster id)

qui estout est* using "${cbt_resultdir}\reg_announced.txt", cells(b(star fmt(%9.3f)) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01) ///
stats(N N_clust r2,  fmt(%9.0g %9.0g %9.3f ) labels(R-squared)) label replace 

estimates clear


***********************Table 8. Investment Responses in High-Tax Countries***********************

estimates clear
xtset id year

*1. no controls
eststo: reghdfe Irate_w99 post_ukparent if high_tax==1, absorb(i.id i.year) vce(cluster id)

*2. + firm-level controls
eststo: reghdfe Irate_w99 post_ukparent  ${ctrl_firm} if high_tax==1, absorb(i.id i.year) vce(cluster id)

*3. + firm-level and host-country industry-year FE
eststo: reghdfe Irate_w99 post_ukparent  ${ctrl_firm} if high_tax==1, absorb(i.id i.year#i.nace_1digit) vce(cluster id)

*4. + firm-level and host-country industry-year FE, + host-country level controls 
eststo: reghdfe Irate_w99 post_ukparent ${ctrl_firm} ${ctrl_host} if high_tax==1, absorb(i.id i.year#i.nace_1digit) vce(cluster id)

*5. + firm-level and host-country level controls + country-year fixed effects
eststo: reghdfe Irate_w99 post_ukparent ${ctrl_firm} ${ctrl_host} ${ctrl_home} if high_tax==1, absorb(i.id i.year#i.nace_1digit) vce(cluster id)

*6. + firm-level and host-country level controls + country-year fixed effects + host-country level controls
eststo: reghdfe Irate_w99 post_ukparent ${ctrl_firm} ${ctrl_host} ${ctrl_home} if high_tax==1, absorb(i.id i.year#i.nace_1digit i.year#i.ctry) vce(cluster id)

*7. replace DE dummy with the actual tax differential
eststo: reghdfe Irate_w99 post_ukparent ztax_diff_ukparentpost ${ctrl_firm} ${ctrl_home} ${ctrl_host} if high_tax==1, absorb(i.id i.year#i.nace_1digit i.year#i.ctry) vce(cluster id)

qui estout est* using "${cbt_resultdir}\reg_hightax.txt", cells(b(star fmt(%9.3f)) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01) ///
stats(N N_clust r2,  fmt(%9.0g %9.0g %9.4f)) label replace 


*************************Table 9. Investment Responses in the UK******************************

qui use "${cbt_datadir}\Exemption_MNE_UKsample", clear

global ctrl_firm lag_turn lag_cf lag_pm turn_g_lag 
global ctrl_host corp_rate lpop lunemp lgdp_capita host_governance host_stable_fi
global ctrl_home uo_gdpgrowth uo_gdppcap uo_governance uo_stable_fi

estimates clear
xtset id year

preserve 

keep if insample_mne==1

*1. no controls
eststo: reghdfe Irate_w99 post_ukmne if insample_exemption==1, absorb (i.id i.year) vce(cluster id)
*2. + firm-level controls
eststo: reghdfe Irate_w99 post_ukmne ${ctrl_firm} if insample_exemption==1, absorb (i.id i.year)  vce(cluster id)
*3. + firm-level and time-varying industry dummies
eststo: reghdfe Irate_w99 post_ukmne ${ctrl_firm} if insample_exemption==1, absorb (i.id i.year#i.nace_1digit)  vce(cluster id)
*4. + firm-level and host-country level controls + country-year fixed effects + host-country level controls
eststo: reghdfe Irate_w99 post_ukmne ${ctrl_firm} ${ctrl_home} ${ctrl_host} if insample_exemption==1, absorb (i.id i.year#i.nace_1digit) vce(cluster id)

*5. separating anticipation effects
eststo: reghdfe Irate_w99 year2008_ukparent post_ukmne ${ctrl_firm} ${ctrl_home} ${ctrl_host} if insample_exemption==1, absorb (i.id i.year#i.nace_1digit) vce(cluster id)
eststo: reghdfe Irate_w99 year2008_ukparent post_ukmne post2010_ukparent post2011_ukparent ${ctrl_firm} ${ctrl_home} ${ctrl_host} if insample_exemption==1, absorb (i.id i.year#i.nace_1digit) vce(cluster id)

qui estout est* using "${cbt_resultdir}\reg_uk.txt", cells(b(star fmt(%9.3f)) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01) ///
stats(N N_clust r2,  fmt(%9.0g %9.0g %9.3f )) label replace 

estimates clear
restore

preserve 

keep if insample_domestic==1

*1. no controls
eststo: reghdfe Irate_w99 post_ukmne, absorb(i.id i.year) vce(cluster id)
*2. + firm-level controls
eststo: reghdfe  Irate_w99 post_ukmne ${ctrl_firm}, absorb(i.id i.year) vce(cluster id)
*3. + firm-level and time-varying industry dummies
eststo: reghdfe  Irate_w99 post_ukmne ${ctrl_firm}, absorb(i.id i.year#i.nace_1digit) vce(cluster id)
*4. + firm-level and host-country level controls + country-year fixed effects + host-country level controls
eststo: reghdfe  Irate_w99 post_ukmne ${ctrl_firm} ${ctrl_home} ${ctrl_host}, absorb(i.id i.year#i.nace_1digit) vce(cluster id)

*5. separating anticipation effects
eststo: reghdfe  Irate_w99 year2008_ukparent post_ukmne ${ctrl_firm} ${ctrl_home} ${ctrl_host}, absorb(i.id i.year#i.nace_1digit) vce(cluster id)
eststo: reghdfe  Irate_w99 year2008_ukparent post_ukmne post2010_ukparent post2011_ukparent ${ctrl_firm} ${ctrl_home} ${ctrl_host}, absorb(i.id i.year#i.nace_1digit) vce(cluster id)

qui estout est* using "${cbt_resultdir}\reg_uk.txt", cells(b(star fmt(%9.3f)) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01) ///
stats(N N_clust r2,  fmt(%9.0g %9.0g %9.3f )) label append 

estimates clear
restore

keep if insample_parent==1

*1. no controls
eststo: xtreg Irate_w99 post_ukparent year_d2-year_d7, fe vce(cluster id)
*2. + firm-level controls
eststo: xtreg Irate_w99 post_ukparent year_d2-year_d7 ${ctrl_firm}, fe vce(cluster id)
*3. + firm-level and time-varying industry dummies
eststo: xi: xtreg Irate_w99 post_ukparent year_d2-year_d7 ${ctrl_firm} i.year*i.nace_1digit, fe vce(cluster id)
*4. + firm-level and host-country level controls + country-year fixed effects + host-country level controls
eststo: xi: xtreg Irate_w99 post_ukparent year_d2-year_d7 ${ctrl_firm} ${ctrl_host} i.year*i.nace_1digit, fe vce(cluster id)

qui estout est* using "${cbt_resultdir}\reg_uk.txt", cells(b(star fmt(%9.3f)) se(par)) starlevels(* 0.10 ** 0.05 *** 0.01) ///
stats(r2 N,  fmt(%9.3f %9.0g) labels(R-squared)) label append


*************************Table 10. Predicted Investment Increases in Low-Tax Countries******************************

qui use "${cbt_datadir}\Exemption4reg_MNE_uo", clear

keep if insample_foreign==1

*the interaction term*
gen post_ukparent=uk_parent*post
gen announced_ukparent=uk_parent*announced
gen tax_diff=(corp_uk-corp_rate)*100
gen tax_diffukparentpost=tax_diff*post_ukparent
gen tax_diffukparent=tax_diff*uk_parent

*standardize tax_diff

sum tax_diff if low_tax==1, d
gen z_tax_diff=tax_diff-r(mean)
sum tax_diff if high_tax==1
replace z_tax_diff=tax_diff-r(mean) if high_tax==1


*firm-level controls*
xtset id year
bysort id: gen lag_turn=turnover_real[_n-1]
bysort id: gen lag_pm=profit_margin[_n-1]
bysort id: gen lag_turn2=log(lag_turn)

*country-level controls*
qui replace pop=pop/1000
gen lpop=ln(pop)
gen lunemp=ln(unemp)
gen lgdp_capita=ln(gdp_capita)

*host-home country pair*
egen ctry=group(country)
egen guo_ctry=group(uo_ctry)

*terciles of tax differential

xtile tax_diff_q=tax_diff if low_tax==1, n(3)
tab tax_diff_q, gen (taxq)
 

keep if low_tax==1

estimates clear
xtset id year

*firm-level increase in investment*

sum K_lag if uk_parent==1 & post==0 & low_tax==1
sca K_bar=r(mean)

sum Irate_w99 if uk_parent==1 & post==0 & low_tax==1
sca I_bar=r(mean)

sca firm_inc=I_bar*0.167*K_bar
sca li firm_inc

*country-level average decrease in tax rate*

collapse (min)tax_diff_q (sum)K_lag , by(country uk_parent post)

drop if post==1
drop if uk_parent==0

gen I_inc=I_bar*(0.096)*K_lag/1000 if tax_diff_q==1
replace I_inc=I_bar*(0.143)*K_lag/1000 if tax_diff_q==2
replace I_inc=I_bar*(0.464)*K_lag/1000 if tax_diff_q==3

collapse (sum)I_inc tax_diff_q, by(country)

egen I_total=total(I_inc)
sum I_total

sort country

export excel using "${cbt_resultdir}\investment_increase", sheetreplace firstrow(variables)

clear
exit
