************************
***Trial Regression*****
************************

qui use "${cbt_datadir}\Exemption_MNE", clear

keep country year corp_rate corp_uk

duplicates drop

gen obs=1

*low-tax countries: with CIT rates always below the UK rate
gen corp_low=corp_rate<=corp_uk & corp_rate!=.
bysort country: egen low_tax_total=total(corp_low)
bysort country: egen obs_total=total(obs)
tab low_tax_total
tab obs_total

gen low_tax=low_tax_total==obs_total

*high-tax countries: with CIT rates always above the UK rate
gen corp_high=corp_rate>corp_uk & corp_rate!=.
bysort country: egen high_tax_total=total(corp_high)
tab high_tax_total

gen high_tax=high_tax_total==obs_total

keep country low_tax high_tax
duplicates drop

merge 1:m country using "${cbt_datadir}\Exemption_MNE"

drop _merge

gen insample_exemption=(uo_ctry!="IE" & uo_ctry != "IL" & uo_ctry !="KR" & uo_ctry != "MX" & uo_ctry != "PL" & uo_ctry !="US" & uo_ctry !="JP")
keep if insample_exemption==1

gen uk_parent=uo_ctry=="GB"
gen post=year>=2009
gen announced=year==2008


*Key Variables*

*the interaction term*
gen post_ukparent=uk_parent*post
gen announced_ukparent=uk_parent*announced

gen tax_diff= corp_uk-corp_rate 
replace tax_diff=corp_rate-corp_uk if low_tax==0
gen tax_diff_ukparent=uk_parent*tax_diff*(post)

*tripple DDD terms*

gen post_ukparent_low=uk_parent*post*low_tax
gen post_low=post*low_tax
gen ukparent_low_tax=uk_parent*low_tax

gen post_ukparent_high=uk_parent*post*(1-low_tax)
gen post_high=post*(1-low_tax)
gen ukparent_high_tax=uk_parent*(1-low_tax)

*standardize tax_diff

sum tax_diff if low_tax==1, d
gen z_tax_diff=tax_diff-r(mean)
sum tax_diff if high_tax==1
replace z_tax_diff=tax_diff-r(mean) if high_tax==1
gen ztax_diff_ukparentpost=uk_parent*(z_tax_diff)*post
gen ztax_diff_ukparent=uk_parent*(z_tax_diff)




*firm-level controls*
xtset id year
bysort id: gen lag_turn=turnover_real[_n-1]
bysort id: gen lag_pm=profit_margin[_n-1]
bysort id: gen lag_turn2=log(lag_turn)

*country-level controls*
qui replace pop=pop/1000
gen lpop=ln(pop)
gen lunemp=ln(unemp)
gen lgdp_capita=ln(gdp_capita)

*host-home country pair*
egen countrypair=group(country uo_ctry)
egen ctry=group(country)


save "${cbt_datadir}\Exemption_MNE4reg", replace
