

********************************************************
*Title: AEJPol-2018-0592_DATA_table_1-2.do
*Date: 28 June, 2018
*Author: Li Liu
********************************************************


***********************Table 1. Descriptive Statistics**************************

qui use "${cbt_datadir}\Exemption4reg_MNE", replace

qui mat desc_stats=J(20,5,0)

local varlist I K Irate_w99 Irate_net_w99 turnover cashflow pmargin_w turn_g ///
 pop gdp_capita unemp corp_rate host_governance host_stable_fi uo_gdpgrowth uo_gdppcap  ///
 uo_unemp uo_pop uo_governance uo_stable_fi 
 
 local i=1
 foreach var of varlist `varlist' {
 qui sum `var', d
 qui mat desc_stats[`i', 1]=r(N)
  qui mat desc_stats[`i',2]=r(mean)
  qui mat desc_stats[`i',3]=r(p10)
 qui mat desc_stats[`i',4]=r(p50)
  qui mat desc_stats[`i',5]=r(p90)
 local i=`i'+1
 }
 
mat2txt, matrix(desc_stats) saving("${cbt_resultdir}\desc_stats.xls") replace 

***********************Table 2. High-tax versus low-tax countries***************

keep country country_name low_tax high_tax corp_rate year
bysort country: gen tax_2005=corp_rate if year==2005
bysort country: egen tax_05=max(tax_2005)
bysort country: gen tax_2011=corp_rate if year==2011
bysort country: egen tax_11=max(tax_2011)

keep country_name tax_05 tax_11 low_tax high_tax
duplicates drop

sort low_tax high_tax

export excel using "${cbt_resultdir}\countrytable_lowtax", firstrow(variables) sheetreplace


clear
exit
