
clear all
set more off 
cap log close 
set mem 12g 
set matsize 11000

global dir "/home/research/cavoced/cred" 
global build "$dir/build"
global analy "$dir/analysis"

global prodir "${analy}/prog"
global logdir "${analy}/prog" 
global rawdir "${analy}/raw" 
global temdir "${analy}/temp" 
global anadir "${analy}/data"
global outdir "${analy}/output"

global texdir "$outdir/tex"
global txtdir "$outdir/txt"
global xlsdir "$outdir/xls"
global londir "$outdir/xls/long"
global figdir "$outdir/figs"
set scheme s1color
local figbacks "plotregion(fcolor(white)) graphregion(fcolor(white) lwidth(large)) bgcolor(white)"


*read in quarterly effects from CENCOL_byyearbyquarter.do
insheet using $anadir/quarterlyeffects.csv, clear
set obs 200

	rename (v1 v2 v3 v4 v5) (eff t feff deff dfeff)
	replace t=_n-1
		gen years=floor(t/4)
	*Create up-front costs, either full or half
	
	gen fullcost=0
		replace fullcost=345 if t<8
		gen halfcost=0
	*convert log effect to percent
	gen pcteff_full=exp(eff)-1
	gen pctfeff_full=exp(feff)-1
	gen pctdeff_full=deff
	gen pctdfeff_full=dfeff
		*assume 20% effect if not estimated (t>20), since this is the mean of the last 4 years
		replace pcteff_full=exp(.2)-1 if pcteff==.
		replace pctfeff_full=exp(.427)-1 if pctfeff==.
		replace pctdeff_full=2228 if pctdeff_full==.
		replace pctdfeff_full=6773 if pctdfeff_full==.
		*calculate an average dropoff rate in the effect: make a conservative (80%) and intermediate one (90%)		
		gen pcteff_const=pcteff_full
		replace pcteff_const=(exp(.2)-1)*(0.8^(year-5)) if t>20
		gen pcteff_inter=pcteff_full
		replace pcteff_inter=(exp(.2)-1)*(0.9^(year-5)) if t>20	
		gen pctfeff_const=pctfeff_full
		replace pctfeff_const=(exp(.427)-1)*(0.8^(year-5)) if t>20
		gen pctfeff_inter=pctfeff_full
		replace pctfeff_inter=(exp(.427)-1)*(0.9^(year-5)) if t>20	
		gen pctdeff_const=pctdeff_full
		replace pctdeff_const=2228*(0.8^(year-5)) if t>20
		gen pctdeff_inter=pctdeff_full
		replace pctdeff_inter=2228*(0.9^(year-5)) if t>20	
		gen pctdfeff_const=pctdfeff_full
		replace pctdfeff_const=6773*(0.8^(year-5)) if t>20
		gen pctdfeff_inter=pctdfeff_full
		replace pctdfeff_inter=6773*(0.9^(year-5)) if t>20	

		
	*Create different wage growth for the control group
		gen earn_0g=4740
		gen earn_1g=4740*(1.01^year)
		gen earn_2g=4740*(1.02^year)
		gen earn_3g=4740*(1.03^year)
		gen earn_5g=4740*(1.05^year)
		gen earn_10g=4740*(1.1^year)

	
	*Calculate benefits
	
	foreach e in 0 3  10{
	foreach f in full const{
	foreach h in full half{	
	foreach g in 120 {
	foreach d in eff feff{
		gen b_`h'_`g'_`f'_`d'_`e'=earn_`e'g*pct`d'_`f'-`h'cost if _n<=`g'
			replace b_`h'_`g'_`f'_`d'_`e'=-CENCOL0 if t==0/*put all the supplies up front*/
		gen b_s`h'_`g'_`f'_`d'_`e'=earn_`e'g*pct`d'_`f'-`h'cost if _n<=`g'
			replace b_s`h'_`g'_`f'_`d'_`e'=-CENCOL0-19000 if t==0/*put all the supplies up front PLUS the 19k*/
			}
		gen b_`h'_`g'_`f'_deff_`e'=pctdeff_`f'-`h'cost if _n<=`g'
			replace b_`h'_`g'_`f'_deff_`e'=b_`h'_`g'_`f'_deff_`e'-CENCOL0 if t==0/*put all the supplies up front*/
		gen b_`h'_`g'_`f'_dfeff_`e'=pctdfeff_`f'-`h'cost if _n<=`g'
			replace b_`h'_`g'_`f'_dfeff_`e'=b_`h'_`g'_`f'_dfeff_`e'-CENCOL0 if t==0/*put all the supplies up frontPLUS the 19k*/

		gen b_s`h'_`g'_`f'_deff_`e'=pctdeff_`f'-`h'cost if _n<=`g'
			replace b_s`h'_`g'_`f'_deff_`e'=b_`h'_`g'_`f'_deff_`e'-CENCOL0-19000 if t==0/*put all the supplies up front*/
		gen b_s`h'_`g'_`f'_dfeff_`e'=pctdfeff_`f'-`h'cost if _n<=`g'
			replace b_s`h'_`g'_`f'_dfeff_`e'=b_`h'_`g'_`f'_dfeff_`e'-CENCOL0-1900 if t==0/*put all the supplies up frontPLUS the 19k*/
			}
			}
			}
			}
	
	*create version with non-imputed data (just quarters 0-21)
		foreach v of varlist b_*{
			gen b`v'=`v'
				replace `v'=0 if _n>21
				}
	
	tempfile base
	save `base'

	use `base', clear
		foreach g of varlist b*{
			gen d_`g'=`g'
			}		

			collapse(sum) d*
		gen r=0
		tempfile rtests
		save `rtests'
	
	forvalues i=1/1000{
		
		use `base', clear
		gen r=`i'/200
		foreach g of varlist b*{
			gen d_`g'=`g'/((1+r)^t)
			}
			
		collapse(sum) d*
		gen r=`i'/200
		append using `rtests'
		save `rtests', replace
		}
		sort r
	
	*pull out the irr's
		foreach g of varlist d*{
			gen trash=r if `g'<0
			egen r`g'=min(trash)
				drop trash
				}
	
		keep if r>.0299 & r<.03111
			keep r rd* d_*
			foreach g of varlist rd*{
				replace `g'=(`g'+1)^4-1
				}
		*IV
		tabstat rd_b_full_120_full_eff*  rd_b_half_120_full_eff* 
		*FE
		tabstat rd_b_full_120_full_feff*  rd_b_half_120_full_feff* 

		*IV
		tabstat d_b_full_120_full_eff*  d_b_half_120_full_eff* 
		*FE
		tabstat d_b_full_120_full_feff*  d_b_half_120_full_feff* 
				
		sum rd_b_half_120_full_deff_0
		
		
*now the ones with no imputation		
		*IV
		tabstat rd_bb_full_120_full_eff*  rd_bb_half_120_full_eff* 
		*FE
		tabstat rd_bb_full_120_full_feff*  rd_bb_half_120_full_feff* 

		*IV
		tabstat d_bb_full_120_full_eff*  d_bb_half_120_full_eff* 
		*FE
		tabstat d_bb_full_120_full_feff*  d_bb_half_120_full_feff* 
				
		sum rd_bb_half_120_full_deff_0		