cd U:\Projects\cred\Raw
set scheme s1color
use oes_CA_9913, clear
gen yearn="20"+year
replace yearn="1999" if yearn=="2099"
destring yearn, replace
destring tot_emp, replace ignore("*")
destring h_mean, replace force

gen emp_tot=tot_emp
gen emp_aid=tot_emp*(substr(occ_code,1,4)=="31-1")
gen emp_RN=tot_emp*(occ_code=="29-1141"|occ_code=="29-1111")
gen emp_LPN=tot_emp*(inlist(occ_code,"29-2061","29-2021","29-2034","29-2051","29-2037","29-2054","29-2055")==1)
gen emp_health=tot_emp*(substr(occ_code,1,2)=="29")

gen emp_tech=tot_emp*(inlist(occ_code,"29-2021","29-2034","29-2051","29-2037","29-2054","29-2055")==1)
*See Holzer and Lerman (2007) for other numbers
gen emp_con=tot_emp*(inlist(occ_code,"47-2031","47-2111","47-2141","47-2073","47-2152")==1)
gen emp_ins=tot_emp*(substr(occ_code,1,2)=="49" & (inlist(substr(occ_code,4,3),"301","302","303","902","904")==1|substr(occ_code,4,4)=="9071"))
gen emp_pol=tot_emp*(inlist(occ_code,"33-3051","33-3052","33-3041","33-3031","33-3012","33-3011","33-2011")==1)
gen emp_comp=tot_emp*(inlist(occ_code,"15-1150","15-1151","15-1152","15-1041")==1)



collapse(sum) emp* , by(yearn)

replace emp_tot=. if yearn<2001
foreach z of varlist emp* {
gen `z'2001=`z' if yearn==2001
egen m`z'2001=mean(`z'2001)
replace `z'=`z'/m`z'2001-1
drop `z'2001 m`z'2001
}
sort yearn
#delimit;
	replace emp_ins=.;
	replace emp_pol=.;
	replace emp_comp=.;
scatter emp* yearn if yearn>2000, 
	ytitle("% Change in Employment")
	xlabel(2001(1)2013) xtitle("")
	ylabel(-0.2(0.2)0.4, nogrid)
	connect(l l l l l l l l)
	lcolor(black red  blue  teal red ) mcolor(black red blue teal)
	msymbol(O O O O none none none) 
	lwidth(medthick medthick medthick medthick med med )
	lpattern(dash solid solid solid solid)
	legend(cols(2) order( 2 "Registered Nurses" 3 "Other Skilled Health" 4 "Assistants/Aides" 1 "Total Employment"/*4 "Maint/Repair" 5 "Public/Prot" 6 "Comp Support"*/))
	plotregion(fcolor(white)) graphregion(fcolor(white) ) bgcolor(white)
	;
	graph export "U:\Projects\cred\tables\papertables\intrograph1.eps", replace;
