***-----------------------------------------------------------------------------------------------------------------------------***	
***   				Barrage, Chyn, Hastings (2019, AEJ:Policy)		     				        ***
***						TABLE 3										***	
***-----------------------------------------------------------------------------------------------------------------------------***	
	
/* This do-file replicates BCH Table 3.
Inputs:   BCH_Replication_Table3.dta
Outputs:  Table3_BCH.xls
*/
	
clear all
set more off

*Install programs:
cap net install outreg2, from(http://fmwww.bc.edu/repec/bocode/o/)
cap net install ivreg2, from(http://fmwww.bc.edu/repec/bocode/i/)

*Set directory:
include 1_SET_DIRECTORY.do

*Open data:
use BCH_Replication_Table3.dta, clear

 
******************** 
** Table 3, Col 1 **  
********************

reg price_diff bp1 green_index bp1_green dm_inc bp1_dminc dm_core_adsp_t00_08 bp1_core_adsp_t00_08, cluster(random_zip) 
 
egen id_tag=tag(random_id) if e(sample)==1
count if id_tag==1
local stations=`r(N)'
drop id_tag	
cap outreg2 using Table3_BCH.xls, replace label excel adjr2 stats(coef se) dec(3) ///
addstat(# of msas,`e(N_clust)', # of stations,`stations') ctitle("price diff")

	   
******************** 
** Table 3, Col 2 **  
********************    
             
reg lnq_diff bp1 green_index bp1_green dm_inc bp1_dminc dm_core_adsp_t00_08 bp1_core_adsp_t00_08, cluster(random_zip) 

egen id_tag=tag(random_id) if e(sample)==1
count if id_tag==1
local stations=`r(N)'
drop id_tag

cap outreg2 using Table3_BCH.xls, append label excel adjr2 stats(coef se) dec(3) ///
addstat(# of msas,`e(N_clust)', # of stations,`stations') ctitle("sales diff")


****************************
** Table 3, Cols. 3, 4, 5 **  
****************************
use BCH_Replication_Table3.dta, clear


ivreg2 price_diff bp1 green_index bp1_green dm_inc bp1_dminc (dm_core_adsp_t00_08 bp1_core_adsp_t00_08=total_elections bp1_total_elections), savefirst savefprefix(i) first cluster(random_zip)

estimates query

egen id_tag=tag(random_id) if e(sample)==1
count if id_tag==1
local stations=`r(N)'
drop id_tag
	  	  	  
est store _ivreg2_price_diff
est restore idm_core_adsp_t00_08
cap outreg2 using Table3_BCH.xls, append label excel stats(coef se) dec(3) ctitle("BP Adspend, Demeaned") 
est restore ibp1_core_adsp_t00_08
cap outreg2 using Table3_BCH.xls, append label excel stats(coef se) dec(3) ctitle("BP*(BP Adspend, Demeaned)")
est restore _ivreg2_price_diff
cap outreg2 using Table3_BCH.xls, append label excel stats(coef se) dec(3) addstat(# of msas,`e(N_clust)', # of stations,`stations') ctitle("price diff")


****************************
** Table 3, Cols. 6, 7, 8 **  
****************************
     
ivreg2 lnq_diff bp1 green_index bp1_green dm_inc bp1_dminc (dm_core_adsp_t00_08 bp1_core_adsp_t00_08=total_elections bp1_total_elections), savefirst savefprefix(i) first cluster(random_zip)
          
egen id_tag=tag(random_id) if e(sample)==1
count if id_tag==1
local stations=`r(N)'
drop id_tag
       
est store _ivreg2_q_diff
est restore idm_core_adsp_t00_08
cap outreg2 using Table3_BCH.xls, append label excel stats(coef se) dec(3) ctitle("BP Adspend, Demeaned")
est restore ibp1_core_adsp_t00_08
cap outreg2 using Table3_BCH.xls, append label excel stats(coef se) dec(3) ctitle("BP*(BP Adspend, Demeaned)")
est restore _ivreg2_q_diff
cap outreg2 using Table3_BCH.xls, append label excel stats(coef se) dec(3) addstat(# of msas,`e(N_clust)', # of stations,`stations') ctitle("sales diff")
	  
