***************
*** Table 3 ***
***************

***************
*** Panel A ***
***************

* Same as Table 2 but keep only units with random assignment 
clear
gen variable = ""
save Table3a, replace

* Compute examiner effects
foreach x in kogan_patv_win ///
log_totcites nonnpe NPE_portfolio litigated_v2 NPE_litigated {

use examiner_effect_dataset, clear

merge m:1 artunit docket_year using random_digit_artunit_years_10_pct_v2
* keep only units with random assignment 
keep if _merge==3
drop _merge

drop if `x' == .

areg `x', absorb(year_artunit)
* i) get predicted values and residual:
predict x_predict, xbd
gen double x_residual=`x'-x_predict

* document the variance and residual variance
sum `x', d
gen double x_mean=r(mean)
gen double x_sd=r(sd)
gen double x_var=r(Var)
sum x_residual, d
gen double x_residual_sd=r(sd)
gen double x_residual_var=r(Var)

drop examiner_year_artunit

// ii) Extract the average residual for an examiner x year
egen examiner_year=group(examiner filing_year)
bysort examiner_year: egen double residual_examiner_share=sum(x_residual)
bysort examiner_year: replace residual_examiner_share=residual_examiner_share/[_N]
bysort examiner_year: gen examiner_year_grantn=[_N]


* iii) compute the covariance between the average residual in an examiner's portfolio 
* year t and t+1
preserve 
keep examiner filing_year residual_examiner_share examiner_year_grantn
duplicates drop 
sort examiner filing_year
bysort examiner: gen residual_examiner_share_next=residual_examiner_share[_n+1]
bysort examiner: gen examiner_year_grantn_n=examiner_year_grantn[_n+1]
gen weight=round((examiner_year_grantn+examiner_year_grantn_n)/2)
correlate residual_examiner_share residual_examiner_share_next [fw=weight], covar // WEIGHT
restore
gen double x_signal_var=r(cov_12) 
gen double x_signal_sd=sqrt(r(cov_12))


* iv) compute the variance of the idiosyncratic component, which is estimated as a remainder
gen x_epsilon_var=x_residual_var-x_signal_var
gen x_epsilon_sd=sqrt(x_epsilon_var)


* v) take a simple average of the residual for each examiner
bysort examiner: egen double residual_examiner=sum(x_residual)
bysort examiner: replace residual_examiner=residual_examiner/[_N]
bysort examiner: gen examiner_grant_n=[_N]
* note that this last variable counts the total number of patents across all years aand artunits, 
* i.e. n*T in Kane and Staiger's notation)

* vi) shrinkage
keep examiner x_residual_var x_epsilon_var x_signal_var x_mean examiner_grant_n ///
x_signal_sd x_var x_sd residual_examiner x_epsilon_sd
duplicates drop

gen shrinkage_factor=x_signal_var/(x_signal_var+x_epsilon_var/(examiner_grant_n))
gen shrunk_examiner_effect=residual_examiner*shrinkage_factor
sum shrunk_examiner_effect, d
gen examiner_effect=residual_examiner

gen signal_sd_effect = x_signal_sd/x_mean*100
gen shrunk_sd_effect = r(sd)/x_mean*100
gen p25p75_effect = (r(p75)-r(p25))/x_mean*100
gen p5p95_effect = (r(p95)-r(p5))/x_mean*100

* to compute the effect of replacing examiners above the p90 by examiners at the p90, 
* we compute the different between the mean rate above p90 and the rate at p90, multiply by the mass
* of examiners in this range (10%) and divide by the mean rate 
sum shrunk_examiner_effect if shrunk_examiner_effect>r(p90)
gen mean_above_p90=r(mean)
sum shrunk_examiner_effect, d
gen abovep90_effect=((mean_above_p90-r(p90))*0.1)/x_mean*100
drop mean_above_p90

sum shrunk_examiner_effect, d
sum shrunk_examiner_effect if shrunk_examiner_effect>r(p75)
gen mean_above_p75=r(mean)
sum shrunk_examiner_effect, d
gen abovep75_effect=((mean_above_p75-r(p75))*0.25)/x_mean*100
drop mean_above_p75


rename examiner_grant_n examiner_grantn


// save computation for each examiner
gen outcome_x="`x'"
save `x'_examiner_effect_randomdigits, replace

// save the overall results in a smaller table
keep x_mean x_sd  signal_sd_effect shrunk_sd_effect p25p75_effect p5p95_effect abovep90_effect abovep75_effect outcome_x 
duplicates drop 
save `x'_examiner_effect_tablerandomdigits, replace
append using Table3a
save Table3a, replace
}

* now repeat, but excluding IT art units

foreach x in kogan_patv_win ///
log_totcites nonnpe NPE_portfolio litigated_v2 NPE_litigated {

use examiner_effect_dataset, clear

gen tc = floor(artunit / 100)
gen three_digit = floor(artunit / 10)
* keep only IT art units
keep if tc == 21 | tc == 24 | tc == 26 | three_digit == 362 | three_digit == 368 | three_digit == 369  // units highlighted by Simcoe

drop if `x' == .

areg `x', absorb(year_artunit)
* i) get predicted values and residual:
predict x_predict, xbd
gen double x_residual=`x'-x_predict

* document the variance and residual variance
sum `x', d
gen double x_mean=r(mean)
gen double x_sd=r(sd)
gen double x_var=r(Var)
sum x_residual, d
gen double x_residual_sd=r(sd)
gen double x_residual_var=r(Var)

drop examiner_year_artunit

// ii) Extract the average residual for an examiner x year
egen examiner_year=group(examiner filing_year)
bysort examiner_year: egen double residual_examiner_share=sum(x_residual)
bysort examiner_year: replace residual_examiner_share=residual_examiner_share/[_N]
bysort examiner_year: gen examiner_year_grantn=[_N]


* iii) compute the covariance between the average residual in an examiner's portfolio 
* year t and t+1
preserve 
keep examiner filing_year residual_examiner_share examiner_year_grantn
duplicates drop 
sort examiner filing_year
bysort examiner: gen residual_examiner_share_next=residual_examiner_share[_n+1]
bysort examiner: gen examiner_year_grantn_n=examiner_year_grantn[_n+1]
gen weight=round((examiner_year_grantn+examiner_year_grantn_n)/2)
correlate residual_examiner_share residual_examiner_share_next [fw=weight], covar // WEIGHT
restore
gen double x_signal_var=r(cov_12) 
gen double x_signal_sd=sqrt(r(cov_12))


* iv) compute the variance of the idiosyncratic component, which is estimated as a remainder
gen x_epsilon_var=x_residual_var-x_signal_var
gen x_epsilon_sd=sqrt(x_epsilon_var)


* v) take a simple average of the residual for each examiner
bysort examiner: egen double residual_examiner=sum(x_residual)
bysort examiner: replace residual_examiner=residual_examiner/[_N]
bysort examiner: gen examiner_grant_n=[_N]
* note that this last variable counts the total number of patents across all years aand artunits, 
* i.e. n*T in Kane and Staiger's notation)

* vi) shrinkage
keep examiner x_residual_var x_epsilon_var x_signal_var x_mean examiner_grant_n ///
x_signal_sd x_var x_sd residual_examiner x_epsilon_sd
duplicates drop

gen shrinkage_factor=x_signal_var/(x_signal_var+x_epsilon_var/(examiner_grant_n))
gen shrunk_examiner_effect=residual_examiner*shrinkage_factor
sum shrunk_examiner_effect, d
gen examiner_effect=residual_examiner

gen signal_sd_effect = x_signal_sd/x_mean*100
gen shrunk_sd_effect = r(sd)/x_mean*100
gen p25p75_effect = (r(p75)-r(p25))/x_mean*100
gen p5p95_effect = (r(p95)-r(p5))/x_mean*100

* to compute the effect of replacing examiners above the p90 by examiners at the p90, 
* we compute the different between the mean rate above p90 and the rate at p90, multiply by the mass
* of examiners in this range (10%) and divide by the mean rate 
sum shrunk_examiner_effect if shrunk_examiner_effect>r(p90)
gen mean_above_p90=r(mean)
sum shrunk_examiner_effect, d
gen abovep90_effect=((mean_above_p90-r(p90))*0.1)/x_mean*100
drop mean_above_p90

sum shrunk_examiner_effect, d
sum shrunk_examiner_effect if shrunk_examiner_effect>r(p75)
gen mean_above_p75=r(mean)
sum shrunk_examiner_effect, d
gen abovep75_effect=((mean_above_p75-r(p75))*0.25)/x_mean*100
drop mean_above_p75


rename examiner_grant_n examiner_grantn


// save computation for each examiner
gen outcome_x="`x'"
save `x'_examiner_effect_randomdigits, replace

// save the overall results in a smaller table
keep x_mean x_sd  signal_sd_effect shrunk_sd_effect p25p75_effect p5p95_effect abovep90_effect abovep75_effect outcome_x 
duplicates drop 
save `x'_examiner_effect_tablerandomdigits, replace
append using Table3a
save Table3a, replace
}



***************
*** Panel B ***
***************

* Similar to Table 2 but with controls
clear
gen variable = ""
save Table3b, replace

* (i) controls for (leave one out) examiner grant rate

foreach x in kogan_patv_win ///
log_totcites nonnpe NPE_portfolio litigated_v2 NPE_litigated {

use examiner_effect_dataset, clear
drop if `x' == .

* bring in controls
merge 1:1 examiner application using examiner_loo_grant_rate
keep if _merge==3
foreach i in 2 3 4 {
gen loo_grant_rate`i'=loo_grant_rate^`i'
}

areg `x' loo_grant_rate loo_grant_rate2 ///
loo_grant_rate3 loo_grant_rate4, absorb(year_artunit)
* i) get predicted values and residual:
predict x_predict, xbd
gen double x_residual=`x'-x_predict

* document the variance and residual variance
sum `x', d
gen double x_mean=r(mean)
gen double x_sd=r(sd)
gen double x_var=r(Var)
sum x_residual, d
gen double x_residual_sd=r(sd)
gen double x_residual_var=r(Var)

drop examiner_year_artunit

// ii) Extract the average residual for an examiner x year
egen examiner_year=group(examiner filing_year)
bysort examiner_year: egen double residual_examiner_share=sum(x_residual)
bysort examiner_year: replace residual_examiner_share=residual_examiner_share/[_N]
bysort examiner_year: gen examiner_year_grantn=[_N]


* iii) compute the covariance between the average residual in an examiner's portfolio 
* year t and t+1
preserve 
keep examiner filing_year residual_examiner_share examiner_year_grantn
duplicates drop 
sort examiner filing_year
bysort examiner: gen residual_examiner_share_next=residual_examiner_share[_n+1]
bysort examiner: gen examiner_year_grantn_n=examiner_year_grantn[_n+1]
gen weight=round((examiner_year_grantn+examiner_year_grantn_n)/2)
correlate residual_examiner_share residual_examiner_share_next [fw=weight], covar // WEIGHT
restore
gen double x_signal_var=r(cov_12) 
gen double x_signal_sd=sqrt(r(cov_12))


* iv) compute the variance of the idiosyncratic component, which is estimated as a remainder
gen x_epsilon_var=x_residual_var-x_signal_var
gen x_epsilon_sd=sqrt(x_epsilon_var)


* v) take a simple average of the residual for each examiner
bysort examiner: egen double residual_examiner=sum(x_residual)
bysort examiner: replace residual_examiner=residual_examiner/[_N]
bysort examiner: gen examiner_grant_n=[_N]
* note that this last variable counts the total number of patents across all years aand artunits, 
* i.e. n*T in Kane and Staiger's notation)

* vi) shrinkage
keep examiner x_residual_var x_epsilon_var x_signal_var x_mean examiner_grant_n ///
x_signal_sd x_var x_sd residual_examiner x_epsilon_sd
duplicates drop

gen shrinkage_factor=x_signal_var/(x_signal_var+x_epsilon_var/(examiner_grant_n))
gen shrunk_examiner_effect=residual_examiner*shrinkage_factor
sum shrunk_examiner_effect, d
gen examiner_effect=residual_examiner

gen signal_sd_effect = x_signal_sd/x_mean*100
gen shrunk_sd_effect = r(sd)/x_mean*100
gen p25p75_effect = (r(p75)-r(p25))/x_mean*100
gen p5p95_effect = (r(p95)-r(p5))/x_mean*100

* to compute the effect of replacing examiners above the p90 by examiners at the p90, 
* we compute the different between the mean rate above p90 and the rate at p90, multiply by the mass
* of examiners in this range (10%) and divide by the mean rate 
sum shrunk_examiner_effect if shrunk_examiner_effect>r(p90)
gen mean_above_p90=r(mean)
sum shrunk_examiner_effect, d
gen abovep90_effect=((mean_above_p90-r(p90))*0.1)/x_mean*100
drop mean_above_p90

sum shrunk_examiner_effect, d
sum shrunk_examiner_effect if shrunk_examiner_effect>r(p75)
gen mean_above_p75=r(mean)
sum shrunk_examiner_effect, d
gen abovep75_effect=((mean_above_p75-r(p75))*0.25)/x_mean*100
drop mean_above_p75


rename examiner_grant_n examiner_grantn


// save computation for each examiner
gen outcome_x="`x'"
save `x'_examiner_effect_grantquartic, replace

// save the overall results in a smaller table
keep x_mean x_sd  signal_sd_effect shrunk_sd_effect p25p75_effect p5p95_effect abovep90_effect abovep75_effect outcome_x 
duplicates drop 
save `x'_examiner_effect_tablegrantquartic, replace
append using Table3b
save Table3b, replace
}

* (ii) controls for (leave one out) examiner grant rate &
* application characteristics

foreach x in kogan_patv_win ///
log_totcites nonnpe NPE_portfolio litigated_v2 NPE_litigated {

use examiner_effect_dataset, clear
drop if `x' == .

* bring in controls
merge 1:1 examiner application using examiner_loo_grant_rate
keep if _merge==3
foreach i in 2 3 4 {
gen loo_grant_rate`i'=loo_grant_rate^`i'
}

merge 1:1 application using assignee_application_previous_stats_unique 
keep if _merge==3
drop _merge
foreach y in cum_granted cum_decisions cum_cites {
gen log_`y'_asg=log(1+`y')
}
drop cum_granted cum_decisions cum_cites

areg `x' loo_grant_rate log_* word_ct_all_indep_claims_app count_indep_claims_app, absorb(year_artunit)
* i) get predicted values and residual:
predict x_predict, xbd
gen double x_residual=`x'-x_predict

* document the variance and residual variance
sum `x', d
gen double x_mean=r(mean)
gen double x_sd=r(sd)
gen double x_var=r(Var)
sum x_residual, d
gen double x_residual_sd=r(sd)
gen double x_residual_var=r(Var)

drop examiner_year_artunit

// ii) Extract the average residual for an examiner x year
egen examiner_year=group(examiner filing_year)
bysort examiner_year: egen double residual_examiner_share=sum(x_residual)
bysort examiner_year: replace residual_examiner_share=residual_examiner_share/[_N]
bysort examiner_year: gen examiner_year_grantn=[_N]


* iii) compute the covariance between the average residual in an examiner's portfolio 
* year t and t+1
preserve 
keep examiner filing_year residual_examiner_share examiner_year_grantn
duplicates drop 
sort examiner filing_year
bysort examiner: gen residual_examiner_share_next=residual_examiner_share[_n+1]
bysort examiner: gen examiner_year_grantn_n=examiner_year_grantn[_n+1]
gen weight=round((examiner_year_grantn+examiner_year_grantn_n)/2)
correlate residual_examiner_share residual_examiner_share_next [fw=weight], covar // WEIGHT
restore
gen double x_signal_var=r(cov_12) 
gen double x_signal_sd=sqrt(r(cov_12))


* iv) compute the variance of the idiosyncratic component, which is estimated as a remainder
gen x_epsilon_var=x_residual_var-x_signal_var
gen x_epsilon_sd=sqrt(x_epsilon_var)


* v) take a simple average of the residual for each examiner
bysort examiner: egen double residual_examiner=sum(x_residual)
bysort examiner: replace residual_examiner=residual_examiner/[_N]
bysort examiner: gen examiner_grant_n=[_N]
* note that this last variable counts the total number of patents across all years aand artunits, 
* i.e. n*T in Kane and Staiger's notation)

* vi) shrinkage
keep examiner x_residual_var x_epsilon_var x_signal_var x_mean examiner_grant_n ///
x_signal_sd x_var x_sd residual_examiner x_epsilon_sd
duplicates drop

gen shrinkage_factor=x_signal_var/(x_signal_var+x_epsilon_var/(examiner_grant_n))
gen shrunk_examiner_effect=residual_examiner*shrinkage_factor
sum shrunk_examiner_effect, d
gen examiner_effect=residual_examiner

gen signal_sd_effect = x_signal_sd/x_mean*100
gen shrunk_sd_effect = r(sd)/x_mean*100
gen p25p75_effect = (r(p75)-r(p25))/x_mean*100
gen p5p95_effect = (r(p95)-r(p5))/x_mean*100

* to compute the effect of replacing examiners above the p90 by examiners at the p90, 
* we compute the different between the mean rate above p90 and the rate at p90, multiply by the mass
* of examiners in this range (10%) and divide by the mean rate 
sum shrunk_examiner_effect if shrunk_examiner_effect>r(p90)
gen mean_above_p90=r(mean)
sum shrunk_examiner_effect, d
gen abovep90_effect=((mean_above_p90-r(p90))*0.1)/x_mean*100
drop mean_above_p90

sum shrunk_examiner_effect, d
sum shrunk_examiner_effect if shrunk_examiner_effect>r(p75)
gen mean_above_p75=r(mean)
sum shrunk_examiner_effect, d
gen abovep75_effect=((mean_above_p75-r(p75))*0.25)/x_mean*100
drop mean_above_p75


rename examiner_grant_n examiner_grantn


// save computation for each examiner
gen outcome_x="`x'"
save `x'_examiner_effect_allctrl, replace

// save the overall results in a smaller table
keep x_mean x_sd  signal_sd_effect shrunk_sd_effect p25p75_effect p5p95_effect abovep90_effect abovep75_effect outcome_x 
duplicates drop 
save `x'_examiner_effect_tableallctrl, replace
append using Table3b
save Table3b, replace
}

* (iii) controls for (leave one out) examiner grant rate,
* application characteristics & their interactions

foreach x in kogan_patv_win ///
log_totcites nonnpe NPE_portfolio litigated_v2 NPE_litigated {

use examiner_effect_dataset, clear
drop if `x' == .

* bring in controls
merge 1:1 examiner application using examiner_loo_grant_rate
keep if _merge==3
foreach i in 2 3 4 {
gen loo_grant_rate`i'=loo_grant_rate^`i'
}

merge 1:1 application using assignee_application_previous_stats_unique 
keep if _merge==3
drop _merge
foreach y in cum_granted cum_decisions cum_cites {
gen log_`y'_asg=log(1+`y')
}
drop cum_granted cum_decisions cum_cites

* 1) interact all variables with the examiner variables
foreach i in log_cum_granted_asg log_cum_decisions_asg log_cum_cites_asg log_cum_granted_inv log_cum_decisions_inv log_cum_cites_inv ///
word_ct_all_indep_claims_app count_indep_claims_app {
gen `i'_i=`i'*loo_shrunk_examiner_effect
}
* 2) interact all applicant characteristics & application characteristics  
foreach i in log_cum_granted_asg log_cum_decisions_asg log_cum_cites_asg log_cum_granted_inv log_cum_decisions_inv log_cum_cites_inv {
gen `i'_iw=`i'*word_ct_all_indep_claims_app
}
foreach i in log_cum_granted_asg log_cum_decisions_asg log_cum_cites_asg log_cum_granted_inv log_cum_decisions_inv log_cum_cites_inv {
gen `i'_ic=`i'*count_indep_claims_app
}

areg `x' loo_shrunk_examiner_effect log_* word_ct_all_indep_claims_app* count_indep_claims_app*, absorb(year_artunit)
* i) get predicted values and residual:
predict x_predict, xbd
gen double x_residual=`x'-x_predict

* document the variance and residual variance
sum `x', d
gen double x_mean=r(mean)
gen double x_sd=r(sd)
gen double x_var=r(Var)
sum x_residual, d
gen double x_residual_sd=r(sd)
gen double x_residual_var=r(Var)

drop examiner_year_artunit

// ii) Extract the average residual for an examiner x year
egen examiner_year=group(examiner filing_year)
bysort examiner_year: egen double residual_examiner_share=sum(x_residual)
bysort examiner_year: replace residual_examiner_share=residual_examiner_share/[_N]
bysort examiner_year: gen examiner_year_grantn=[_N]


* iii) compute the covariance between the average residual in an examiner's portfolio 
* year t and t+1
preserve 
keep examiner filing_year residual_examiner_share examiner_year_grantn
duplicates drop 
sort examiner filing_year
bysort examiner: gen residual_examiner_share_next=residual_examiner_share[_n+1]
bysort examiner: gen examiner_year_grantn_n=examiner_year_grantn[_n+1]
gen weight=round((examiner_year_grantn+examiner_year_grantn_n)/2)
correlate residual_examiner_share residual_examiner_share_next [fw=weight], covar // WEIGHT
restore
gen double x_signal_var=r(cov_12) 
gen double x_signal_sd=sqrt(r(cov_12))


* iv) compute the variance of the idiosyncratic component, which is estimated as a remainder
gen x_epsilon_var=x_residual_var-x_signal_var
gen x_epsilon_sd=sqrt(x_epsilon_var)


* v) take a simple average of the residual for each examiner
bysort examiner: egen double residual_examiner=sum(x_residual)
bysort examiner: replace residual_examiner=residual_examiner/[_N]
bysort examiner: gen examiner_grant_n=[_N]
* note that this last variable counts the total number of patents across all years aand artunits, 
* i.e. n*T in Kane and Staiger's notation)

* vi) shrinkage
keep examiner x_residual_var x_epsilon_var x_signal_var x_mean examiner_grant_n ///
x_signal_sd x_var x_sd residual_examiner x_epsilon_sd
duplicates drop

gen shrinkage_factor=x_signal_var/(x_signal_var+x_epsilon_var/(examiner_grant_n))
gen shrunk_examiner_effect=residual_examiner*shrinkage_factor
sum shrunk_examiner_effect, d
gen examiner_effect=residual_examiner

gen signal_sd_effect = x_signal_sd/x_mean*100
gen shrunk_sd_effect = r(sd)/x_mean*100
gen p25p75_effect = (r(p75)-r(p25))/x_mean*100
gen p5p95_effect = (r(p95)-r(p5))/x_mean*100

* to compute the effect of replacing examiners above the p90 by examiners at the p90, 
* we compute the different between the mean rate above p90 and the rate at p90, multiply by the mass
* of examiners in this range (10%) and divide by the mean rate 
sum shrunk_examiner_effect if shrunk_examiner_effect>r(p90)
gen mean_above_p90=r(mean)
sum shrunk_examiner_effect, d
gen abovep90_effect=((mean_above_p90-r(p90))*0.1)/x_mean*100
drop mean_above_p90

sum shrunk_examiner_effect, d
sum shrunk_examiner_effect if shrunk_examiner_effect>r(p75)
gen mean_above_p75=r(mean)
sum shrunk_examiner_effect, d
gen abovep75_effect=((mean_above_p75-r(p75))*0.25)/x_mean*100
drop mean_above_p75


rename examiner_grant_n examiner_grantn


// save computation for each examiner
gen outcome_x="`x'"
save `x'_examiner_effect_allctrl_inter, replace

// save the overall results in a smaller table
keep x_mean x_sd  signal_sd_effect shrunk_sd_effect p25p75_effect p5p95_effect abovep90_effect abovep75_effect outcome_x 
duplicates drop 
save `x'_examiner_effect_tableallctrl_inter, replace
append using Table3b
save Table3b, replace
}


***************
*** Panel C ***
***************

clear
gen outcome = ""
save Table3c, replace

foreach v in nonnpe npe litigated {
clear

* Download data (see Matlab code for data generation)
use examiner_effects_computation_`v'

gen w_examiner_pred_resid = cases * examiner_pred_resid

collapse (sum) w_examiner_pred_resid (sum) cases (sum) `v', by(examiner)
replace w_examiner_pred_resid = w_examiner_pred_resid / cases

summ w_examiner_pred_resid [aw=cases], detail
gen shrunk_sd = r(sd)

egen tot1 = sum(`v')
egen tot2 = sum(cases)
gen baseline = tot1/tot2

keep baseline shrunk_sd
duplicates drop

gen shrunk_sd_norm = shrunk_sd / baseline

gen outcome = "`v'"

append using Table3c
save Table3c, replace
}

