***************
*** Table 1 ***
***************

clear
gen variable = ""
save Table1, replace

***************
** Panel A ****
***************

/////////////////////////////
// PAE/Litigation Outcomes //
/////////////////////////////

clear
use examiner_effect_dataset_v2
drop if patent == .

foreach v in NPE_portfolio nonnpe litigated_v2 NPE_litigated ///
  fourth_renew eighth_renew twelfth_renew {
	preserve
	summ `v', detail
	gen avg = r(mean)
	gen sd = r(sd)
	gen median = r(p50)
	gen min = r(min)
	gen max = r(max)
	gen N = r(N) 
	
	keep avg sd median min max N
	keep if _n == 1
	gen variable = "`v'"
	
	cd "$db\Clean Code\Summary Stats - For Paper"
	append using Table1
	save Table1, replace
	
	restore
}

////////////////////////
// Kogan patent value //
////////////////////////

use examiner_effect_dataset_v2, clear
rename patent patnum 
drop if missing(patnum) 
drop class 
merge 1:m patnum using kogan_patent_value.dta
keep if _merge==3
drop _merge
drop if missing(xi)
rename xi kogan_patv

* Document summary stats for the Kogan et al. outcome: 
sum kogan_patv, d
gen kogan_patv_win=kogan_patv
replace kogan_patv_win=r(p99) if kogan_patv>r(p99)
sum  kogan_patv_win, d

foreach v in kogan_patv kogan_patv_win {

	preserve
	summ `v', detail
	gen avg = r(mean)
	gen sd = r(sd)
	gen median = r(p50)
	gen min = r(min)
	gen max = r(max)
	gen N = r(N)
	
	keep avg sd median min max N
	keep if _n == 1
	gen variable = "`v'"
	
	append using Table1
	save Table1, replace
	
	restore
}

///////////////
// Citations //
///////////////

clear
use citations_data_cleaned
keep application log_tot_pat_cites log_external_pat_cites ///
log_internal_pat_cites tot_pat_cites_3ygrant external_pat_cites_3ygrant internal_pat_cites_3ygrant

merge 1:1 application using examiner_effect_dataset_v2
keep if _merge==3 
drop _merge

gen tot_pat_cites_3ygrant_restricted = tot_pat_cites_3ygrant
replace tot_pat_cites_3ygrant_restricted = . if external_pat_cites_3ygrant == .

foreach v in log_tot_pat_cites log_external_pat_cites ///
log_internal_pat_cites tot_pat_cites_3ygrant tot_pat_cites_3ygrant_restricted external_pat_cites_3ygrant internal_pat_cites_3ygrant {

	preserve
	summ `v', detail
	gen avg = r(mean)
	gen sd = r(sd)
	gen median = r(p50)
	gen min = r(min)
	gen max = r(max)
	gen N = r(N) 
	
	keep avg sd median min max N
	keep if _n == 1
	gen variable = "`v'"
	
	append using Table1
	save Table1, replace
	
	restore
}

/////////
// EPO //
/////////

clear
use examiner_effect_dataset_v2

drop if patent == .

merge 1:1 application using non_continuation_us_with_europe_filtered
keep if _merge == 3
drop _merge


foreach v in europe_grant {

	preserve
	summ `v', detail
	gen avg = r(mean)
	gen sd = r(sd)
	gen median = r(p50)
	gen min = r(min)
	gen max = r(max)
	gen N = r(N) 
	
	keep avg sd median min max N
	keep if _n == 1
	gen variable = "`v'"
	
	append using Table1
	save Table1, replace
	
	restore
}

clear
use Table1

order avg median sd N

save Table1, replace

***************
*** Panel B ***
***************



cd "$db\Clean Code\Examiner Effect Testing"
clear
use examiner_effect_dataset_v2


// basic stats: winsorized already
// want to show that there is heterogeneity coming in, but also heterogeneity in changes
foreach v in word_ct_all_indep_claims_app count_indep_claims_app word_ct_all_indep_claims_grant count_indep_claims_grant  ///
cindepclaim pcindepclaim cwordcount pcwordcount r101 r102a r103a r112a r112b {

	preserve
	summ `v', detail
	gen avg = r(mean)
	gen sd = r(sd)
	gen median = r(p50)
	gen min = r(min)
	gen max = r(max)
	gen N = r(N) // N captures non-missing data point count
	
	keep avg sd median min max N
	keep if _n == 1
	gen variable = "`v'"
	
	cd "$db\Clean Code\Summary Stats - For Paper"
	append using Table1b
	save Table1b, replace
	
	restore
}


// number of examiner decisions
merge 1:1 application using "$db\Clean Code\PAIR Data\application_events_summary"
keep if _merge == 1 | _merge == 3
drop _merge

foreach v in non_final_rejects final_rejects {

	preserve
	summ `v', detail
	gen avg = r(mean)
	gen sd = r(sd)
	gen median = r(p50)
	gen min = r(min)
	gen max = r(max)
	gen N = r(N) // N captures non-missing data point count
	
	keep avg sd median min max N
	keep if _n == 1
	gen variable = "`v'"
	
	cd "$db\Clean Code\Summary Stats - For Paper"
	append using Table1b
	save Table1b, replace
	
	restore
}



// merge on some more text stats
// C:\Users\Josh\Dropbox\ResearchJosh_Xavier\Clean Code\Text Analysis
// summary_relationships_text_diff


cd "$db\Clean Code\Examiner Effect Testing"
clear
use examiner_effect_dataset_v2

// only keep granted patents for now
merge 1:1 application using "$db\Data and Code\Claims Text Detailed\claim_grants_stats_indep_agg"
keep if _merge == 3
drop _merge

foreach v in or_ct sf_ct cns_ct {
	rename `v' grant_`v'
}

merge 1:1 application using "$db\Data and Code\Claims Text Detailed\claim_apps_stats_indep_agg"
keep if _merge == 3
drop _merge

foreach v in or_ct sf_ct cns_ct {
	rename `v' app_`v'
	gen diff_`v' = grant_`v' - app_`v'
	
	summ grant_`v', detail
	summ app_`v', detail
	summ diff_`v', detail
}



foreach v in diff_or_ct diff_sf_ct diff_cns_ct {

	preserve
	summ `v', detail
	gen avg = r(mean)
	gen sd = r(sd)
	gen median = r(p50)
	gen min = r(min)
	gen max = r(max)
	gen N = r(N) // N captures non-missing data point count
	
	keep avg sd median min max N
	keep if _n == 1
	gen variable = "`v'"
	
	cd "$db\Clean Code\Summary Stats - For Paper"
	append using Table1b
	save Table1b, replace
	
	restore
}




/*
Examiner-added citations:
- from Google Extracts
- only there for recent patents
- aggregated by citing patent (citation_type_agg.dta) 
// based on citation_type_raw (t=1 is applicant added)
*/
cd "$db\Clean Code\Examiner Effect Testing"
clear
use examiner_effect_dataset_v2


merge m:1 patent using "$db\Data and Code\Google XML Extracts\Grant\citation_type_agg"
keep if _merge == 3
drop _merge

// need to fix missing because it was based on a reshape
replace examiner_added_pc = 0 if examiner_added_pc == .
replace applicant_added_pc = 0 if applicant_added_pc == .

rename examiner_added_pc examiner_added_citations

foreach v in examiner_added_citations {

	preserve
	summ `v', detail
	gen avg = r(mean)
	gen sd = r(sd)
	gen median = r(p50)
	gen min = r(min)
	gen max = r(max)
	gen N = r(N) // N captures non-missing data point count
	
	keep avg sd median min max N
	keep if _n == 1
	gen variable = "`v'"
	
	append using Table1b
	save Table1b, replace
	
	restore
}



***************
*** Panel C ***
***************

use examiner_effect_dataset
merge 1:1 application using child_applications
keep if _merge == 1
drop _merge
merge 1:1 application using npe_portfolio_list
keep if _merge == 1 | _merge == 3
gen npe_holding = (_merge == 3)
drop _merge
sort artunit
egen npe_unit = max(npe_holding), by(artunit)
save raw_application_examiner_stats, replace

clear
gen median = 0
save Table1c, replace

clear
use raw_application_examiner_stats
gen cases = 1
sort examiner artunit
egen aus = tag(examiner artunit)
sort examiner filing_year
egen years = tag(examiner filing_year)
// collapse to examiner level: unique art units, cases, etc.
collapse (sum) cases (max) npe_unit (sum) accept (sum) npe_holding ///
(sum) aus (sum) years ///
(mean) r101 (mean) r102a (mean) r103a (mean) r112b, by(examiner)
gen grant_rate = accept / cases
gen npe_frac = npe_holding / accept
tab npe_unit 

foreach v in years aus cases {

preserve
summ `v' , detail

gen variable = "`v'"
gen median = r(p50)
gen mean = r(mean)
gen sd = r(sd)
gen max = r(max)

keep variable median mean sd max
gen N = _N
keep if _n == 1

append using Table1c
save Table1c, replace
restore


}

foreach v in grant_rate r101 r102a r103a r112b npe_frac {

preserve
summ `v', detail

gen variable = "`v'"
gen median = r(p50)
gen mean = r(mean)
gen sd = r(sd)
gen max = r(max)

keep variable median mean sd max
gen N = _N
keep if _n == 1

append using Table1c
save Table1c, replace
restore
}


clear
use Table1c
gen id = _n
gsort - id

order mean median sd

save Table1c, replace



