%%
function obj = calcGmmDynamic(params, data)

    % Calculate bounds
    [z1Bar, z0Bar, uz, flag] = calcCutoffs(params, data);
    if (flag~=1);
        obj = 1e8;
        return
    end

    % calculate bunching (section 5.2 of dynamic_bunching_model)
    bSim = calcBunching(params, data, z1Bar, z0Bar, uz);
            
    % return objective function
    error = bSim - data.bunch;
    %obj = error'*data.wMat*error;
    obj = 1/length(data.bunch) .* error'*data.wMat*error;
end