
********************************************************************************
********************************************************************************
** Make Table B.1
********************************************************************************
********************************************************************************
capture log close
log using "$tabdir/tableB1.log", replace
qui forvalues  r = 1/2 {

	local bw = 800
	local degree = 7
	local exclude = round(3e3 / `bw', 1)

	if `r' == 1 {
		local sample "Born January-March" 
		use "$datadir/s1Born13_8399", clear
	}
	if `r' == 2 {
		local sample "Born any month"
		use "$datadir/dens800_8399", clear
		sort age rdR
		by age: egen tCount = total(count)
		gen prob = count / tCount
		rename rdR rd1k
	}
	sort age rd1k
	by age: gen rdRound = -9600 if _n == 1
	by age: replace rdRound = rdRound[_n-1] + 800 if _n > 1
	

	sort age rdRound
	
	local row = 0
	gen ageGraph = .
	gen bunch = .
	gen bunchSE = .
	gen degree = .
	gen exclude = .
	gen bw = .
	forvalues a = 68/72 {
		bunchPoly rdRound prob if age ==  `a', /// 
			kink(0) exclude(`exclude') bw(`bw') degree(`degree') ///
			keep(0) print(0) nboot(100)
		
		local ++row
		local b = `r(scaledMass)'*`bw'
		local bse = `r(scaledMassBS)'*`bw'
		replace ageGraph = `a' in `row'
		replace bunch = `b' in `row'
		replace bunchSE = `bse' in `row'
		replace degree = `degree' in `row'
		replace exclude = `exclude' in `row'
		replace bw = `bw' in `row'
		
		local B`a' = string(`r(scaledMass)' * `bw', "%4.1f")
		local B`a'SE = string(`r(scaledMassBS)' * `bw' , "%4.1f")
		
		local zStat = `r(scaledMass)' / `r(scaledMassBS)'
		local p = 2*(1-normal(abs(`zStat')))
		
		local s = ""
		if `p'< =0.1 local s "$ ^{*}$ "
		if `p'< =0.05 local s "$ ^{**}$ "
		if `p'< =0.01 local s "$ ^{***}$ "
		
		local tLower = (`r(scaledMass)' - 1.96 * `r(scaledMassBS)')*`bw'
		local tUpper = (`r(scaledMass)' + 1.96 * `r(scaledMassBS)')*`bw'
		local ci`a' = "[" + string(`tLower', "%4.1f") + ", " + string(`tUpper', "%4.1f") + "]`s'"
	}

	noi di " `sample' &  `B68'  &  `B69'  &  `B70'  &  `B71'  &  `B72'  \\" 
	noi di " &  `ci68'  &  `ci69'  &  `ci70'  &  `ci71'  &  `ci72'  \\" 

}
log close

********************************************************************************
********************************************************************************
** Make Table B.2
********************************************************************************
********************************************************************************
capture log close 
log using "$tabdir/tableB2.log", replace 
qui forvalues  r = 1/7 {

	// Row 1: Baseline
	if `r' == 1 {
		local bw = 800
		local degree = 7
		local exclude = round(3e3 / `bw', 1)
		noi di "Baseline" 
	}
	
	// Rows 2-3: Robustness to binsize
	if `r' == 2 {
		local bw = 400
		local degree = 7
		local exclude = round(3e3 / `bw', 1)
		noi di ""
		noi di ""
		noi di "Robustness to binsize"
	}
	if `r' == 3 {
		local bw = 1600
		local exclude = round(3e3 / `bw', 1)
		local exclude = 2
	}

	// Rows 4-5: Robustness to degree
	if `r' == 4 {
		local bw = 800
		local degree = 6
		local exclude = round(3e3 / `bw', 1)
		noi di ""
		noi di ""
		noi di "Robustness to degree"
	}
	
	if `r' == 5 {
		local bw = 800
		local degree = 8
		local exclude = round(3e3 / `bw', 1)
	}
		
	// Rows 6-7: Robustness to excluded region
	if `r' == 6 {
		local bw = 800
		local degree = 7
		local exclude = round(2e3 / `bw', 1)
		noi di ""
		noi di ""
		noi di "Robustness to excluded region"
	}
	
	if `r' == 7 {
		local bw = 800
		local degree = 7
		local exclude = round(4e3 / `bw', 1)
	}

	use "$datadir/dens`bw'", clear
	
	
	gen rdRound = round(rd1k * 1e3,1)
	sort age rdRound
	
	local row = 0
	gen ageGraph = .
	gen bunch = .
	gen bunchSE = .
	gen degree = .
	gen exclude = .
	gen bw = .
	forvalues a = 68/72 {
		bunchPoly rdRound prob if age ==  `a', /// 
			kink(0) exclude(`exclude') bw(`bw') degree(`degree') ///
			keep(0) print(0) nboot(100)
		
		local ++row
		local b = `r(scaledMass)'*`bw'
		local bse = `r(scaledMassBS)'*`bw'
		replace ageGraph = `a' in `row'
		replace bunch = `b' in `row'
		replace bunchSE = `bse' in `row'
		replace degree = `degree' in `row'
		replace exclude = `exclude' in `row'
		replace bw = `bw' in `row'
		
		local B`a' = string(`r(scaledMass)' * `bw', "%4.1f")
		local B`a'SE = string(`r(scaledMassBS)' * `bw' , "%4.1f")
		
		local zStat = `r(scaledMass)' / `r(scaledMassBS)'
		local p = 2*(1-normal(abs(`zStat')))
		
		local s = ""
		if `p'< =0.1 local s "$ ^{*}$ "
		if `p'< =0.05 local s "$ ^{**}$ "
		if `p'< =0.01 local s "$ ^{***}$ "
		
		local tLower = (`r(scaledMass)' - 1.96 * `r(scaledMassBS)')*`bw'
		local tUpper = (`r(scaledMass)' + 1.96 * `r(scaledMassBS)')*`bw'
		local ci`a' = "[" + string(`tLower', "%4.1f") + ", " + string(`tUpper', "%4.1f") + "]`s'"
	}

	noi di " `bw' & `degree' & `exclude' &  `B68'  &  `B69'  &  `B70'  &  `B71'  &  `B72'  \\" 
	noi di "    &   &   &  `ci68'  &  `ci69'  &  `ci70'  &  `ci71'  &  `ci72'  \\" 


}
log close

	

	
