%% uQL 
% 
% Calculates quasi-linear utility for earnings z when ability is n,
% elasticity is e, and potentially non-linear tax is in the structure tax. 

function u = uQL(z,n,e, tax)

    % Calculate consumption under nonlinaer tax rate
    c = z - (tax.t0.*z + (tax.t1-tax.t0).*(z-tax.zStar).*(z>tax.zStar));
    
    % Calculate utility
    u = c - (z./n).^(1+1/e) .* n./ (1+1/e);

end