%% calcGmmPooled
%
% calcualtes GMM objective function for pooled (89/90, 69/70) data

function obj = calcGmmPooledH(params, data)

    % calculate 89/90 objective value
    obj90 = calcGmmDynamic(params, data.data90);
    
    % calculate 69/70 objective value
    obj70 = calcGmmDynamic(params, data.data70);
    
    % return sum, weighting moments equally
    obj = length(data.data90.bunch).*obj90 + ...
          length(data.data70.bunch).*obj70;

end