
// Make earnings dist, for various aggregations 
local bw 800
local samples "s1SE s1Main s1Male s1HighE s1HighV1 s1HighV2 s1HighV3 s1HighV4"

// Earnings dist, years 1983-1999, aggregating 66-68 and 70-71 (separately)
qui foreach s of local samples {
	noi di "`s'"
	use "$datadir/rr2_`s'_`bw'" if inrange(age, 59, 73) & inrange(year, 1983, 1999), clear 
	gen rdR = realDistanceRound / 1e3
	
	keep if inrange(rdR, -10, 30)

	sort year age rdR
	forvalues age = 59/73 {
		forvalues year = 1983/1999 {
			local noy "nolabel"
			local nox "nolabel"
			
			if `year' >= 1995 local nox ""
			if `year' == 1983 | `year' == 1989 | `year' == 1995 local noy ""
		
			# delimit ;
			twoway
				(connected count rdR if year == `year' & age == `age'),
				xline(0, lcolor(gs8))
				xtitle("")
				ytitle("")
				xlabel(, `nox')
				ylabel(, `noy')
				legend(off)
				title("`year'", ring(0))
				graphregion(color(white))
				name(cfop`year', replace)
				nodraw
			;
			# delimit cr
			
		}
		
		# delimit ;
		graph combine 
			cfop1983 cfop1984 cfop1985 cfop1986 cfop1987 cfop1988
			cfop1989 cfop1990 cfop1991 cfop1992 cfop1993 cfop1994
			cfop1995 cfop1996 cfop1997 cfop1998 cfop1999,
			graphregion(color(white)) cols(6) ycommon
			l1title("Number in bin")
			b1title("Distance to kink (\$1000s)")
		;
		# delimit cr
		graph save "$figdir/densPoly_`age'_8399_`bw'_`s'", replace
	}		
}

