

/*
global directory bulk/state_eitc
global directory "C:\Users\Dan\Dropbox\Taxes_Adjustment_Costs\"
global datadir "C:\Users\Dan\Desktop\work\projects\stateEITCs\data"

global directory "C:\Users\dansacks\Dropbox\Taxes_Adjustment_Costs"
global datadir "C:\Users\dansacks\projects\Taxes_Adjustment_Costs\data"
global scriptdir "$directory\scripts\ssaScripts"
local assemble 0*/


// Settings for Pattison's run
clear all
set more off
version 11

local date = word("$S_DATE",3)+"_"+string(month(date("$S_DATE","DMY")))+"_"+word("$S_DATE",1)

cd d:
global directory "D:/UserData/Pattison/Gelber"

global scriptdir "$directory/current/scripts"
global datadir "$directory/data"
global cpidir "$datadir"

local nostop "nostop"
local assemble 1



// Directories for tables, figures, scripts
global figdir "$directory/current/results`date'/figures"
global tabdir "$directory/current/results`date'/tables"
global logdir "$directory/current/results`date'/logs"

capture mkdir "$directory/current"
capture mkdir "$directory/current/results`date'"
capture mkdir "$logdir"
capture mkdir "$figdir"
capture mkdir "$tabdir"


capture log close

set seed 922

clear mata
set memory 1200M

set more off

global bwList "500 800"

/* load bunching programs */ 
quietly{
	do $scriptdir/programs/BunchPlot.do
	do $scriptdir/programs/bunchCFOP.do
	do $scriptdir/programs/bunchShift.do
	do $scriptdir/programs/bunchPoly.do
	do $scriptdir/programs/bunchLeft.do
	
}

/* assemble the data */
    
	if `assemble' {
	
		if "$directory" == "bulk/state_eitc/" | strpos("$directory", "ropbox"){
			log using "$logdir/makeFakeData.log,replace"
			do "$scriptdir/assembleSSA_fake.do"
			log close
		}
		
		log using "$logdir/assembleSSA_CFOP.log", replace
		do "$scriptdir/assembleSSA_CFOP.do"
		log close
	}

/* get counts */
	foreach sample in s1Main s1Born16 s1Born13 s1Placebo s1SE s1Claim{
		# delimit ;
		use "$datadir/cfopSSA_`sample'_500" if 
			age>=20 & age<=80 & 
			realDistanceRound>=-1e4 & realDistanceRound<=3e4, 
			clear
		;
		# delimit cr

		local N = _N
		if `N' < 51 set obs 51

		foreach a1 in 20 40 50 60 62 65 66 70 71 72 76{
			qui gen c`a1' = .
		}

		local row = 0
		gen yearTable =.
		qui forvalues y=1955/2007{
			local ++row
			replace yearTable = `y' in `row'

			foreach a1 of numlist 20 40 50 60 62 65 66 70 71 72 76{

				if `a1' == 20 local a2 = 39
				if `a1' == 40 local a2 = 49
				if `a1' == 50 local a2 = 59
				if `a1' == 60 local a2 = 61
				if `a1' == 62 local a2 = 64
				if `a1' == 65 local a2 = 65
				if `a1' == 66 local a2 = 69
				if `a1' == 70 local a2 = 70
				if `a1' == 71 local a2 = 71
				if `a1' == 72 local a2 = 75
				if `a1' == 76 local a2 = 80

				sum count if age>=`a1' & age<=`a2' & year == `y'
				replace c`a1' = r(sum) in `row'
			}
		}

		keep if !missing(yearTable)
		outsheet yearTable c20-c76 using "$tabdir/count_`sample'.txt", replace comma
	}


/* Put all robustness results into a systematic table */
	capture log close
	log using "$logdir/robustnessTable.log", replace
	do "$scriptdir/robustnessTable.do", `nostop'
	log close
	
/* Look at kink-to-kink tranisitions */
	capture log close
	log using "$logdir/kinkToKink.log", replace
	do "$scriptdir/kinkToKinkTransitions.do", `nostop'
	log close
	

/* Bunching for structural analysis */
	global sampleList "s1Main"
	log using "$logdir/bunchStructural.log", replace
	do "$scriptdir/bunchStructural.do", `nostop'
	log close
		
/* run the main analysis, looping over samples   */
	foreach sample in s1Main s1SE s1Placebo s1Claim s1Born13 s1Born16 s1JanBorn {
		global sampleList "`sample'"
		log using "$logdir/etAnalysisSSA_`sample'.log", replace
		do "$scriptdir/etAnalysisSSA_Smooth.do", `nostop'
		log close
	}

/* Robustness: alternative kinks for 1996-2004 66-69 year olds, bw = 800 */
	global sampleList "s1Main"
	log using "$logdir/robustPost2000.log", replace
	do "$scriptdir/robustPost2000.do", `nostop'
	log close
 
/* Robustness: alternative excluded ranges, bw = 800 */
	global sampleList "s1Main"
	log using "$logdir/robustExclude.log", replace
	do "$scriptdir/robustExclude.do", `nostop'
	log close
   
/* Robustness: alternative degree of polynomial, bw = 800 */
	global sampleList "s1Main"
	log using "$logdir/robustDegree.log", replace
	do "$scriptdir/robustDegree.do", `nostop'
	log close
   
/* compute summary stats for the main sample */
	global sampleList "s1Main"
	log using "$logdir/summaryStats.log", replace
	do "$scriptdir/etSummaryStats.do", `nostop'
	log close

/* other summary stats: earnings dist, age claim dist */
	log using "$logdir/tobitClaim.log", replace
	do "$scriptdir/tobitAndClaim.do", `nostop'
	log close 

