
*mainStata

/*

	Replicate all Stata-SSA reults from Gelber, Jones and Sacks "Estimating 
	adjustment frictions"
	Specifically replicates
	- Figure 2
	- Figure 4
	- Figure 5
	- Figure B.1
	- Figure B.2
	- Table B.1
	- Table B.2 
*/



global directory "C:/Users/dansacks/Dropbox/Taxes_Adjustment_Costs/replicationPackage"
global datadir "$directory/data"
global scriptdir "$directory/bunchingCode"
global figdir "$directory/output/figures"
global tabdir "$directory/output/tables"

capture mkdir "$directory/output"
capture mkdir "$figdir"
capture mkdir "$tabdir"

global blue "50 80 100"
global red "255 128 128"



clear all
serset clear 

set more off

quietly do "$scriptdir/programs/bunchPoly.do" 


* Make Figure 2a and 2b
do "$scriptdir/bunchByAge"

* Make Figure 4a and 4b
do "$scriptdir/bunchByAge6972Long"

* Make Figure 8 and Table B5
do "$scriptdir/bunchDD"

* Make Figure B2
do "$scriptdir/bunchClaim"

* Make Tables B1 and B2
do "$scriptdir/robustnessTables"


