% Older Americans Would Work Longer If Jobs Were Flexible
% by Ameriks, Briggs, Caplin, Lee, Shapiro, and Tonetti
% This version: January 2019. 

% This code estimates the IES for each respondent using the SSQ responses
% as inputs. 

clear all
clc

% 1. Load data

load SSQ_responses
% Survey responses are saved in matrix named 'responses'
spoid = responses(:,1); % identifier
bridge_flag = responses(:,2); % dummy for whether had a bridge job
hours_fixed = responses(:,3); % number of hours in a fixed schedule scenario
w_ratio1A = responses(:,4);  % reservation wage ratio between fixed and flexible schedule, at the moment of survey
H_fraction1A = responses(:,5); % hours ratio between fixed and flexible schedule, at the moment of survey
w_ratio1B = responses(:,6); % reservation wage ratio between fixed and flexible schedule, at the moment of retirement
H_fraction1B = responses(:,7); % hours ratio between fixed and flexible schedule, at the moment of retirement
          

% 2. Set up auxiliary matrices and parameters

fix_h = [0, 0.04]'; % Considered fixed costs of work in terms of foregone leisure
fix_c = [0, 0.07, 0.11, 0.14]'; % Considered fixed costs of work in terms of expenditure (in % of full time earnings)
n_comb = length(fix_h)*length(fix_c); 
n_ind = size(responses,1); 

gamma1A = zeros(n_ind, n_comb); % Placeholder for estimate of gamma (IES in leisure) from the moment of survey
gamma1B = zeros(n_ind, n_comb); % Placeholder for estimate of gamma (IES in leisure) from the moment of retirement
IES1A = zeros(n_ind, n_comb);   % Placeholder for estimate of IES in labor supply from the moment of survey
IES1B = zeros(n_ind, n_comb);   % Placeholder for estimate of IES in labor supply from the moment of retirement
flag1A_r = zeros(n_ind, n_comb);% Placeholder for flags for abnormal responses from the moment of survey 
flag1B_r = zeros(n_ind, n_comb);% Placeholder for flags for abnormal responses from the moment of retirement  

% Flags (see the last two paragraphs in Section III B): 
 % 0: Estimate obtained
 % 1: No interior solution. Demand a high wage for working less hours, which cannot be
 % justified by the calibrated fixed cost of work.  
 % Imply a very high IES under a larger fixed cost of work 
 % 2: No interior solution. Wanting to work very little, which cannot be
 % justified by the calibrated fixed cost of work.  
 % Imply a very small IES under a smaller fixed cost of work
 % 3: Irrational response.  Demand more salary when working less. 
 % 4: Identical responses to fixed and flexible schedule scenarios 
 
theta_min1A = zeros(n_ind, n_comb); % Placeholder for minimum value of theta for direct transition to no work, from the moment of survey
theta_min1B = zeros(n_ind, n_comb); % Placeholder for minimum value of theta for direct transition to no work, from the moment of retirement

% 3. Estimation

for i_ind = 1:n_ind
   for i_h = 1:length(fix_h)
      for i_c = 1:length(fix_c)
          
         
          % Estimation of gamma and IES by colling 'labor_est' function
          
             [gamma1A(i_ind,i_c + (i_h-1)*length(fix_c)), IES1A(i_ind,i_c + (i_h-1)*length(fix_c)), flag1A_r(i_ind,i_c + (i_h-1)*length(fix_c))] = ...
                 labor_est(hours_fixed(i_ind),H_fraction1A(i_ind),w_ratio1A(i_ind),fix_h(i_h),fix_c(i_c)); 
          
          
             [gamma1B(i_ind,i_c + (i_h-1)*length(fix_c)), IES1B(i_ind,i_c + (i_h-1)*length(fix_c)), flag1B_r(i_ind,i_c + (i_h-1)*length(fix_c))] = ...
                 labor_est(hours_fixed(i_ind),H_fraction1B(i_ind),w_ratio1B(i_ind),fix_h(i_h),fix_c(i_c)); 
          
          
          % Calculate the minimum value of theta required to generate the
          % direct transition to no work, from the estimated IES. 
          if flag1A_r(i_ind,i_c + (i_h-1)*length(fix_c)) == 0 
             theta_min1A(i_ind,i_c + (i_h-1)*length(fix_c)) = ...
                 (1-fix_c(i_c))*hours_fixed(i_ind)*(1-1/gamma1A(i_ind,i_c + (i_h-1)*length(fix_c)))/...
               ((1-fix_h(i_h)-hours_fixed(i_ind))^(1/gamma1A(i_ind,i_c + (i_h-1)*length(fix_c)))*(1-(1-fix_h(i_h)-hours_fixed(i_ind))^(1-1/gamma1A(i_ind,i_c + (i_h-1)*length(fix_c)))))-1; 
          end      
          
          if flag1B_r(i_ind,i_c + (i_h-1)*length(fix_c)) == 0 
             theta_min1B(i_ind,i_c + (i_h-1)*length(fix_c)) = ...
                 (1-fix_c(i_c))*hours_fixed(i_ind)*(1-1/gamma1B(i_ind,i_c + (i_h-1)*length(fix_c)))/...
               ((1-fix_h(i_h)-hours_fixed(i_ind))^(1/gamma1B(i_ind,i_c + (i_h-1)*length(fix_c)))*(1-(1-fix_h(i_h)-hours_fixed(i_ind))^(1-1/gamma1B(i_ind,i_c + (i_h-1)*length(fix_c)))))-1; 
          end      
      end
   end   
end

estimates = [spoid, gamma1A, IES1A, theta_min1A, flag1A_r, gamma1B, IES1B, theta_min1B, flag1B_r]; 

save Labor_estimates estimates

xlswrite('estimates.xls', estimates)
