function [ plow, pstar, pbar, hat_a1, hat_b, plow_app, pstar_app, pbar_app, plow_sw, pstar_sw, pbar_sw, norm_f_val, N_adj] ...
    = fct_solve_optimal_policy_undiscounted_ppi(B,psi,sigma,ppi)
% [ plow, pstar, pbar, hat_a1, hat_b, plow_app, pstar_app, pbar_app, norm_f_val, N_adj] ...
%      = fc_solve_optimal_policy_undiscounted_ppi(B,psi,sigma,ppi)
%
% solve (undiscounted) optimal problem wiht given:
%%%% Inputs
% B: quadric loss
% psi: fixed cost
% sigma : innovation variance
% ppi : inflation rate ( 1 percent is written as ppi = 0.01)
%%%%  Output
% plow  : lower threshold
% pbar  : upper threshold
% pstar : optimal return point
% hat_a1 : constant for value function
% hat_b : constant for value function
% plow_app, pstar_app, pbar_app, linear approximations
% norm_f_val : variable that should be zero in the solution
% N_adj: expected number of adjustments. 
%%%
% This codes only works for moderate values of inflation ppi.

if log(2*ppi/sigma^2)>0
    N = min(100, round(300/log(2*ppi/sigma^2)) ) ; % order of the polynomial (aproximation to infinite power series) for value function
else
    N=100;
end

%%%%% Values for zero inflation:

pbar = ( 6 * psi/B * sigma^2 )^(1/4) ;
pstar = 0 ;

bar_a4 = - B/(6*sigma^2);
bar_p = ( (psi/B) * sigma^2 * 6 )^(1/4);
bar_a2 = - 2 * bar_a4 * bar_p^2;

%%%%% Values for first order approximation with non-zero inflation

hat_b  = 0;
% based on the fact that hat_b(0) = hat_b'(0)=0
hat_a1 = - B * 7/45 * (pbar/sigma)^4 * ppi;
% % based on hat_a1(0) = 0 and hat_a1'(0) = - B * 7/45 * (pbar/sigma)^4

hat_a1_prime = - B * pbar^4 /sigma^4 * 7/45;
dpbar_dpi    = 2/15 * (pbar/sigma)^2  ;
dpstar_dpi   = 21/90 * (pbar/sigma)^2 ;

pbar_app = pbar + dpbar_dpi * ppi ;
plow_app = -pbar + dpbar_dpi * ppi ;
pstar_app = pstar + dpstar_dpi * ppi ;
hata1_app =  - B * pbar^4 /sigma^4 * 7/45 * ppi ;
hatb_app  = 0;

% set guess
plow_pstar_pbar_hata1_hatb_LINEAR_APP = [plow_app  pstar_app  pbar_app hata1_app hatb_app ];

% initial conditions using SW:
psi_sw=psi ;
m = ( 3/4*psi_sw/B*ppi )^(1/3)  ;

%  find excessive HIGH markup threshold using SW;  Fernando's notes on r==0
alpha1=-(psi_sw*3/4)^(2/3)*(B/ppi)^(1/3);
alpha3= B/(3*ppi);
pbar_sw  = fzero(@(x) x*(alpha1 +alpha3*x^2)- m*(alpha1 +alpha3*m^2) - psi_sw , 2*m  ) ;
pstar_sw = m  ;
plow_sw  = -m ;
abar_2 = sqrt( 2*B*psi_sw /(3*sigma^2) ) ;
hata1_sw = alpha1 ;
hatb_sw  = -abar_2 ;

plow_pstar_pbar_hata1_hatb_SW = [plow_sw  pstar_sw  pbar_sw hata1_sw hatb_sw ];

weight_sw = ( exp(2*ppi/1000/sigma^2)-1)/ exp(2*ppi/1000/sigma^2);
plow_pstar_pbar_hata1_hatb =  (1-weight_sw)* plow_pstar_pbar_hata1_hatb_LINEAR_APP +  weight_sw * plow_pstar_pbar_hata1_hatb_SW ;

%vsolve for optimal thresholds
[x_sol_exact f_val_exact ] = fsolve(@(xx) fct_solve_policy(xx, B,sigma,psi,ppi,N) , plow_pstar_pbar_hata1_hatb,...
    optimoptions('fsolve','Tolfun',1e-12,'TolX',1e-12,'MaxFunEvals',5000,'MaxIter',3000,'FunValCheck','on','Display','off')) ;
plow    = x_sol_exact(1);
pstar   = x_sol_exact(2);% optimal markup
pbar    = x_sol_exact(3);
hat_a1  = x_sol_exact(4);
hat_b   = x_sol_exact(5);

thres_ext = [plow pbar];
sort_thres = sort(thres_ext);
plow = sort_thres(1) ;
pbar = sort_thres(2) ;

if  norm(f_val_exact)>1e-5   || plow> pstar || pstar>pbar
    
    if ppi <= 200*sigma^2 %
        
        plow_pstar_pbar_hata1_hatb = plow_pstar_pbar_hata1_hatb_LINEAR_APP ;
        
        [x_sol_exact f_val_exact ] = fsolve(@(xx) fct_solve_policy(xx, B,sigma,psi,ppi,N) , plow_pstar_pbar_hata1_hatb,...
        optimoptions('fsolve','Tolfun',1e-12,'TolX',1e-12,'MaxFunEvals',5000,'MaxIter',3000,'FunValCheck','on','Display','off')) ;
        plow    = x_sol_exact(1);
        pstar   = x_sol_exact(2);% optimal markup
        pbar    = x_sol_exact(3);
        hat_a1  = x_sol_exact(4);
        hat_b   = x_sol_exact(5);
        
        if norm(f_val_exact)>1e-5  || plow>pbar || plow> pstar || pstar>pbar
            done = 1;
        else
            done = 0;
           disp(['problem could not be solved at ppi=', num2str(ppi), 'psi = ',num2str(psi)])
        end
  
    else %  ppi > 200*sigma^2  %%% then use SW
        
        f_val_exact=0;
        plow   =plow_sw  ;
        pstar  =pstar_sw  ;
        hat_a1 = hata1_sw ;
        
        abar_2  = sqrt( 2*B*psi /(3*sigma^2) ) ;
        hat_b   =  -abar_2 ;
        pbar    =  pbar_sw;
                                
    end
       
end
norm_f_val = norm(f_val_exact) ;

% Compute frequency of price adjustment in this model
% formula use metric of normalized desired price so convert units
gbar = pstar-plow ;
glow = pstar-pbar ;
xi = -2*ppi/sigma^ 2; 
AA1 = -(gbar - glow )/ ( ppi* (exp(-xi*gbar) - exp(-xi*glow))  );
AA0 = -AA1*exp(-xi*gbar) - gbar/ppi ; 
N_adj = 1/( AA0 + AA1 ); 


if norm_f_val > 0.001
    disp( ' ')
    disp(' *********************************************************')
    disp( ' ')
    disp(' Some of the equations may have not been solved accurately')
    disp(' ')
    disp(' *********************************************************')
    disp(' ')
end 


