function [frac_q_w_3ormore_spell,distinct_indx_norm,Pr_dp,...
             PR_Ref_change,time_at_ref,time_below_ref,time_below_ref_max,...
             fract_of_Adjst_to_New_P,N_Dp_peryear,N_Dp_ref_peryear]...
          = fct_simulate_GL(dt,T,plow_GL,pstar_GL,pbar_GL,ppi,sigma) 

% simulates A  GL MODEL with inflation
      
%T    = 1000 ; % simulation length in years
time = 0    ; % calendar time

pstar   =  0  ; % initialize ideal price
pstar_i =  0;  % ideal price at the time of the last adjustment

p = pstar_i + pstar_GL ; % initial price level (at a)

j=0;

counter_Dp_sim=0;

while time < T
    j = j + 1;
    
   pstar  = pstar + sigma*randn(1)*sqrt(dt) + ppi*dt ;

%     pstar  = pstar + sign(rand-1/2)*sigma*sqrt(dt) + ppi*dt ;
    
    % compute g (normalized ideal price)
    pgap =  p - pstar ;    
    
    time = time + dt  ;
   
    if  pgap < plow_GL || pgap  > pbar_GL     % out of inaction region
        
        counter_Dp_sim = counter_Dp_sim + 1;
        
        p = pstar + pstar_GL ;
        
    end
    
    % Record  vars
    p_vec(j)  =  p ; % actual price
    pstar_vec(j) =  pstar; % ideal price
%    g_vec(j) = g ; % normalized ideal price
    T_vec(j) = time ;
    
    
end

% Construct index of New Prices: what fraction of price changes leads to a NEW price 

Tf = 1; % fraction of year to check whether a price is NEW

Tf_m = round(Tf/dt);   

for  i =Tf_m+2 : round(T/dt)-1

    if p_vec(i)==p_vec(i-1)
     P_change_indx(i) = 0;
    else
     P_change_indx(i)=1;
    end
    
    pvec_previous = p_vec(i-1-Tf_m:i-1); % vector of prices in previous Tf-time-window
    
    ind_comeback = max( pvec_previous - p_vec(i) == 0) ;
    
    if  ind_comeback ==1
     P_novel_indx(i) = 0 ;
    else
     P_novel_indx(i) = 1 ;
    end
    
end

fract_of_Adjst_to_New_P = mean(P_novel_indx)/mean(P_change_indx) ; 

% record stats per period of length Ts (e.g. 4 months)

Ts =  4/13 ; % length of Ts in years (approx 4 months, so we have eight 2-week period per quadrimester)
nmp_Ts =  round(Ts/dt);
for i = 1:round(length(p_vec)/nmp_Ts)-1
    
    p_vec_q         =  p_vec((i-1)*nmp_Ts+1 : i*nmp_Ts); % vec of price obs in the ``period''
    num_uniq_p_q(i) =  length(unique(p_vec_q));          % this counts the number of distinct prices
    
    [P_ref(i),Freq_i(i)]             =  mode(p_vec_q); % 
    [P_ref_max(i),Freq_max_i(i)]   =  mode(-p_vec_q); %  the minus sign is to pick the max in case of multiple modes
     P_ref_max(i)= -P_ref_max(i);
        
    time_at_ref_i(i)           =   Freq_i(i) / nmp_Ts     ;
    time_at_ref_max_i(i)       =   Freq_max_i(i) / nmp_Ts ;
    
    time_below_ref_i(i)             =   length(find(p_vec_q<P_ref(i))) / nmp_Ts ;
    time_below_ref_max_i(i)        =   length(find(p_vec_q<P_ref_max(i))) / nmp_Ts ;
    
    num_dp_i(i)    = sum(p_vec_q(2:end)-p_vec_q(1:end-1) ~= 0); % this measures the number of price changes
    num_dp_pos_i(i)= sum(p_vec_q(2:end)-p_vec_q(1:end-1) > 0);
    
    num_spell_q_i(i) = num_dp_i(i) + 1 ;          % this measure the number of price spells
    Pr_dp_i(i)     = num_dp_i(i) / nmp_Ts; % prob of price change per Ts period
    Pr_dp_pos_i(i) = num_dp_pos_i(i) / nmp_Ts;
  
end

time_at_ref  = mean(time_at_ref_i);
time_below_ref = mean(time_below_ref_i);

time_at_ref_max  = mean(time_at_ref_max_i);
time_below_ref_max = mean(time_below_ref_max_i);

Pr_dp = mean(Pr_dp_i);
Pr_dp_pos = mean(Pr_dp_pos_i);

N_Dp_peryear = counter_Dp_sim / T ;

count_Ref_change  = sum(P_ref(2:end)-P_ref(1:end-1) ~= 0); 
PR_Ref_change    = count_Ref_change/(length(P_ref)-1);

N_Dp_ref_peryear = count_Ref_change / T ;


count_Ref_change_pos  = sum(P_ref(2:end)-P_ref(1:end-1) > 0); 
PR_Ref_change_pos     = count_Ref_change_pos/(length(P_ref)-1);

% Compute distinct value index
% distinct_value_indx_q = num_uniq_p_q./num_spell_q ;

indx_3ormore_spells = find(num_spell_q_i>2);

% Compute fraction 4-month period with more than 3 or more   
frac_q_w_3ormore_spell = length(indx_3ormore_spells)/length(num_spell_q_i) ;

%  Compute the index of distinct values by conditioning over 4-month  periods with
%    at least three  price spells ; otherwise the index equals to 1 by construction
distinct_value_indx_q_cond    =   mean(num_uniq_p_q(indx_3ormore_spells)./num_spell_q_i(indx_3ormore_spells));

% Normalized to place ratio in (0,1)
distinct_indx_norm = mean( (num_uniq_p_q(indx_3ormore_spells)-2)./ (num_spell_q_i(indx_3ormore_spells)-2));

% discrete time probability of a step up
pr_up = 1/2*(1+ppi/sigma*sqrt(dt))  ;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
