%   Matlab distribution file for  Alvarez?Lippi 2019 AEJ Macro paper: 
% "Temporary Price Changes, Inflation Regimes and the Propagation of Monetary Shocks" for AEJ 
%  Code Computes reference prices and other steady state statistics for a sticky plan model with fixed cost
clear all
close all

% parameters
sigma  = 0.0075 ;%  ;
tic
% size of the time periods, in years
dt = 1/(52) ; % 1/52 = 1 week 

step =  sqrt(dt)*sigma;

% bar_g_vec = [2*step:step:(Niter+1)*step];
% the  one  below produces the Table in the paper
% use approx formula gbar = sigma / N * sqrt(1/dt)
  
bar_g_vec = [3*step  4*step  6*step  11*step  15*step  ] ; 

Niter = length(bar_g_vec) ; 

Ntot_sim_vec    = zeros(1,Niter);
Np_sim_vec      = zeros(1,Niter);
Np_vec          = zeros(1,Niter);
UB_Nw_vec       = zeros(1,Niter);
LB_Nw_vec       = zeros(1,Niter);


for iter=1:Niter  
    
    disp([' computing  iteration #  :  ',num2str(iter,2), '    of    ',num2str(Niter,2)]);
    
    bar_g = bar_g_vec(iter);
    
    
    % optimal thrshold for a change in price withing a plan
    tilde_g = 1/3 * bar_g ;
    
    % number of firms to simulate
    N_firms = 500 ;
    
    g0_vec =zeros(1,N_firms);
    
    Q = 2000; %  Number of quarters to simulate
    
    % number of years to simulate (as multiple of weeks in a quarter = 13 )
    TT =  13*Q*dt; % units: years
    
    % compute invariant distribution  of firms
    % using that for  -gbar<g<0  we have F(g) = (g+gbar)^2/(2 gbar^2)
    F_vec = linspace(1/2,1,N_firms/2) ;
    g0_vec(1,N_firms/2+1:end)= bar_g * ( 1 - sqrt( 2.* (1-F_vec)) ) ;
    g0_vec(1,1:N_firms/2) = -bar_g * ( 1 - sqrt( 2.* (1-F_vec)) ) ;
     
%%% plots initial distribution of g before the shock
  %   figure(1)
  %   hist(g0_vec,30)
%    
    % compute price gaps before the shock and right after the shock
    phat0 = tilde_g* sign(g0_vec) - g0_vec;
    
    prices_i=zeros(1,round(TT/dt));
    
    % reference cost -- not working well with the brownbian since the value is
    % changing continously!
    cost_i=zeros(1,round(TT/dt));
    gi_vec=zeros(1,round(TT/dt));
    
    time_at_ref_P_vec = zeros(1,Q*N_firms);
    
   %  index_ref = 1 ;
    index_dur = 1 ;
    index_dur_week = 1 ;
    
    
    for i=1: N_firms;
        
        Counter_change_of_Prices=0;
        Counter_change_of_plans=0;
        
        % duration (in weeks)
        Duration_Plan=0;
        Duration_Pweek=0;
        
        
        gi = g0_vec(i);
        
        % makes sure that g_i is a multiple of sqrt(dt) sigma
        gi = round(gi/(sqrt(dt)*sigma)) * sqrt(dt)*sigma;
        
        gi_vec(1)=gi;
        
        period=1; % counter model periods
        
        prices_i(period)= 0 ; % sign(gi)* tilde_g ;
        
        cost_i(period)=0;
        
        while period < round(TT/dt)+1
            
            if abs( abs(gi) -  bar_g ) /(sigma*sqrt(dt)) < 1/1000  % plan change (change if abs(g_i) = bar_g, allow for numerical error)
                   
                Counter_change_of_plans=Counter_change_of_plans+1;
                Counter_change_of_Prices= Counter_change_of_Prices+1;
                
                g_next=0;
            
                prices_i(period+1) = prices_i(period) +  sign_minus(gi)*bar_g - tilde_g ;
                
                Duration_Plan_vec(Counter_change_of_plans)   = Duration_Plan ;% duration in weeks
                Duration_Pweek_vec(Counter_change_of_Prices) = Duration_Pweek ;% duration in weeks
                
                Duration_Plan= 0  ;% duration in weeks
                Duration_Pweek=0  ;% duration in weeks
                
                
            else % plan did not change
                
                
                Duration_Plan=Duration_Plan + 1   ; % duration in weeks
                Duration_Pweek=Duration_Pweek + 1 ; % duration in weeks
                
                
                g_next          =  gi + sign_minus(randn)*sqrt(dt)*sigma;
                cost_i(period+1)  =  cost_i(period) +  ( g_next - gi )  ;
                
                if sign_minus(g_next)*sign_minus(gi)>0  %  keep the same price
                    
                    prices_i(period+1)= prices_i(period) ;
                    
                else %  change  price  within Plan
                    Counter_change_of_Prices= Counter_change_of_Prices+1;
                    prices_i(period+1)= prices_i(period) + 2*tilde_g*sign(g_next) ;
                    
                    Duration_Pweek_vec(Counter_change_of_Prices) = Duration_Pweek ;% duration in weeks
                    Duration_Pweek=0  ;% duration in weeks
                    
                end
                
            end% plan checking ..... if abs(gi) > bar_g
            
            gi_vec(period+1)=gi;
            gi = g_next;
            
            period=period+1;
            
        end %   while period < round(TT/dt)+1
        
        Counter_change_of_Ref_Prices=0;
        
        for q = 1:Q
            
            % recall: we model a quarter as 13 model-periods
            t_i   = (q-1)*13 + 1 ;
            t_ip1 = t_i + 12 ;
            
            [Mod_P,Freq_P] = mode(prices_i(t_i:t_ip1))  ;
                        
            Ref_P_vec(q) = Mod_P;
            time_at_Ref_P_vec(q) = Freq_P/13;
            
            % index_ref =index_ref + 1 ;
            
            % count changes of reference prices
            if q>1  &&  Mod_P ~= Ref_P_vec(q-1)
                Counter_change_of_Ref_Prices = Counter_change_of_Ref_Prices + 1;
            end
            
            
        end
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % compute duration of reference prices in QUARTERS
        Dur_Ref_P_Q = 1; % counting the quarters
        
        for ii=1:Q-1
            if  Ref_P_vec(ii+1)==Ref_P_vec(ii)
                Dur_Ref_P_Q = Dur_Ref_P_Q + 1;
            else
                Dur_Ref_P_Q_vec(index_dur) = Dur_Ref_P_Q ;
                index_dur=index_dur+1 ;
            end
        end
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%       
        Counter_change_of_Ref_Prices_vec(i) =  Counter_change_of_Ref_Prices;
        
        Counter_change_of_Prices_vec(i)     =  Counter_change_of_Prices;
        
        Counter_change_of_plans_vec(i)      =  Counter_change_of_plans;
        
    end % i firms
    
    %%%%%
    %%%%%
    %%% Relabel T to substract change of plans ( adjustments happen
    %%% instantaneously as the barrier is reached so you have to remove these periods to avoid double
    %%% counting)
    %%%
    T = TT -  mean(Counter_change_of_plans_vec)*dt ; 
    
    t_fig_years = 4; % # years to plot in time series figures
    t_figs= round(t_fig_years/dt) ; % in model periods
 
    figure(2)
    time_vec=[1:1:t_figs]*dt;
    plot(time_vec(1:t_figs),gi_vec(1:t_figs),'b')
    hline([-bar_g,0,bar_g])
    title('Time series of  normalized ideal price  g  for firm i','Fontsize',18 )
    
    figure(3)
    plot(time_vec(1:t_figs),prices_i(1:t_figs),'b')
    title('Time series of price P for firm i','Fontsize',18 )
    
    figure(4)
    [Count_P,P_bins]=hist(time_at_ref_P_vec,50);
    bar(P_bins,Count_P/length(time_at_ref_P_vec));
    title('Distribution: Fraction of weeks spent at the Reference price','Fontsize',18 )
    xlabel('Time spent at the Reference price (fraction)','Fontsize',18 )
    ylabel('Sample frequency  (fraction)','Fontsize',18 )
    
    figure(5)
    % prob of ref price change per quarter
    prob_ref_price_change_per_quarter = Counter_change_of_Ref_Prices_vec/(TT*4) ;
    Reference_price_duration_weeks = 13./prob_ref_price_change_per_quarter ;
    hist(Reference_price_duration_weeks,30)
    title('Distribution of Reference price duration (in weeks), follows EJR 2011','Fontsize',18)
    
   
     %  STATISTICS FOR THE PAPER
    disp( '   ') ;
    disp( ' ***********   ') ;
    
    
    disp( '   ') ;
    disp([' mean number of price changes per year  :  ',num2str(mean(Counter_change_of_Prices_vec)/T,2)]) ;
    disp( '   ') ;
    disp([' mean number of PLAN  changes per year  :  ',num2str(mean(Counter_change_of_plans_vec)/T,2)]) ;
    disp( '   ') ;
    disp([' mean number of REF price changes per year  :  ',num2str(mean(Counter_change_of_Ref_Prices_vec)/T,2)]) ;
    
%     disp( '   ') ;
%     disp(['Fraction of reference price changes /  total-price-changes     ',num2str( mean(Counter_change_of_Ref_Prices_vec)/ mean(Counter_change_of_Prices_vec),2)]) ;
      
    Np = sigma^2/bar_g^2;
    LB_Nw = 1/ (sqrt(dt/Np) + dt/2*( (1+sqrt(dt*Np))/(1-sqrt(dt*Np))) );
    UB_Nw = 2*sqrt(Np/dt) - Np/2;
    
    disp( '   ') ;
    disp(['CHECK:   theoretical number PLANS changes/year  :  ',num2str(Np,2)]) ;
    
    % probability of price change per week 
    prob_price_change_per_week_mean = mean(Counter_change_of_Prices_vec/(round(TT/dt)));
    disp( '   ') ;
    disp(['the (per week) probability of price change ',num2str(prob_price_change_per_week_mean,2)]) ;
    
    disp( '   ') ;
    prob_ref_price_change_per_quarter_mean = mean(prob_ref_price_change_per_quarter);
    disp(['the (per quarter) probability of reference price change is ',num2str(prob_ref_price_change_per_quarter_mean ,2)]) ;
    
    disp( '   ') ;
    disp(['Fraction of time spent at the reference price per quarter     ',num2str(mean(time_at_Ref_P_vec),2)]) ;
    
    
    Ntot_sim_vec(iter) = mean(Counter_change_of_Prices_vec)/T;
    
    Np_sim_vec(iter) = mean(Counter_change_of_plans_vec)/T ;
    
    Npref_sim_vec(iter) = mean(Counter_change_of_Ref_Prices_vec)/T ;

    Np_vec(iter) = Np;
    
    UB_Nw_vec(iter) = UB_Nw;
    
    LB_Nw_vec(iter) = LB_Nw ;
      
end

toc

