% Solves for cumulated output  in the plans problem with inflation 
% for a vector of inflation levels
% Flippi 2017, December 
clear all
close all

% param
ppi_vec   = linspace(0.001,0.35,100) ; % inflation

% remaining standard params
B    = 20; 
sigma= 0.125;
r    = 0.02;
psi  = 0.015; 

% initial conditions
gbar0 = (18*psi/B*sigma^ 2)^.25 ; 
gtilde = 1/3*gbar0 ;

%  guess {a,b}
a0  = - 1/3 * gbar0 ;
b0  =   1/3 * gbar0 ;

LB = -[gtilde  gtilde ]; UB = [gbar0 gbar0];

opt = optimset('Display','off');

 % Initial guess from model with ppi=0
 
   gbar0  = (18*psi/B*sigma^ 2)^.25 ; gbar=gbar0;
   glow0=-gbar0 ; glow=glow0;
   gtilde = 1/3*gbar0  ; a=-gtilde; b=gtilde; 
   ab_guess = [-gtilde  , gtilde ]; 
   
   gguess=[-gbar0 gbar0];
   
for i=1:length(ppi_vec)
    
    ppi = ppi_vec(i); 
    
    xi = -2*ppi/sigma^ 2; 

    disp(['computing inflation = ', num2str(ppi)]);

    [ab_sol,fval,exitflag] = fsolve(@(z) fct_sys_ab(z,ppi,B,r,sigma,psi),ab_guess,opt);
    if exitflag<1
        disp(['warning exit flag , check solution   for ppi== ',num2str(ppi,3) ]) ;
    end
    
    fval_vec(i,:)=fval;    
    eflag_vec(i)=exitflag;
    
    a=min(ab_sol);b=max(ab_sol);
    
    a_vec(i) = a;
    b_vec(i) = b;
    
    %%%%%% Now solve for VF and plot solution
    ghat = (a+b)/2;
    ghat_vec(i) = ghat;
    % vars
    eta1 = (-ppi - sqrt(ppi^2+2*r*sigma^2))/sigma^2 ;
    eta2 = (-ppi + sqrt(ppi^2+2*r*sigma^2))/sigma^2 ;
    
    % solve for glow, gbar given   (a,b)
    % -- amounts to solving a system of 2 equations (smooth pasting)
    [bounds_sol,fval,EXITFLAG,OUTPUT] = fsolve(@(x) fct_sys2(x,a,b,B,ppi,r,eta1,eta2,psi),gguess,opt);
    
    % Display solution for given {a,b}
    gbar = max(bounds_sol) ;
    glow = min(bounds_sol) ;
    
    gbar_vec(i)=gbar;
    glow_vec(i)=glow;
   
    %%%%   compute density of desired prices
    lambda = 2*ppi/(sigma^2) ;
    gs=0; gL=glow; gU=gbar;
    A = ( (gs - gL )*exp(lambda*gL) - (gU - gs )*( exp(lambda*gL) - exp(lambda*gs) ) / ( exp(lambda*gs) - exp(lambda*gU) ) *exp(lambda*gU) )^(-1) ;
    
    % Expected number of plan change
     AA1 = -(gbar-glow)/(ppi*(exp(-xi*gbar)-exp(-xi*glow) ));
     AA0=-AA1*exp(-xi*gbar)-gbar/ppi;
     Np(i) = 1/(AA1+AA0) ;
    
    %  Expected cumulated output (see notes)  A and B coeff (see notes)
    A_coef =  (  (ghat-gbar)*(b-1/xi) - (ghat-glow)*(a-1/xi) + (gbar^2 - glow^2)/2 + (a-b)/(xi*exp(xi*ghat))*(exp(xi*ghat)-exp(xi*gbar)) )...
        / ( ppi* (exp(xi*gbar)-exp(xi*glow))     )  ;
    B_coef = A_coef + (a-b) / (ppi*xi*exp(xi*ghat)) ;
    
    % Cumulated output formula after small shock delta>0
    Mp(i)  = -quad( @(z) f_density_p(z,xi,A,gL,gs,gU).*f_mhat_g(z,xi,a,b,ppi,A_coef,B_coef,glow,ghat,gbar),glow,gbar)  ;  
      
    ab_guess=[a b];
    gguess = [glow gbar] ;
    
end

% frequency   and cumulated output
figure(1)
plot(ppi_vec*100,Np,'bd','Linewidth',2) ;
title('Number of plan changes $N_p$','Fontsize',20,'Interpreter','Latex')
xl = xlabel('Inflation (in %)');
set(xl,'Fontsize',20,'Interpreter','Latex') ;
%  print -depsc fig_Np_vs_ppi
%  print -dpdf fig_Np_vs_ppi 

figure(2)
plot(ppi_vec*100,Mp,'bd','Linewidth',2) ;
title(' Cumulated output: $\mathcal{M}^\prime(0)$ ','Fontsize',20,'Interpreter','Latex')
xl = xlabel('Inflation \% cc');
set(xl,'Fontsize',20,'Interpreter','Latex') ;
 
figure(3)
plot(ppi_vec*100,Mp./Mp(1),'b-',ppi_vec*100,Np(1)./Np,'r--','Linewidth',2) ;
%title('  Cumulative output effect','Fontsize',20,'Interpreter','Latex')
xl = xlabel('Inflation (in \%)');
lh=legend('Cumulated output' , '1/Frequency of plan changes' ); set(lh,'Fontsize',16,'Interpreter','Latex') ;
set(xl,'Fontsize',20,'Interpreter','Latex') ;


print -depsc fig_M_vs_ppi
print -dpdf  fig_M_vs_ppi 
