*Learning Patterns for Selected Products

cd  "~/Dropbox/IntlMedDevMkts/MGanalysis"
use EUdata, clear

keep if age<=36
replace age=age-10 if product=="Costar"

* what happens to usage / quality estimates
twoway (line lnd age if product=="Promus", lcolor(grey) lwidth(thick)) ///
 	(line lnd age if product=="Costar", lcolor(grey) lpattern("-") lwidth(thick)) ///
	(line lnd age if product=="Apolo Bionert", lcolor(grey) lpattern("....-") lwidth(thick)) ///
 	, legend( order( 1 "US trials success" 2 "US trials failed" 3 "No US trials") rows(1) ) graphregion(color(white)) ///
	ytitle("Inclusive Share (Mean)") ///
	xtitle("Age Since Introduction to Region (Months)") xlabel(0(12)36)
graph export ../output/fig_MeanVsAge_SelectedProds.pdf, replace 


* and volatility first differences within product
sort product t
by product: gen lnd_diff = abs(lnd-lnd[_n+1])
drop if lnd_diff==.

twoway (line lnd_diff age if product=="Promus", lcolor(grey) lwidth(thick)) ///
 	(line lnd_diff age if product=="Costar", lcolor(grey) lpattern("-") lwidth(thick)) ///
	(line lnd_diff age if product=="Apolo Bionert", lcolor(grey) lpattern("....-") lwidth(thick)) ///
 	, legend( order( 1 "US trials success" 2 "US trials failed" 3 "No US trials") rows(1) ) graphregion(color(white)) ///
	ytitle("Inclusive Share Change Between Months") ///
	xtitle("Age Since Introduction to Region (Months)") xlabel(0(12)36)
graph export ../output/fig_MeanFirstDiffVsAge_SelectedProds.pdf, replace 
