function [sigmaQ2_inv,rho,QjFEall,age_u] = SigmaQ2_fcn( clinical, amc, Yin , age, XeT , check, aT , ageIV , USe_jt, USe, ...
    sigmaQ2_inv_start, sigmaEU2_inv, sigmaA2_inv, sigmaAc2_inv , gammaH , lambda , j , aFEversion );

if aFEversion==1
    X = [ ageIV(age<=aT,:) , XeT ];
    theta = (X'*X)\(X'*Yin(age<=aT,:)) ;
    rho=0;
    QjFE = theta(end-size(XeT,2)+1:end);
    age_u = ageIV*theta(1:size(ageIV,2)); % DEALING WITH UNCERTAINTY ADJUST FOR NOT IN US TRIALS?
    QjFEall = accumarray([j,ones(size(j,1),1)], Yin-age_u , [numel(unique(j)) 1], @sum) ./ ...
        accumarray([j,ones(size(j,1),1)], 1 , [numel(unique(j)) 1], @sum);
    QjFEall(check>0,:) = QjFE;
    %sigmaQ2_inv = [ 1./var(QjFEall(USe==2)) ; 1./var(QjFEall(USe==1)) ];
    sigmaQ2_inv = [ 1./var(QjFE(USe(check>0)==2)) ; 1./var(QjFE(USe(check>0)==1)) ];
else

%--------------------------------------------------------------------------
%--------------------------------------------------------------------------
% Find fixed point (sigmaQ2) consistent with data and other parameters
    %note this is anchor that deals with initial conditions and separately
    %identifying sigma and rho 
    %also key to include moments on sigma(xi|age) in criterion fcn to ID
    %sigmaEU and sigmaA
%--------------------------------------------------------------------------
diff = 10;
loopcounter = 0;
loopmax = 1000;
while diff>1e-3 && loopcounter<loopmax    
%--------------------------------------    
%aggregate uncertainty / learning
sigma2_jt = 1./( USe_jt*sigmaQ2_inv_start + sigmaEU2_inv + amc.*sigmaA2_inv + clinical.*sigmaAc2_inv );
w_signals_jt = w_signals_fcn(clinical,amc,sigmaEU2_inv,sigmaA2_inv,sigmaAc2_inv,gammaH) .* sigma2_jt;
%w_signals_jt = 1;
%--------------------------------------  
% aggregate mean utilities, including price and risk
Y = Yin-.5*(w_signals_jt.*sigma2_jt)./(1-lambda);
X = [ -.5*sigma2_jt(age<=aT,:) , XeT ];
%theta = (X'*X)\(X'*Y(age<=aT,:));
Zlin = [ ageIV(age<=aT,:) , XeT ];
X1stage = Zlin*((Zlin'*Zlin)\(Zlin'*X));
theta = (X1stage'*X1stage)\(X1stage'*Y(age<=aT,:)) ;
rho = theta(1);
QjFE = theta(end-size(XeT,2)+1:end);
age_u = -rho*.5*sigma2_jt;
QjFEall = accumarray([j,ones(size(j,1),1)], Y-age_u , [numel(unique(j)) 1], @sum) ./ ...
    accumarray([j,ones(size(j,1),1)], 1 , [numel(unique(j)) 1], @sum);
QjFEall(check>0,:) = QjFE;
%--------------------------------------
    % new sigmaQ2
    %sigmaQ2_inv = [ 1./var(QjFEall(USe==2)) ; 1./var(QjFEall(USe==1)) ];
    sigmaQ2_inv = [ 1./var(QjFE(USe(check>0)==2)) ; 1./var(QjFE(USe(check>0)==1)) ];
    % loop stats
    diff = max(abs(sigmaQ2_inv_start - sigmaQ2_inv));
    loopcounter = loopcounter + 1;
    sigmaQ2_inv_start = sigmaQ2_inv;
end   
end
end
