* ATE(Qj) vs. time

clear
set more off
cd  "~/Dropbox/IntlMedDevMkts/"

********************************************************************
* merge data sets

* product entry dates collapse and clean
use data/USdata_agg, clear
collapse enterUS, by(manufacturer product)
tempfile tempUS    
save "`tempUS'"  
use data/EUdata_agg, clear
sort manufacturer product t
merge m:1 manufacturer product using "`tempUS'"
*
preserve
collapse (count) Jt=p , by(t)
sort t
tempfile temp_Jt    
save "`temp_Jt'"  
restore
*
keep manufacturer product t j tj enterEU age USeventual enterUS
gen age_enterEU = age if t==enterEU
gen age_enterUS = age if t==enterUS
** plot entry rates over time
preserve
*collapse enterEU enterUS, by(manufacturer product)
fillin product t
gsort product -enterEU
by product: replace enterEU = enterEU[_n-1] if enterEU==.
gsort product -enterUS
by product: replace enterUS = enterUS[_n-1] if enterUS==.
gen EUentry = (t==enterEU)
gen USentry = (t==enterUS)
collapse (sum) EUentry USentry, by(t)
drop if t<=3
su
twoway (lfitci USentry t, lcolor(maroon) lwidth(thick) ciplot(rline) blcolor(cranberry) blpattern(-) blwidth(thin) )  ///
	(lfitci EUentry t, lcolor(navy) lpattern(-) lwidth(thick) ciplot(rline) blcolor(navy) blpattern(-) blwidth(thin) )  ///  
 	, legend( order( 2 "US" 4 "EU" ) rows(1) size(large)) graphregion(color(white)) ///
	xtitle("",size(large)) xtick(1(12)109) xlabel(1 "Jan 04" 25 "Jan 06" 49 "Jan 08" 73 "Jan 10" 97 "Jan 12",labsize(large)) ///
	ytitle("New Products Entering",size(large)) ylabel(,labsize(large)) 
graph export "output/fig_EntryRatesOverTime.pdf", replace 
collapse (sum) USentry EUentry
su
restore
* 
collapse (min) j enterEU enterUS USeventual age_enterEU age_enterUS, by(manufacturer product)
replace age_enterEU = 1 if age_enterEU==. & enterEU~=.
replace age_enterUS = 1 if age_enterUS==. & enterUS~=.
gen EUentryDate = dofm(mofd(date("January 01 2004","MDY")) + enterEU - age_enterEU)
gen USentryDate = dofm(mofd(date("January 01 2004","MDY")) + enterUS - age_enterUS)
format EUentryDate USentryDate %td
sort j
tempfile temp1    
save "`temp1'"      
*


********************************************************************
* Distribution of Qj

* merge Qj from demand estimates
insheet b j Qj Qj1 using "temp/Parameters_QjFE_0.csv", clear
drop b
rename qj Qj
rename qj1 Qj1
sort j
merge 1:m j using "`temp1'" , keep(match) nogen
*
foreach var in Qj Qj1 {
twoway (kdensity `var' if USeventual==1, lcolor(navy)) (kdensity `var' if USeventual==0, lcolor(navy) lpattern(-)) ///
 	, legend( order( 1 "Undergo US Trials" 2 "EU Trials Only" ) rows(1) size(large)) graphregion(color(white)) ///
	xtitle("Estimated `var'",size(large)) xlabel(-3.5(.5)-1,labsize(large)) ///
	ytitle(,size(large)) ylabel(,labsize(large)) 
graph export "output/fig_`var'_distribution.pdf", replace 
*
replace `var' = 4744*log(1+exp(`var'))
}
*
set obs 110
replace Qj1 = 0 in 110
twoway (lfitci Qj Qj1, lcolor(navy) ciplot(rline) blcolor(navy) blpattern(-) )  /// 
	(scatter Qj Qj1, mcolor(navy) msymbol(Oh)) ///
	(line Qj1 Qj1, sort lcolor(grey) ) ///
 	, legend(off) graphregion(color(white)) ///
	xtitle("Estimated ATE(Qj1) ($)",size(large)) xtick(0(200)1200) xlabel(0(200)1200,labsize(large)) ///
	ytitle("Estimated ATE(Qj) ($)",size(large)) ytick(0(200)1200) ylabel(0(200)1200,labsize(large)) 
graph export "output/fig_Qj_Qj1.pdf", replace 

********************************************************************
* Evolution of Qj over time

*--------------------
keep enterEU Qj Qj1 j product manufacturer USeventual
keep if enterEU>3
rename enterEU t
* merge Jt
sort t
merge m:1 t using "`temp_Jt'", keep(match) nogen
gen tolabel=(t==12 | t== 31 | t==55 | t==76 | t==98)
gen yplace = 30
gen labelJt = string(Jt)
replace labelJt = "N Products:" if t==12

*
foreach var in Qj Qj1 {
*
*
su `var' if t<=24
su `var' if t>=90
*
su `var'
gen ln`var' = log(1+abs(r(min))+`var')
reg ln`var' t
*
twoway (lfitci `var' t, lcolor(navy) ciplot(rline) blcolor(navy) blpattern(-) )  /// 
	(scatter `var' t if USeventual==1, mcolor(navy)) (scatter `var' t if USeventual==0, mcolor(navy) msymbol(Oh)) ///
	(scatter yplace t if tolabel==1, mlabel(labelJt) mlabcolor(navy) mlabsize(large) mlabp(0) ms(none)) ///
 	, legend( order( 3 "Undergo US Trials" 4 "EU Trials Only" ) rows(1) size(large)) graphregion(color(white)) ///
	xtitle("",size(large)) xtick(1(12)109) xlabel(1 "Jan 04" 25 "Jan 06" 49 "Jan 08" 73 "Jan 10" 97 "Jan 12",labsize(large)) ///
	ytitle("Estimated ATE(`var') ($)",size(large)) ytick(0(200)1000) ylabel(0(200)1000,labsize(large)) 
graph export "output/fig_TechChangeEstimates_`var'.pdf", replace 
}

