* Import counterfactual results and make figures


cd  "~/Dropbox/IntlMedDevMkts/"

******************************************************************************************
* Optimal Tc
******************************************************************************************

*local pre2004="_noDES"
*local pre2004="_noStents"
*foreach State in "Cfcl" "Cfcl_noDES" "Cfcl_noStents" {
foreach State in "Cfcl" {
foreach US in "0" "1" {

*% Exporting for figures in stata
*Cfcl_Optimal=[TcTSub;TcTSlb;TcCSub;TcCSlb;TS_optimal_UB;TS_optimal_LB;CS_optimal_UB;CS_optimal_LB]
*Cfcl_Tc=[Risk_priors_UB';Risk_priors_LB';Risk_mean_UB;Risk_mean_LB;PctStent_UB;PctStent_LB;CS_UB;CS_LB;avgP_UB;avgP_LB;PS_UB;PS_LB;NewProducts_UB;NewProducts_LB;FC_UB;FC_LB;TSa_UB;TSa_LB];
*Cfcl =[Tc_vector-1;Cfcl;deltaTSa_UB;deltaTSa_LB;deltaCS_UB;deltaCS_LB;deltaPS_UB;deltaPS_LB]';
*Cfcl = [ bootstrap*ones(size(Cfcl,1),1) , Cfcl , repmat(Cfcl_Optimal(:,end)',size(Cfcl,1),1) ];
*filename = strcat('../temp/Cfcl_nop/Cfcl','_param',paramstr,'_mod', modstr,'_b',bs_str,'_dc', discntstr, '_us', usflagstr,'_mc',mcstr,'_siga2',sigstr,'_sigac',sigacstr,'.csv');
*csvwrite(filename,Cfcl)

insheet b Tc riskpriorUS_ub riskpriorNot_ub riskpriorUS_lb riskpriorNot_lb riskmean_ub riskmean_lb ///
	pctstent_ub pctstent_lb cs_ub cs_lb avgp_ub avgp_lb ps_ub ps_lb np_ub np_lb fc_ub fc_lb ts_ub ts_lb ///
	dTS_ub dTS_lb dCS_ub dCS_lb dPS_ub dPS_lb tc_ub tc_lb tc_cs_ub tc_cs_lb ///
	TS_optimal_UB TS_optimal_LB CS_optimal_UB CS_optimal_LB ///
	using temp/Cfcl_nop/v3/Cfcl_param7_mod4_b0_dc1_us`US'_mc1_siga21_sigac1.csv , clear
*gen Tc = [_n]-1
rename tc Tc
replace fc_ub=fc_ub/1e6
replace fc_lb=fc_lb/1e6
replace ps_ub=ps_ub/1e6
replace ps_lb=ps_lb/1e6
replace dts_lb=0 if dts_lb<0
replace dcs_lb=0 if dcs_lb<0
*save temp, replace
/*
insheet ts_ub_p95 ts_lb_m95 tc_ub_p95 tc_lb_m95 using plots_TScflc_LBUB_se.csv, clear
gen Tc = [_n]-1
merge 1:1 Tc using temp
*/
*keep if Tc<=36
/*
gen tc_ub_p95 = tc_ub+1.96*tc_ub_se
gen tc_lb_m95 = tc_lb-1.96*tc_lb_se
gen ts_ub_p95 = ts_ub+1.96*ts_ub_se
gen ts_lb_p95 = ts_lb+1.96*ts_lb_se
*/

su np_ub np_lb

*-----
*find optimal Tc for each Case
egen ts_lb_max=max(dts_lb)
egen ts_ub_max=max(dts_ub)
gen ts_lb_case=Tc if ts_lb_max==dts_lb
gen ts_ub_case=Tc if ts_ub_max==dts_ub
egen cs_lb_max=max(dcs_lb)
egen cs_ub_max=max(dcs_ub)
gen cs_lb_case=Tc if cs_lb_max==dcs_lb
gen cs_ub_case=Tc if cs_ub_max==dcs_ub

*-----
*find Bounds on Tc
*egen ts_lb_max=max(dts_lb)
gen ts_Tc_bounds = ts_lb_max if Tc==tc_ub
replace ts_Tc_bounds = 0 if Tc==tc_lb
gen zero=0
*egen cs_lb_max=max(dcs_lb)
gen cs_Tc_bounds = cs_lb_max if Tc==tc_cs_ub
replace cs_Tc_bounds = 0 if Tc==tc_cs_lb

*-----
*for Case plots
egen ts_lb_c = max(ts_lb_case)
replace ts_lb_max = 0 if dts_lb<ts_lb_max
egen ts_ub_c = max(ts_ub_case)
replace ts_ub_max = 0 if dts_ub<ts_ub_max
egen cs_lb_c = max(cs_lb_case)
replace cs_lb_max = 0 if dcs_lb<cs_lb_max
egen cs_ub_c = max(cs_ub_case)
replace cs_ub_max = 0 if dcs_ub<cs_ub_max

*-----
*plot -- Cases versions

twoway (scatter np_ub Tc, mcolor(maroon) msymbol(circle_hollow) )  ///
	(scatter np_lb Tc, mcolor(maroon) msymbol(triangle_hollow) )  ///
 	, legend( pos(1) ring(0) col(1) order(1 "M case" 2 "L case") ) /// 
	graphregion(color(white)) ///
	ytitle("New Products Entering (count)",size(medlarge)) ///
	xtitle("Time in Clinical Trials (Months beyond EU required)",size(medlarge)) ///
	xlabel(0(6)30 ,labsize(medlarge)) xtick(0(3)30) 
graph export output/`State'_US`US'_Jenter.pdf, replace 

twoway (scatter ps_ub Tc, mcolor(maroon) msymbol(circle_hollow) )  ///
	(scatter ps_lb Tc, mcolor(maroon) msymbol(triangle_hollow) )  ///
 	, legend( pos(1) ring(0) col(1) order(1 "M case" 2 "L case") ) /// 
	graphregion(color(white)) ///
	ytitle("Producer Surplus w/o FC ({c $|}M)",size(medlarge)) ///
	xtitle("Time in Clinical Trials (Months beyond EU required)",size(medlarge)) ///
	xlabel(0(6)30 ,labsize(medlarge)) xtick(0(3)30) 
graph export output/`State'_US`US'_PS.pdf, replace 

twoway (scatter fc_ub Tc, mcolor(maroon) msymbol(circle_hollow) )  ///
	(scatter fc_lb Tc, mcolor(maroon) msymbol(triangle_hollow) )  ///
 	, legend( pos(1) ring(0) col(1) order(1 "M case" 2 "L case") ) /// 
	graphregion(color(white)) ///
	ytitle("Fixed Costs of Trials ({c $|}M)",size(medlarge)) ///
	xtitle("Time in Clinical Trials (Months beyond EU required)",size(medlarge)) ///
	xlabel(0(6)30 ,labsize(medlarge)) xtick(0(3)30) 
graph export output/`State'_US`US'_FC.pdf, replace 
*/
*legend(order(3 "UB on TS: No direct trial costs" 4 "LB on TS: Trial costs {c $|}1.6M/mo; Naive entry") rows(2) size(medlarge))

twoway (scatter dts_ub Tc, mcolor(maroon) msymbol(circle_hollow) )  ///
	(scatter dts_lb Tc if dts_lb>0, mcolor(maroon) msymbol(triangle_hollow) )  ///
	(line ts_lb_max ts_lb_c, lcolor(navy) lwidth(thick)) ///
	(line ts_ub_max ts_ub_c, lcolor(navy) lwidth(thick)) ///
 	, legend( pos(1) ring(0) col(1) order(1 "M case" 2 "L case") ) /// 
	graphregion(color(white)) ///
	ytitle("Total Surplus (% change)",size(medlarge)) ///
	ylabel(0(2)8 ,labsize(medlarge)) ytick(0(1)8) ///
	xtitle("Time in Clinical Trials (Months beyond EU required)",size(medlarge)) ///
	xlabel(0(6)30 ,labsize(medlarge)) xtick(0(3)30) 
graph export output/`State'_US`US'_TS.pdf, replace 

twoway (scatter dcs_ub Tc, mcolor(maroon) msymbol(circle_hollow) )  ///
	(scatter dcs_lb Tc if dcs_lb>0, mcolor(maroon) msymbol(triangle_hollow) )  ///
	(line cs_ub_max cs_ub_c, lcolor(navy) lwidth(thick)) ///
	(line cs_lb_max cs_lb_c, lcolor(navy) lwidth(thick)) ///
 	, legend( pos(1) ring(0) col(1) order(1 "M case" 2 "L case") ) /// 
	graphregion(color(white)) ///
	ytitle("Consumer Surplus (% change)",size(medlarge)) ///
	ylabel(0(2)8 ,labsize(medlarge)) ytick(0(1)8) ///
	xtitle("Time in Clinical Trials (Months beyond EU required)",size(medlarge)) ///
	xlabel(0(6)30 ,labsize(medlarge)) xtick(0(3)30) 
graph export output/`State'_US`US'_CS.pdf, replace 
}
}
