* Import counterfactual results and make figures


cd  "~/Dropbox/IntlMedDevMkts/"

******************************************************************************************
* Optimal Tc with Observational Learning
******************************************************************************************

*local pre2004="_noDES"
*local pre2004="_noStents"


*% Exporting for figures in stata
*Cfcl_Optimal=[TcUB_TS;TcLB_TS;TcUB_CS;TcLB_CS;TS_optimal_UB;TS_optimal_LB;CS_optimal_UB;CS_optimal_LB];
*Cfcl_Optimal = [ bootstrap , modifier , Cfcl_Optimal' ]
*filename = strcat('../temp/Cfcl_Optimal','_m',int2str(modifier),'_b',int2str(bootstrap),'.csv');
*csvwrite(filename,Cfcl_Optimal)
*Cfcl_Optimal_only2 = [bootstrap, CS_optimal_UB, CS_optimal_LB, TcCSub, TcCSlb, TS_optimal_UB, TS_optimal_LB,TcTSub, TcTSlb ];
*filename = strcat('../output/MGtest/Cfcl_Optimal','_param',paramstr,'_mod', modstr,'_b',bs_str,'_dc', discntstr, '_us', usflagstr,'_mc',mcstr,'_siga2',sigstr,'_sigac',sigacstr,'.csv');
*csvwrite(filename,Cfcl_Optimal_only2)

insheet b dcs_ub dcs_lb tc_cs_ub tc_cs_lb dts_ub dts_lb tc_ts_ub tc_ts_lb cs_ub cs_lb ts_ub ts_lb ///
	using temp/Cfcl_nop/v3/Cfcl_Optimal_param7_mod4_b0_dc1_us0_mc1_siga21_sigac1.csv , clear
	keep b tc_cs_ub tc_cs_lb tc_ts_ub tc_ts_lb cs_ub cs_lb ts_ub ts_lb
	foreach var in ts_ub ts_lb cs_ub cs_lb {
		replace tc_`var' = tc_`var' - 1
		}
	gen modifier=1-1
	save temp/Cfcl_nop/Cfcl_ObsLearn_b0, replace
		foreach var in ts_ub ts_lb cs_ub cs_lb {
		rename `var' `var'0
		}
		keep b ts_ub0 ts_lb0 cs_ub0 cs_lb0
		save temp/Cfcl_nop/Cfcl_ObsLearn_m0_b0, replace
forvalues i = 2/11 { 
	insheet b dcs_ub dcs_lb tc_cs_ub tc_cs_lb dts_ub dts_lb tc_ts_ub tc_ts_lb cs_ub cs_lb ts_ub ts_lb ///
	using temp/Cfcl_nop/v3/Cfcl_Optimal_param7_mod4_b0_dc1_us0_mc1_siga2`i'_sigac1.csv , clear
	keep b tc_cs_ub tc_cs_lb tc_ts_ub tc_ts_lb cs_ub cs_lb ts_ub ts_lb
	foreach var in ts_ub ts_lb cs_ub cs_lb {
		replace tc_`var' = tc_`var' - 1
		}
	gen modifier = `i'-1
	append using temp/Cfcl_nop/Cfcl_ObsLearn_b0
	save temp/Cfcl_nop/Cfcl_ObsLearn_b0, replace
}

replace modifier = modifier/10

merge m:1 b using temp/Cfcl_nop/Cfcl_ObsLearn_m0_b0
foreach var in ts cs {
		gen d`var'_lb = (`var'_lb - `var'_lb0)/`var'_lb0 * 100
		*gen d`var'_ub = (`var'_ub - `var'_lb0)/`var'_lb0 * 100
		gen d`var'_ub = (`var'_ub - `var'_ub0)/`var'_ub0 * 100
}



*-----
*plot

foreach meas in ts cs {

twoway (scatter tc_`meas'_ub modifier if tc_`meas'_ub<30, mcolor(navy) msymbol(circle_hollow) )  ///
	(scatter tc_`meas'_lb modifier, mcolor(navy) msymbol(triangle_hollow) )  ///
	(line tc_`meas'_ub modifier if tc_`meas'_ub<30, lcolor(navy) )  ///
	(line tc_`meas'_lb modifier, lcolor(navy) )  ///
 	, legend( pos(12) ring(0) col(1) order(1 "M case" 2 "L case") ) /// 
	graphregion(color(white)) ///
	ytitle("Optimal Months in Clinical (beyond EU required)",size(medlarge)) ///
	xtitle("Learning Rate Post-Market (Ratio vs. Clinical)",size(medlarge)) ///
	xlabel(0(.1)1 ,labsize(medlarge)) xtick(0(.1)1) 
graph export "output/ObsLearn_Tc_`meas'.pdf", replace 

twoway (scatter d`meas'_ub modifier, mcolor(maroon) msymbol(circle_hollow) )  ///
	(scatter d`meas'_lb modifier, mcolor(maroon) msymbol(triangle_hollow) )  ///
	(line d`meas'_ub modifier, lcolor(maroon) )  ///
 	(line d`meas'_lb modifier, lcolor(maroon) )  ///
	, legend( pos(12) ring(0) col(1) order(1 "M case" 2 "L case") ) /// 
	graphregion(color(white)) ///
	ytitle("TS vs. Pre-Market only policy (% change)",size(medlarge)) ///
	xtitle("Learning Rate Post-Market (Ratio vs. Clinical)",size(medlarge)) ///
	xlabel(0(.1)1 ,labsize(medlarge)) xtick(0(.1)1) 
graph export "output/ObsLearn_SurplusGain_`meas'.pdf", replace 

}
