* Figures on Age vs. Usage patterns

clear
set more off
cd  "~/Dropbox/IntlMedDevMkts/"
*capture log close
*log using output/Figures_3and4and5.smcl, replace

********************************************************************
* basics with raw data---EU and US
clear
use data/EUdata_agg
append using data/USdata_agg
gen US=(USeventual==.)
keep if age<=24
replace USeventual=1 if US==1
gen lnd = log(sj/s0)

*bysort US product: egen aj_max = max(age)
*drop if aj_max<12

quietly tab age, gen(aFE)

********************************************************************
* raw data plots


********************************************************************
* use within-product variation
bysort US USeventual: egen group_m = mean(lnd)
bysort US prod: egen lnd_m = mean(lnd)
gen lnd_within = lnd-lnd_m+group_m

bysort age US USeventual: egen d_within_mean = mean(lnd_within)
bysort age US USeventual: egen d_within_sd = sd(lnd_within)
bysort age US USeventual: egen d_within_p25 = pctile(lnd_within), p(25)
bysort age US USeventual: egen d_within_p50 = pctile(lnd_within), p(50)
bysort age US USeventual: egen d_within_p75 = pctile(lnd_within), p(75)

* EU vs US, same products, within

twoway (line d_within_mean age if US==0 & USeventual==1, lcolor(navy) lpattern("_.") lwidth(thick)) ///
	(line d_within_p25 age if US==0 & USeventual==1) ///
	(line d_within_p50 age if US==0 & USeventual==1) ///
	(line d_within_p75 age if US==0 & USeventual==1) ///
	, legend( order( 1 "mean" 2 "p25" 3 "p50" 4 "p75") rows(1) size(large)) graphregion(color(white))  ///
	ytitle("ln(s{sub:j}/s{sub:0})", size(large)) ylabel(-5.5(.5)-3,labsize(large)) ///
	xtitle("Age Since Introduction to Region (Months)",size(large)) xlabel(0(12)24,labsize(large))
graph export output/fig_AgeVsMoments_EUtrials.pdf, replace 

twoway (line d_within_mean age if US==0 & USeventual==0, lcolor(navy) lpattern(".....-") lwidth(thick)) ///
	(line d_within_p25 age if US==0 & USeventual==0) ///
	(line d_within_p50 age if US==0 & USeventual==0) ///
	(line d_within_p75 age if US==0 & USeventual==0) ///
	, legend( order( 1 "mean" 2 "p25" 3 "p50" 4 "p75") rows(1) size(large)) graphregion(color(white))  ///
	ytitle("ln(s{sub:j}/s{sub:0})", size(large)) ylabel(-8(.5)-6,labsize(large)) ///
	xtitle("Age Since Introduction to Region (Months)",size(large)) xlabel(0(12)24,labsize(large))
graph export output/fig_AgeVsMoments_EUnot.pdf, replace 





* regressions for table below
*skew
gen skew = ( d_within_mean - d_within_p50 ) / d_within_sd
reg skew aFE1-aFE23 if US==0 & USeventual==1, noconstant cluster(t)
lincom aFE23-aFE1
reg skew aFE1-aFE23 if US==0 & USeventual==0, noconstant cluster(t)
lincom aFE23-aFE1
* pctIQR
gen pctIQR = ( d_within_p75 - d_within_p50 ) / ( d_within_p75 - d_within_p25 )
reg pctIQR aFE1-aFE23 if US==0 & USeventual==1, noconstant cluster(t)
lincom aFE23-aFE1
reg pctIQR aFE1-aFE23 if US==0 & USeventual==0, noconstant cluster(t)
lincom aFE23-aFE1




********************************************************************
* Appendix example figures
*use EUdata, clear
keep if age==1 | age==12
keep if US==0 & USeventual==1
* depict symmetric learning shift
gen lnd_sym_post = lnd + 4.54/2*(.8-.1)
twoway (kdensity lnd if age==1, lcolor(navy) lpattern(".....-") lwidth(thick)) ///
	(kdensity lnd if age==12, lcolor(cranberry)  lwidth(thick)) ///
 	, legend( order( 1 "Pre-learning" 2 "Post-learning" ) rows(1) size(large)) graphregion(color(white)) ///
	ytitle("Density",size(large)) ///
	xtitle("ln(sj/s0) in EU",size(large)) xlabel(-10(2)0,labsize(large))
graph export output/fig_AIintuition_Sym.pdf, replace 
* depict Asymmetric learning shift
gen lnd_asym_post = lnd if lnd>-6
twoway (kdensity lnd if age==1, lcolor(navy) lpattern(".....-") lwidth(thick)) ///
	(kdensity lnd if lnd>-6 & age==1, lcolor(cranberry)  lwidth(thick)) ///
 	, legend( order( 1 "Pre-learning" 2 "Post-learning" ) rows(1) size(large)) graphregion(color(white)) ///
	ytitle("Density",size(large)) ///
	xtitle("ln(sj/s0) in EU",size(large)) xlabel(-10(2)0,labsize(large))
graph export output/fig_AIintuition_Asym.pdf, replace 




********************************************************************

log close
