* Figures 3 and 4 and 5 --- PV stents versions 

clear
set more off
cd  "~/Dropbox/IntlMedDevMkts/MGanalysis/Balloons"
capture log close
log using Figures_3and4and5_Balloons.smcl, replace

********************************************************************
* clean up data
use balloons, clear

egen t=group(yyyy mm)
replace manufacturer="Abbott Vascular" if manufacturer=="Guidant"
egen j=group(manufacturer product)

bysort manufacturer product US: egen enter=min(t)
replace enter=. if enter<=3 //stuff already in market plus potential sampling variation

********************************************************************
* table 1
preserve
collapse enter, by(j US t)
gen ones=1 
bysort t US: egen Jt=total(ones)
bysort US: su Jt
collapse enter, by(j US)
gen ones=1 
bysort US: egen J=total(ones)
bysort US: su J
drop ones J
reshape wide enter, i(j) j(US)
gen lag = enter1-enter0
su lag, detail
keep j lag
save lags, replace
restore, preserve
collapse enter, by(manufacturer US t)
gen ones=1 
bysort t US: egen Mt=total(ones)
bysort US: su Mt
collapse enter, by(manufacturer US)
gen ones=1 
bysort US: egen M=total(ones)
bysort US: su M
restore
merge m:1 j using lags
********************************************************************

gen Mht=diagnostic*2
bysort US t: egen Qht=total(q)
gen s0=1-Qht/Mht
su s0, detail
drop if s0<=0
gen sj=q/Q
gen lnd=ln(sj/s0)

*------
gen age=t-enter
su age, detail
local wiggle=2
drop if age<=`wiggle' | age==. //may undercount qjt if enter in middle of quarter
replace age=age-`wiggle'
su lag, detail
keep if lag<=6 | lag==.
*------

gen enterUS=enter if US==1
gen enterEU=enter if US==0
su enter enterUS enterEU US
gsort product -enterUS
by product: replace enterUS=enterUS[_n-1] if enterUS==.
gsort product -enterEU
by product: replace enterEU=enterEU[_n-1] if enterEU==.
* variable that denotes who enters US
gen USeventual = 0
replace USeventual = 1 if enterUS~=.

********************************************************************
* basics with raw data---EU and US

keep if age<=24
replace USeventual=1 if US==1

* and first differences within product
sort US product t
by US product: gen lnd_diff = abs(lnd-lnd[_n+1])
drop if lnd_diff==. // average over products of same age

egen a=group(age)
quietly tab a, gen(aFE)
su a, detail
local A `r(max)'
forvalues i = 1/`A' { 
	gen aEU_FE`i'=aFE`i'*(1-US) 
	}
forvalues i = 1/`A' { 
	gen aEUtrials_FE`i'=aFE`i'*(1-US)*USeventual 
	}	
********************************************************************
* raw data plots

bysort age US: egen d_mean = mean(lnd)
bysort age US: egen d_sd = sd(lnd)
bysort age US: egen d_diff_mean = mean(lnd_diff)

su lnd, detail
local lnd_u=ceil(`r(p75)')
local lnd_l=floor(`r(p25)')
su d_sd, detail
local sd_u=ceil(`r(p75)')
su lnd_diff, detail
local diff_u=ceil(`r(p25)')

* EU vs US, all products, raw

twoway (scatter d_mean age if US==0, mcolor(bluishgray8) msymbol("o")) ///
	(fpfitci lnd age if US==0, lcolor(navy) lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blwidth(thin)) ///
 	(scatter d_mean age if US==1, mcolor(erose) msymbol("o")) ///
	(fpfitci lnd age if US==1, lcolor(maroon) lpattern("-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(cranberry) blpattern("-") blwidth(thin)) ///
 	, legend( order( 3 "EU" 6 "US" ) rows(1) ) graphregion(color(white)) ///
	ytitle("Inclusive Share") ylabel(`lnd_l'(.5)`lnd_u') ///
	xtitle("Age Since Introduction to Region (Months)") xlabel(0(12)24)
graph export ~/Dropbox/IntlMedDevMkts/Paper/fig_MeanVsAge_EU_US_balloons.eps, replace 

twoway (scatter d_sd age if US==0, mcolor(bluishgray8) msymbol("o")) ///
	(fpfitci d_sd age if US==0, lcolor(navy) lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blwidth(thin)) ///
 	(scatter d_sd age if US==1, mcolor(erose) msymbol("o")) ///
	(fpfitci d_sd age if US==1, lcolor(maroon) lpattern("-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(cranberry) blpattern("-") blwidth(thin)) ///
 	, legend( order( 3 "EU" 6 "US" ) rows(1) ) graphregion(color(white)) ///
	ytitle("Inclusive Share: StDev Across Products") ylabel(0(.2)`sd_u') ///
	xtitle("Age Since Introduction to Region (Months)") xlabel(0(12)24)
graph export ~/Dropbox/IntlMedDevMkts/Paper/fig_StDevVsAge_EU_US_balloons.eps, replace 

twoway (scatter d_diff_mean age if US==0, mcolor(bluishgray8) msymbol("o")) ///
	(fpfitci lnd_diff age if US==0, lcolor(navy) lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blwidth(thin)) ///
 	(scatter d_diff_mean age if US==1, mcolor(erose) msymbol("o")) ///
	(fpfitci lnd_diff age if US==1, lcolor(maroon) lpattern("-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(cranberry) blpattern("-") blwidth(thin)) ///
 	, legend( order( 3 "EU" 6 "US" ) rows(1) ) graphregion(color(white)) ///
	ytitle("Inclusive Share Change Between Months") ylabel(0(.2)`diff_u') ///
	xtitle("Age Since Introduction to Region (Months)") xlabel(0(12)24)
graph export ~/Dropbox/IntlMedDevMkts/Paper/fig_MeanFirstDiffVsAge_EU_US_balloons.eps, replace 
*
* regressions for table below
*mean
reg lnd aFE1-aFE`A' if US==0, noconstant cluster(t)
lincom aFE`A'-aFE1
reg lnd aFE1-aFE`A' if US==1, noconstant cluster(t)
lincom aFE`A'-aFE1
reg lnd aFE1-aFE`A' aEU_FE1-aEU_FE`A', noconstant cluster(t)
lincom aEU_FE`A'-aEU_FE1
*sd
reg d_sd aFE1-aFE`A' if US==0, noconstant cluster(t)
lincom aFE`A'-aFE1
reg d_sd aFE1-aFE`A' if US==1, noconstant cluster(t)
lincom aFE`A'-aFE1
reg d_sd aFE1-aFE`A' aEU_FE1-aEU_FE`A', noconstant cluster(t)
lincom aEU_FE`A'-aEU_FE1
*diff
reg lnd_diff aFE1-aFE`A' if US==0, noconstant cluster(t)
lincom aFE`A'-aFE1
reg lnd_diff aFE1-aFE`A' if US==1, noconstant cluster(t)
lincom aFE`A'-aFE1
reg lnd_diff aFE1-aFE`A' aEU_FE1-aEU_FE`A', noconstant cluster(t)
lincom aEU_FE`A'-aEU_FE1
*

********************************************************************
* use within-product variation
bysort US USeventual: egen group_m = mean(lnd)
bysort US prod: egen lnd_m = mean(lnd)
gen lnd_within = lnd-lnd_m+group_m

bysort age US USeventual: egen d_within_mean = mean(lnd_within)
bysort age US USeventual: egen d_within_sd = sd(lnd_within)
bysort age US USeventual: egen d_diff_within_mean = mean(lnd_diff)

su d_within_mean, detail
local lnd_u=ceil(`r(p75)')
local lnd_l=floor(`r(p25)')
su d_within_sd, detail
local sd_u=ceil(`r(p75)')
su lnd_diff, detail
local diff_u=ceil(`r(p25)')

* EU vs US, same products, within

twoway (scatter d_within_mean age if US==0 & USeventual==1, mcolor(bluishgray8) msymbol("oh")) ///
	(fpfitci lnd_within age if US==0 & USeventual==1, lcolor(navy) lpattern("_.") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern("_.") blwidth(thin)) ///
 	(scatter d_within_mean age if US==1, mcolor(erose) msymbol("o")) ///
	(fpfitci lnd_within age if US==1, lcolor(maroon) lpattern("-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(cranberry) blpattern("-") blwidth(thin)) ///
 	, legend( order( 3 "EU (enter US)" 6 "US" ) rows(1) ) graphregion(color(white)) ///
	ytitle("Inclusive Share (Within)") ylabel(`lnd_l'(.5)`lnd_u') ///
	xtitle("Age Since Introduction to Region (Months)") xlabel(0(12)24)
graph export ~/Dropbox/IntlMedDevMkts/Paper/fig_MeanVsAge_EU_US_within_balloons.eps, replace 

twoway (scatter d_within_sd age if US==0 & USeventual==1, mcolor(bluishgray8) msymbol("oh")) ///
	(fpfitci d_within_sd age if US==0 & USeventual==1, lcolor(navy) lpattern("_.") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern("_.") blwidth(thin)) ///
 	(scatter d_within_sd age if US==1, mcolor(erose) msymbol("o")) ///
	(fpfitci d_within_sd age if US==1, lcolor(maroon) lpattern("-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(cranberry) blpattern("-") blwidth(thin)) ///
 	, legend( order( 3 "EU (enter US)" 6 "US" ) rows(1) ) graphregion(color(white)) ///
	ytitle("Inclusive Share: StDev Across Products (Within)") ylabel(0(.2)`sd_u') ///
	xtitle("Age Since Introduction to Region (Months)") xlabel(0(12)24)
graph export ~/Dropbox/IntlMedDevMkts/Paper/fig_StDevVsAge_EU_US_within_balloons.eps, replace 

twoway (scatter d_diff_within_mean age if US==0 & USeventual==1, mcolor(bluishgray8) msymbol("oh")) ///
	(fpfitci lnd_diff age if US==0 & USeventual==1, lcolor(navy) lpattern("_.") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern("_.") blwidth(thin)) ///
 	(scatter d_diff_within_mean age if US==1, mcolor(erose) msymbol("o")) ///
	(fpfitci lnd_diff age if US==1, lcolor(maroon) lpattern("-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(cranberry) blpattern("-") blwidth(thin)) ///
 	, legend( order( 3 "EU (enter US)" 6 "US" ) rows(1) ) graphregion(color(white)) ///
	ytitle("Inclusive Share Change Between Months (Within)") ylabel(0(.2)`diff_u') ///
	xtitle("Age Since Introduction to Region (Months)") xlabel(0(12)24)
graph export ~/Dropbox/IntlMedDevMkts/Paper/fig_MeanFirstDiffVsAge_EU_US_within_balloons.eps, replace 
*
* regressions for table below
*mean
reg lnd_within aFE1-aFE`A' if US==0 & USeventual==1, noconstant cluster(t)
lincom aFE`A'-aFE1
reg lnd_within aFE1-aFE`A' if US==1, noconstant cluster(t)
lincom aFE`A'-aFE1
reg lnd_within aFE1-aFE`A' aEUtrials_FE1-aEUtrials_FE`A' if USeventual==1, noconstant cluster(t)
lincom aEUtrials_FE`A'-aEUtrials_FE1
*sd
reg d_within_sd aFE1-aFE`A' if US==0 & USeventual==1, noconstant cluster(t)
lincom aFE`A'-aFE1
reg d_within_sd aFE1-aFE`A' if US==1, noconstant cluster(t)
lincom aFE`A'-aFE1
reg d_within_sd aFE1-aFE`A' aEUtrials_FE1-aEUtrials_FE`A' if USeventual==1, noconstant cluster(t)
lincom aEUtrials_FE`A'-aEUtrials_FE1
*diff
reg lnd_diff aFE1-aFE`A' if US==0 & USeventual==1, noconstant cluster(t)
lincom aFE`A'-aFE1
reg lnd_diff aFE1-aFE`A' if US==1, noconstant cluster(t)
lincom aFE`A'-aFE1
reg lnd_diff aFE1-aFE`A' aEUtrials_FE1-aEUtrials_FE`A' if USeventual==1, noconstant cluster(t)
lincom aEUtrials_FE`A'-aEUtrials_FE1
*
* EU: Trials vs Not, within
keep if US==0

su d_within_mean, detail
local lnd_u=ceil(`r(p99)')
local lnd_l=floor(`r(p1)')
su d_within_sd, detail
local sd_u=ceil(`r(p99)')
su lnd_diff, detail
local diff_u=ceil(`r(p99)')

twoway (scatter d_within_mean age if US==0 & USeventual==1, mcolor(bluishgray8) msymbol("oh")) ///
	(fpfitci lnd_within age if US==0 & USeventual==1, lcolor(navy) lpattern("_.") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern("_.") blwidth(thin)) ///
 	(scatter d_within_mean age if US==0 & USeventual==0, mcolor(bluishgray8) msymbol("th")) ///
	(fpfitci lnd_within age if US==0 & USeventual==0, lcolor(navy) lpattern(".....-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern(".....-") blwidth(thin)) ///
 	, legend( order( 3 "EU (enter US)" 6 "EU (don't enter US)" ) rows(1) ) graphregion(color(white)) ///
	ytitle("Inclusive Share (Within)") ylabel(`lnd_l'(.5)`lnd_u') ///
	xtitle("Age Since Introduction to Region (Months)") xlabel(0(12)24)
graph export ~/Dropbox/IntlMedDevMkts/Paper/fig_MeanVsAge_EUtrials_EUnot_within_balloons.eps, replace 

twoway (scatter d_within_sd age if US==0 & USeventual==1, mcolor(bluishgray8) msymbol("oh")) ///
	(fpfitci d_within_sd age if US==0 & USeventual==1, lcolor(navy) lpattern("_.") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern("_.") blwidth(thin)) ///
 	(scatter d_within_sd age if US==0 & USeventual==0, mcolor(bluishgray8) msymbol("th")) ///
	(fpfitci d_within_sd age if US==0 & USeventual==0, lcolor(navy) lpattern(".....-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern(".....-") blwidth(thin)) ///
 	, legend( order( 3 "EU (enter US)" 6 "EU (don't enter US)" ) rows(1) ) graphregion(color(white)) ///
	ytitle("Inclusive Share: StDev Across Products (Within)") ylabel(0(.2)`sd_u') ///
	xtitle("Age Since Introduction to Region (Months)") xlabel(0(12)24)
graph export ~/Dropbox/IntlMedDevMkts/Paper/fig_StDevVsAge_EUtrials_EUnot_within_balloons.eps, replace 

twoway (scatter d_diff_within_mean age if US==0 & USeventual==1, mcolor(bluishgray8) msymbol("oh")) ///
	(fpfitci lnd_diff age if US==0 & USeventual==1, lcolor(navy) lpattern("_.") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern("_.") blwidth(thin)) ///
 	(scatter d_diff_within_mean age if US==0 & USeventual==0, mcolor(bluishgray8) msymbol("th")) ///
	(fpfitci lnd_diff age if US==0 & USeventual==0, lcolor(navy) lpattern(".....-") lwidth(thick) ciplot(rline) estopts(cluster(t)) blcolor(midblue) blpattern(".....-") blwidth(thin)) ///
 	, legend( order( 3 "EU (enter US)" 6 "EU (don't enter US)" ) rows(1) ) graphregion(color(white)) ///
	ytitle("Inclusive Share Change Between Months (Within)") ylabel(0(.2)`diff_u') ///
	xtitle("Age Since Introduction to Region (Months)") xlabel(0(12)24)
graph export ~/Dropbox/IntlMedDevMkts/Paper/fig_MeanFirstDiffVsAge_EUtrials_EUnot_within_balloons.eps, replace
*
* regressions for table below
*mean
reg lnd_within aFE1-aFE`A' if US==0 & USeventual==1, noconstant cluster(t)
lincom aFE`A'-aFE1
reg lnd_within aFE1-aFE`A' if US==0 & USeventual==0, noconstant cluster(t)
lincom aFE`A'-aFE1
reg lnd_within aFE1-aFE`A' aEUtrials_FE1-aEUtrials_FE`A' if US==0, noconstant cluster(t)
lincom aEUtrials_FE`A'-aEUtrials_FE1
*sd
reg d_within_sd aFE1-aFE`A' if US==0 & USeventual==1, noconstant cluster(t)
lincom aFE`A'-aFE1
reg d_within_sd aFE1-aFE`A' if US==0 & USeventual==0, noconstant cluster(t)
lincom aFE`A'-aFE1
reg d_within_sd aFE1-aFE`A' aEUtrials_FE1-aEUtrials_FE`A' if US==0, noconstant cluster(t)
lincom aEUtrials_FE`A'-aEUtrials_FE1
*diff
reg lnd_diff aFE1-aFE`A' if US==0 & USeventual==1, noconstant cluster(t)
lincom aFE`A'-aFE1
reg lnd_diff aFE1-aFE`A' if US==0 & USeventual==0, noconstant cluster(t)
lincom aFE`A'-aFE1
reg lnd_diff aFE1-aFE`A' aEUtrials_FE1-aEUtrials_FE`A' if US==0, noconstant cluster(t)
lincom aEUtrials_FE`A'-aEUtrials_FE1
*

log close
