
bartlett.correction.mixt.interacttreat.func     <- function(fss, Xall, treatnomiss, nG, nF, nFpos, nX, pos, totmean, mean, cov, prob, parametric){



# Define p 
p             <- table(treatnomiss)[1]/sum(table(treatnomiss)) 

# Means of latent factors 
mean_f         <- list() 
for (g in 1:nG)   mean_f[[g]]    <- as.numeric(totmean[pos,g])

# Var-covariance of latent factors 
cov_f          <- list()
if (parametric==1){
  dcov        <- list()
  for (g in 1:nG) dcov[[g]]    <- list(cov[[g]][1:nF, ], cov[[g]][(nF+1):(nF*2),]) 
  
  
  for (g in 1:nG) {
    cov_f[[g]]     <- matrix(0, nFpos, nFpos)
    for (i in 1:nFpos){
      for (j in 1:nFpos){
        cov_f[[g]][i,j]  <- prob[[g]][1] * (dcov[[g]][[1]][pos[i],pos[j]]) + prob[[g]][2] * (dcov[[g]][[2]][pos[i],pos[j]] ) + 
          ( (prob[[g]][1] * mean[[g]][1,pos[i]] * mean[[g]][1,pos[j]]  + prob[[g]][2] * mean[[g]][2,pos[i]] * mean[[g]][2,pos[j]])  - 
              (prob[[g]][1] * mean[[g]][1,pos[i]]  + prob[[g]][2] * mean[[g]][2,pos[i]]) * (prob[[g]][1] * mean[[g]][1,pos[j]]  + 
                                                                                              prob[[g]][2] * mean[[g]][2,pos[j]])) 
      }
    }
  } 
}else if (parametric==0){
  for (g in 1:nG) cov_f[[g]]   <- cov[[g]][pos, pos] 
}


# Var-covariance of factor scores 
cov_fss          <- list()
for (g in 1:nG)  cov_fss[[g]]     <- cov(fss[[g]])


# Means of X's
mean_X          <- list()
for (g in 1:nG) {
  if (ncol(Xall)==1) {
    mean_X[[g]]      <- mean(Xall[which(treatnomiss==g), ])
  } else if (ncol(Xall)>1){
     mean_X[[g]]      <- colMeans(Xall[which(treatnomiss==g), ])
  } 
} 

# Covariance of X's
cov_X           <- list()
for (g in 1:nG) {
  if (ncol(Xall)==1) {
    cov_X[[g]]       <- var(Xall[which(treatnomiss==g), ])
  } else if (ncol(Xall)>1){
    cov_X[[g]]       <- cov(Xall[which(treatnomiss==g), ])
  } 
}

# Covariance between factors and X's 
cov_fx          <- list()
for (g in 1:nG) cov_fx[[g]]      <- cov(cbind(fss[[g]], Xall[which(treatnomiss==g), ]))[1:nFpos, (nFpos+1):(nFpos+nX)]
cov_xf          <- list()
for (g in 1:nG) cov_xf[[g]]      <- t(cov_fx[[g]])

# Covariance of prediction error 
cov_pe          <- list()
for (g in 1:nG)   cov_pe[[g]]      <- cov_fss[[g]] - cov_f[[g]]


# With several groups, computer the weighted average of the appropriate matrices 
allcov_f       <- p * cov_f[[1]] +  (1-p) * cov_f[[2]] + p * (1-p) * (mean_f[[2]] - mean_f[[1]]) %*% t(mean_f[[2]] - mean_f[[1]])
allcov_X       <- p*cov_X[[1]] + (1-p) * cov_X[[2]] + p * (1-p) * (mean_X[[2]] - mean_X[[1]]) %*% t(mean_X[[2]] - mean_X[[1]])
allcov_fx      <- p * cov_fx[[1]] + (1 - p) * cov_fx[[2]] + p * (1 - p) * (mean_f[[2]]- mean_f[[1]])%*% t(mean_X[[2]] - mean_X[[1]])
allcov_pe      <- p * cov_pe[[1]] + (1 - p) * cov_pe[[2]]
allcov_xf      <- t(allcov_fx)

# Correction matrix 
A1   <- rbind(cbind(allcov_f + allcov_pe, matrix(0, nrow(allcov_f + allcov_pe), ncol(allcov_f + allcov_pe)), allcov_fx), 
              cbind(matrix(0, nrow(allcov_f + allcov_pe), ncol(allcov_f + allcov_pe)), cov_f[[2]] + cov_pe[[2]],  cov_fx[[2]]), 
                    cbind(allcov_xf, cov_xf[[2]], allcov_X))
A2   <- rbind(cbind(allcov_f , matrix(0, nrow(allcov_f ), ncol(allcov_f)), allcov_fx), 
              cbind(matrix(0, nrow(allcov_f ), ncol(allcov_f)), cov_f[[2]],  cov_fx[[2]]), 
              cbind(allcov_xf, cov_xf[[2]], allcov_X))
A    <- solve(A1) %*% A2

  

return(A)
} 


