###################################################################
# Name              : CobbDouglas_OLS_MC.R
# 
# Description       : This program estimates of simpler Cobb Douglas production 
#                     functions for cognitive and socio-emotional 
#                     skills (full specification) for MC exercise 
###################################################################

nS =1 

###################################################################
# Define function to estimate production function by OLS
###################################################################
pf.ols.estim.func             <- function(scores, data, eps, mean, cov, missing, parametric){
  
  # Load data
  setwd(dir_data)     
  measures <- read.csv(data, header=T)
  measures <- measures[order(measures$treat), ]
  n        <- nrow(measures)
  
  # Get estimates of measurement system Ineed for estimation of correction bias 
  totmean    <- cbind(rep(0, nF), mean)

  # Define observables 
  Zall         <- cbind(measures$meanprice_juglibros_log, measures$FUmeanprice_log, measures$tpobc_pop1993)
  X1           <- cbind(measures$ln_nkids0) 
  Xnames       <- c( "kids")
  
  mscoresall   <- rbind(scores[[1]], scores[[2]])
  keep         <- which(complete.cases(cbind(Zall,X1, mscoresall)))
  keep1        <- which(complete.cases(cbind(Zall,X1, mscoresall)[which(measures$treat==1),]))
  keep2        <- which(complete.cases(cbind(Zall,X1, mscoresall)[which(measures$treat==2),]))
  treatnomiss  <- measures$treat[keep]
  
  if (missing=="FALSE"){
    fs   <- list()
    fs[[1]] <- scores[[1]][keep1,]
    fs[[2]] <- scores[[2]][keep2,]
  } else if (missing=="TRUE"){
    fs   <- scores
  }
  
  pos           <- c(2:5)
  
  # Reduced form with all 
  X           <- X1[keep,]
  
  RHSnames    <- c("treat", "cog0",  "mat", "time", "cogmo")
  
  pf.ols   <-  pf.ols.func.MC(fs, X, Xnames, treatnomiss, RHSnames, pos, totmean, mean, cov, prob, parametric)

  return(pf.ols)
} 

###################################################################
# Estimate production function on simulated samples  
# using function above 
###################################################################

nof <- length(noflagFS)
setwd(dir_outputFM)
load("fs_bstrap.R")
      
# Define output 
pf_bstrap <- array(0, dim=c(6, 1, nof))
pfbias_bstrap <- array(0, dim=c(6, 1, nof))
    
# Estimate function on each bstrap sample
for (b in 1:nof){
  out_bstrap   <- pf.ols.estim.func(fs_bstrap_allBFGS[[noflagFS[b]]], paste("measures_b", noflagFS[b], ".csv", sep=""), 
                                            epsBoot[,noflag[b]],
                                            meanBoot[,,noflagFS[b]], 
                                            list(covBoot[,,noflagFS[b],1],covBoot[,,noflagFS[b],2]),
                                            missing="FALSE", parametric)
  print(b)
  pf_bstrap[,,b]        <- out_bstrap[[1]]
  pfbias_bstrap[,,b]    <- out_bstrap[[2]]
}

##############################################################################
# Create table of estimates (point estimate followed by bootstrapped 
# standard errors, 95% ci, p-value one tail test and p-value two tailed test)
############################################################################## 
outb        <- list(pf_bstrap, pfbias_bstrap) 

outtable        <- list()
for (s in 1:2) {
  npar                 <- 6
  outtable[[s]]        <- matrix(0, npar*5, nS)
  
  for (i in 1:npar){
    for (j in 1:nS){

      mean             <- mean(outb[[s]][i,j,])
      se               <- sd(outb[[s]][i,j,])
      t_stat           <- mean/se
      t_crit           <- (outb[[s]][i,j,] - mean)/se
      p_val            <- 1 - ecdf(t_crit)(t_stat)
      p_val2           <- 1 - ecdf(t_crit^2)(t_stat^2)
      
      outtable[[s]][(i*5-4), j]  <- round(mean,3)
      outtable[[s]][(i*5-3),j]   <- round(se,3) 
      outtable[[s]][(i*5-2), j]  <- paste("[", round(quantile(outb[[s]][i,j,], .025),3), ",", 
                                            round(quantile(outb[[s]][i,j,], .975),3), "]", sep="") 
      outtable[[s]][(i*5-1), j]  <- p_val 
      outtable[[s]][i*5, j]      <- p_val2 
    } 
  } 
} 

# Name output rows and columns 
pfnames   <- c("Intercept", "", "", "", "", 
               "Treatment dummy", "", "", "", "", 
               "Baseline cognition","", "", "", "", 
               "Material investment", "", "","", "", 
               "Time investment", "", "","", "", 
               "Mother's cognitive skills", "", "", "",""
               ) 

for (s in 1:2){
  rownames(outtable[[s]]) <- pfnames  
  colnames(outtable[[s]]) <- c("Cognitive skills") 
}


# Save output 
setwd(dir_outputPF)
save(pf_bstrap, pfbias_bstrap, outb, outtable, file=paste("OUTPUT_OLS", ".R", sep=""))
write.csv(cbind(outtable[[1]]), file=paste("PF_OLS",  ".csv", sep=""))
write.csv(cbind(outtable[[2]]), file=paste("PFBIAS_OLS",  ".csv", sep=""))

