###################################################################
# Name              : CobbDouglas_IV_parsinv_fullyinteracted.R
# 
# Description       : This program estimates the structural 
#                     parameters of the Cobb Douglas production 
#                     functions for cognitive and socio-emotional 
#                     skills with only mat investment in the cognitive 
#                     production function and only time investment 
#                     in the socio-emotional production function and 
#                     where all the variables are interacted with the 
#                     treatment dummy 
###################################################################




###################################################################
# Estimate starting values 
###################################################################
# Estimate starting values for PF (from OLS)
if (nameFirstStage==c("FirstStageForIVInteracted_toyprice_foodprice")){
start1      <- lm(cog1 ~ cbind(treat,  cog0, cog0_T, ncog0,ncog0_T,cogmo,cogmo_T, ncogmo,ncogmo_T, kids, kids_T, mat, mat_T), data=regdata_true)$coef
start2      <- lm(ncog1 ~ cbind(treat, cog0, cog0_T, ncog0,ncog0_T,cogmo,cogmo_T, ncogmo,ncogmo_T, kids, kids_T, time, time_T), data=regdata_true)$coef
start       <- cbind(start1, start2)
ninvest      <- 2
} 

###################################################################
# Re-arrange first stage and reduced form to fit within estimating function 
###################################################################

rdform_new                                <- matrix(0, nrow(rdform_true), 2)
rdform_new[c(1,2,3,5,7,9),]               <- rdform_true[c(1,2,3,4,5,6), ]
rdform_new[c(4,6,8,10),]                  <- rdform_true[c(7,8,9,10), ]
rdform_new[c(11:nrow(rdform_true)),]      <- rdform_true[c(11:nrow(rdform_true)), ]

rdform_new_bstrap                         <- array(0, dim=c(nrow(rdform_true), 2, allbsample))
rdform_new_bstrap[c(1,2,3,5,7,9),,]       <- rdform_bstrap[c(1,2,3,4,5,6),, ]
rdform_new_bstrap[c(4,6,8,10),,]          <- rdform_bstrap[c(7,8,9,10),, ]
rdform_new_bstrap[c(11:nrow(rdform_true)),,] <- rdform_bstrap[c(11:nrow(rdform_true)),, ]


cogrdf_var_new                            <- matrix(0, nrow(cogrdf_var), ncol(cogrdf_var))
cogrdf_var_new[1:6,1:6]                   <- ncogrdf_var[1:6,1:6 ]
cogrdf_var_new[7,7]                       <- cogrdf_var[11,11 ]
cogrdf_var_new[8:12,8:12]                 <- cogrdf_var[c(7:10,12), c(7:10,12)]
cogrdf_var_new[13:14,13:14]               <- cogrdf_var[c(13,15),c(13,15) ]
cogrdf_var_new[15:16,15:16]               <- cogrdf_var[c(14,16), c(14,16)]

ncogrdf_var_new                           <- matrix(0, nrow(cogrdf_var), ncol(cogrdf_var))
ncogrdf_var_new[1:6,1:6]                  <- ncogrdf_var[1:6, 1:6]
ncogrdf_var_new[7,7]                      <- ncogrdf_var[11,11 ]
ncogrdf_var_new[8:12,8:12]                <- ncogrdf_var[c(7:10,12),c(7:10,12) ]
ncogrdf_var_new[13:14,13:14]              <- ncogrdf_var[c(13,15),c(13,15) ]
ncogrdf_var_new[15:16,15:16]              <- ncogrdf_var[c(14,16), c(14,16)]


###################################################################
# Estimate production functions on true data 
###################################################################
iv_true         <- md.fullyinteract.1inv.flexfunc(invest_true, rdform_new, cogrdf_var_new, ncogrdf_var_new, start, posExoFS, posInvFS, posExoRF, posInvRF, 
                               weighting="TRUE")



###################################################################
# Estimate production functions on bootstrapped samples 
###################################################################
iv_bstrap             <- array(0, dim=c(dim(iv_true), nof))

for (b in 1:nof){  
  
  iv_bstrap[,,b]         <- md.fullyinteract.1inv.flexfunc(invest_bstrap[,,b], rdform_new_bstrap[,,b], 
                                        cogrdf_var_new, ncogrdf_var_new, 
                                        start, posExoFS, posInvFS, posExoRF, posInvRF, weighting=TRUE)
  print(b)
} 



##############################################################################
# F-stat of interactions with treatment 
############################################################################## 

indicator        <- function(condition) ifelse(condition,1,0)
ftest.func     <- function(tt, invest, bootinvest, nof){
  
  beta1          <- invest[tt,1]
  beta2          <- invest[tt,2]
  nP             <- length(tt)
  mbootcoef1   <- rowMeans(bootinvest[tt,1,], na.rm=TRUE)
  mbootcoef2   <- rowMeans(bootinvest[tt,2,], na.rm=TRUE)
  vcov1        <- array(0, dim=c(nP, nP, nof))
  vcov2        <- array(0, dim=c(nP, nP, nof))
  
  for (i in 1:nof){
    vcov1[,,i]    <- (bootinvest[tt,1,i] - mbootcoef1) %*% t(bootinvest[tt,1,i] - mbootcoef1)
    vcov2[,,i]    <- (bootinvest[tt,2,i] - mbootcoef2) %*% t(bootinvest[tt,2,i] - mbootcoef2)
  }
  
  vcov1f       <- matrix(0, nP, nP)
  vcov2f       <- matrix(0, nP, nP)
  
  for (j in 1:nP){
    for (k in 1:nP){
      vcov1f[j,k]        <- 1/nof * sum(vcov1[j,k,])
      vcov2f[j,k]        <- 1/nof * sum(vcov2[j,k,])
    }
  }
  
  tbeta1 <- matrix(beta1, length(tt),1)
  tbeta2 <- matrix(beta2, length(tt),1)
  test1 <- beta1 %*% solve(vcov1f) %*% tbeta1
  test2 <- beta2 %*% solve(vcov2f) %*% tbeta2
  
  boottest1 <- rep(0,nof)
  boottest2 <- rep(0,nof)
  for (b in 1:nof){
    boottest1[b] <- (bootinvest[tt,1,b] - beta1 )%*% solve(vcov1f) %*% matrix((bootinvest[tt,1,b] - beta1 ), length(tt), 1)
    boottest2[b] <- (bootinvest[tt,2,b] - beta2 )%*% solve(vcov2f) %*% matrix((bootinvest[tt,2,b] - beta2 ), length(tt), 1)
  }
  
  
  pvalue1          <- 1/nof * sum(indicator(boottest1>rep(test1, nof)))
  pvalue2          <- 1/nof * sum(indicator(boottest2>rep(test2, nof)))
  
  return(c(pvalue1, pvalue2))
}

out_ftest       <- rbind(ftest.func(seq(4,14,2) , iv_true, iv_bstrap, nof) , ftest.func(seq(2,14,2) , iv_true, iv_bstrap, nof))



##############################################################################
# Create table of estimates (point estimate followed by bootstrapped 
# standard errors, 95% ci, p-value one tail test and p-value two tailed test)
############################################################################## 


outtrue     <- list(iv_true)  
outb        <- list(iv_bstrap) 

outtable        <- list()
for (s in 1:1) {
  npar                 <- nrow(outtrue[[s]])
  outtable[[s]]        <- matrix(0, npar*5, 2)
  for (j in 1:2){
    for (i in 1:npar){
      mean             <- mean(outb[[s]][i,j,])
      se               <- sd(outb[[s]][i,j,])
      t_stat           <- mean/se
      t_crit           <- (outb[[s]][i,j,] - mean)/se
      p_val            <- try(1 - ecdf(t_crit)(t_stat))
      p_val2           <- try(1 - ecdf(t_crit^2)(t_stat^2))
      
      outtable[[s]][(i*5-4), j]  <- round(outtrue[[s]][i,j],3)
      outtable[[s]][(i*5-3),j]   <- round(sd(outb[[s]][i,j,]),3) 
      outtable[[s]][(i*5-2), j]  <- paste("[", round(quantile(outb[[s]][i,j,], .025),3), ",", 
                                          round(quantile(outb[[s]][i,j,], .975),3), "]", sep="") 
      outtable[[s]][(i*5-1), j]  <- p_val 
      outtable[[s]][(i*5), j]    <- p_val2 
    } 
  } 
} 


outtable[[1]] <- rbind(outtable[[1]], out_ftest )

# Name output rows and columns 
basic    <- c("Intercept", "", "","","",
              "Treat", "", "", "","",
              "cog0","", "", "","",
              "cog0_T","", "", "","",
              "ncog0", "", "", "","",
              "ncog0_T", "", "", "","",
              "cogmo", "", "", "","",
              "cogmo_T", "", "", "","",
              "ncogmo", "", "", "", "",
              "ncogmo_T", "", "", "","") 

pfnames    <- basic 
for (l in 1:length(c(Xnames)))  pfnames <- c(pfnames, c(Xnames)[l], "", "","", "")
pfnames    <- c(pfnames, "mat", "", "", "","","mat_T", "","", "", "", "Ftest (interactions, no intercept)","Ftest (interactions,with intercept)" )  


colnames(outtable[[1]]) <- c("Cognitive skills", "Socio-emotional skills")
rownames(outtable[[1]]) <- pfnames


# Save output 
setwd(dir_outputPF)
save(iv_true, iv_bstrap, file=paste("OUTPUT_IV_parsinv_fullyinteracted", ".R", sep=""))
write.csv(cbind(outtable[[1]]), file=paste("PF_IV_parsinv_fullyinteracted", ".csv", sep=""))

