###################################################################
# Name              : CobbDouglas_IV_notreatment.R
# 
# Description       : This program estimates the structural 
#                     parameters of the Cobb Douglas production 
#                     functions for cognitive and socio-emotional 
#                     skills by minimum distance and excluding 
#                     treatment from the production function 
###################################################################



###################################################################
# Estimate starting values 
##################################################################
# Estimate starting values for PF (from OLS)
if (nameFirstStage==c("FirstStage_toyprice_foodprice_conflict")){
  start1      <- lm(cog1 ~ cbind(cog0, ncog0, cogmo, ncogmo, kids, mat, time), data=regdata_true)$coef
  start2      <- lm(ncog1 ~ cbind(cog0, ncog0, cogmo, ncogmo, kids, mat, time), data=regdata_true)$coef
  start       <- cbind(start1, start2)
  ninvest      <- 2
} 

if (nameFirstStage==c("FirstStage_toyprice_foodprice_conflict_strata")){
  start1      <- lm(cog1 ~ cbind(cog0, ncog0, cogmo, ncogmo, kids, Central, Oriental, mat, time), data=regdata_true)$coef
  start2      <- lm(ncog1 ~ cbind(cog0, ncog0, cogmo, ncogmo, kids,Central, Oriental, mat, time), data=regdata_true)$coef
  start       <- cbind(start1, start2)
  ninvest      <- 2
} 



###################################################################
# Estimate production functions on true data 
###################################################################
pf_true         <- md.flexfunc(invest_true, rdform_true[,1], 
                               rdform_true[,2],cogrdf_var[c(posExo, posInv), c(posExo, posInv)], ncogrdf_var[c(posExo, posInv), c(posExo, posInv)], start, posExo, posInv, 
                               weighting=TRUE, nInvest = 2)  


###################################################################
# Estimate production functions on bootstrapped samples 
###################################################################
pf_bstrap             <- array(0, dim=c(dim(pf_true), nof))

for (b in 1:nof){  
  
  pf_bstrap[,,b]         <- md.flexfunc(invest_bstrap[,,b], rdform_bstrap[,1,b], 
                                        rdform_bstrap[,2,b], cogrdf_var[c(posExo, posInv), c(posExo, posInv)], ncogrdf_var[c(posExo, posInv), c(posExo, posInv)],  
                                        start, posExo, posInv, weighting=TRUE, nInvest = 2)
  print(b)
  
  
} 


##############################################################################
# Create table of estimates (point estimate followed by bootstrapped 
# standard errors, 95% ci, p-value one tail test and p-value two tailed test)
##############################################################################

outtrue     <- list(pf_true)  
outb        <- list(pf_bstrap) 

outtable        <- list()
for (s in 1:1) {
  npar                 <- nrow(outtrue[[s]])
  outtable[[s]]        <- matrix(0, npar*5, 2)
  for (j in 1:2){
    for (i in 1:npar){
      mean             <- mean(outb[[s]][i,j,])
      se               <- sd(outb[[s]][i,j,])
      t_stat           <- mean/se
      t_crit           <- (outb[[s]][i,j,] - mean)/se
      p_val            <- 1 - ecdf(t_crit)(t_stat)
      p_val2           <- 1 - ecdf(t_crit^2)(t_stat^2)
      
      outtable[[s]][(i*5-4), j]  <- round(outtrue[[s]][i,j],3)
      outtable[[s]][(i*5-3),j]   <- round(sd(outb[[s]][i,j,]),3) 
      outtable[[s]][(i*5-2), j]  <- paste("[", round(quantile(outb[[s]][i,j,], .025),3), ",", 
                                          round(quantile(outb[[s]][i,j,], .975),3), "]", sep="") 
      outtable[[s]][(i*5-1), j]  <- p_val 
      outtable[[s]][(i*5), j]    <- p_val2 
    } 
  } 
} 


# Name output rows and columns 
basic    <- c("Intercept", "", "","","",
              "cog0","", "", "","",
              "ncog0", "", "", "","",
              "cogmo", "", "", "","",
              "ncogmo", "", "", "","") 

pfnames    <- basic 
for (l in 1:length(c(Xnames)))  pfnames <- c(pfnames, c(Xnames)[l], "", "","", "")
pfnames    <- c(pfnames, "mat", "", "", "","", "time", "", "", "","")  

rownames(outtable[[1]]) <- pfnames
colnames(outtable[[1]]) <- c("Cognitive skills", "Socio-emotional skills")


# Save output 
setwd(dir_outputPF)
save(pf_true, pf_bstrap, file=paste("OUTPUT_IV_notreatment_pval", ".R", sep=""))
write.csv(cbind(outtable[[1]]), file=paste("PF_IV_notreatment_pval", ".csv", sep=""))
