# Cobb douglas production function by OLS with correction for factor scores 
###################################################################
pf.ols.func.MC                        <- function(fs, X, Xnames, treatnomiss, RHSnames , pos, totmean, mean, cov, prob, parametric){
  

  Xall       <- cbind(X)
  
  fmla_cog     <- as.formula(paste("cog1 ~ ", paste(RHSnames, collapse= "+")))
  fmla_ncog    <- as.formula(paste("ncog1 ~ ", paste(RHSnames, collapse= "+")))


  #################### COMPUTE CORRECTION MATRIX 
  if (parametric==1){

        A             <- bartlett.correction.mixt.noX.func(list(fs[[1]][,pos], fs[[2]][,pos]), Xall, treatnomiss, nG=2, nF, nFpos=ncol(fs[[1]][,pos]), nX=0, pos, totmean, mean, cov, prob, parametric)
        regdata       <- data.frame(cbind(rbind(fs[[1]],fs[[2]]), treatnomiss))

      
  } else if (parametric ==0){
    A             <- bartlett.correction.mixt.func(list(fs[[1]][,pos], fs[[2]][,pos]), Xall, treatnomiss, nG=2, nF, nFpos=ncol(fs[[1]][,pos]), nX=0, pos, totmean, mean, cov, prob, parametric)
    regdata       <- data.frame(cbind(rbind(fs[[1]],fs[[2]]), treatnomiss))
  }


     # Make regression dataset
     colnames(regdata) <- c("cog1", "cog0", "mat", "time", "cogmo","treat")
     data_Xnoint       <- regdata[,c(-1,  -ncol(regdata))]

     # Estimate investment function and correct coefficients
     cog            <- lm(fmla_cog, data=as.data.frame(regdata))
     cog_bias       <- as.matrix(cog$coefficients)
     cogslo         <- solve(A) %*% as.vector(cog$coefficients)[c(-1, -2)]
     cogint0        <- mean(regdata[which(treatnomiss==1),]$cog1) - colMeans(data_Xnoint[which(treatnomiss==1),]) %*% cogslo
     cogint01       <- mean(regdata[which(treatnomiss==2),]$cog1) - colMeans(data_Xnoint[which(treatnomiss==2),]) %*% cogslo
     cogint1        <- cogint01 - cogint0
     cog_correct    <- rbind(cogint0, cogint1, cogslo)

     # Put estimates together
     est_correct     <- cog_correct
     est_bias        <- cog_bias
     rownames(est_correct) <- c("Intercept", "Treat", "cog0",  "mat", "time","cogmo")
     rownames(est_bias)    <- rownames(est_correct)


   return(list(est_correct , est_bias))
 }

