###################################################################
# Name              : AssembleBootstrapFM.R
# Description       : This program puts together all the results on the 
#                     bootstrapped samples and ouputs estimates of the 
#                     measurement system. 
###################################################################

setwd(dir_anal)                             
source(inputFM) 


##################################################################
# Put together the output from the boostrap if it has been 
# estimated on several R windows ("nodes")
##################################################################

# Put all the results from the different nodes together in a list called "allbootFM" 
cores              <- length(pos)               # Total number of nodes 
allbootFM          <- list()

# Save this list in the directory with the output for the measurement system 
setwd(dir_outputFM)                              
for (b in 1:cores){  
  nameBootFM         <- paste("BootFM", pos[b], ".R", sep="")
  load(nameBootFM)
  allbootFM[[b]] <- bootFM
}

save(allbootFM, file="allbootFM.R")


# Save the different components of this list into separate objects (slightly different if we did parametric or non-parametric estimation of measurement system)
if (parametric == 1){
  allbsample      <- bsample * cores 
  probBoot        <- array(0, dim=c(nM, allbsample,nG))
  meanBoot        <- array(0, dim=c(nM, nFI, allbsample,nG))
  covBoot         <- array(0, dim=c(nFI*2, nFI, allbsample, nG))
  lambdaBoot      <- array(0, dim=c(nZ, nF, allbsample))
  epsBoot         <- array(0, dim=c(nZ, allbsample))
for (c in 1:cores){
  for (r in 1:(allbsample/cores)){
   
    for (g in 1:nG){
      if (length(allbootFM[[c]][[r]]) == 1){
        probBoot[,(c-1)*(allbsample/cores) + r,g] <- rep(-999, nM)
        meanBoot[,,(c-1)*(allbsample/cores) + r,g] <- matrix(NA, nM, nFI)
        covBoot[,,(c-1)*(allbsample/cores) + r,g]   <- matrix(NA,nFI*2, nFI  )
    } else if (length(allbootFM[[c]][[r]]) != 1){ 
      probBoot[,(c-1)*(allbsample/cores) + r,g]    <- allbootFM[[c]][[r]]$prob[[g]]     
      meanBoot[,,(c-1)*(allbsample/cores) + r,g]   <- allbootFM[[c]][[r]]$mean[[g]]
      covBoot[,,(c-1)*(allbsample/cores) + r,g]    <- rbind(allbootFM[[c]][[r]]$cov[[g]][[1]],allbootFM[[c]][[r]]$cov[[g]][[2]])
    }  
    
    if (length(allbootFM[[c]][[r]]) == 1){
      lambdaBoot[,,(c-1)*(allbsample/cores) + r] <- matrix(NA, nZ, nF)
      epsBoot[,(c-1)*(allbsample/cores) + r]    <- rep(NA, nZ)        
    } else if (length(allbootFM[[c]][[r]]) != 1){
    lambdaBoot[,,(c-1)*(allbsample/cores) + r]     <- allbootFM[[c]][[r]]$lambda
    epsBoot[,(c-1)*(allbsample/cores) + r]         <- allbootFM[[c]][[r]]$eps   
    } 
    
  }  
}
}

# Flag those bootstrapped samples for which the estimation of the measurement system did not converge (if any)
  flag <- 0
  for (b in 1:allbsample){
    if (probBoot[,b,1][1]==-999) {
      flag <- c(flag, b)
    } else if (probBoot[,b,1][1]!=-999){
      flag <- flag
    }
  }
} 

# Save the different components of this list into separate objects (slightly different if we did parametric or non-parametric estimation of measurement system)
if (parametric == 0){
  allbsample      <- bsample * cores 
  meanBoot        <- array(0, dim=c(1, nFI, allbsample))
  covBoot         <- array(0, dim=c(nFI, nFI, allbsample, nG))
  lambdaBoot      <- array(0, dim=c(nZ, nF, allbsample))
  epsBoot         <- array(0, dim=c(nZ, allbsample))
  for (c in 1:cores){
    for (r in 1:(allbsample/cores)){
      for (g in 1:nG){
        if (length(allbootFM[[c]][[r]]) == 1){
          covBoot[,,(c-1)*(allbsample/cores) + r,g]   <- matrix(NA,nFI, nFI  )
        } else if (length(allbootFM[[c]][[r]]) != 1){ 
          covBoot[,,(c-1)*(allbsample/cores) + r,g]    <- allbootFM[[c]][[r]]$cov[[g]]
        }  
        
        if (length(allbootFM[[c]][[r]]) == 1){
          meanBoot[,,(c-1)*(allbsample/cores) + r] <- matrix(-999, 1, nFI)
          lambdaBoot[,,(c-1)*(allbsample/cores) + r] <- matrix(NA, nZ, nF)
          epsBoot[,(c-1)*(allbsample/cores) + r]    <- rep(NA, nZ)        
        } else if (length(allbootFM[[c]][[r]]) != 1){
          meanBoot[,,(c-1)*(allbsample/cores) + r]   <- allbootFM[[c]][[r]]$mean
          lambdaBoot[,,(c-1)*(allbsample/cores) + r]     <- allbootFM[[c]][[r]]$lambda
          epsBoot[,(c-1)*(allbsample/cores) + r]         <- allbootFM[[c]][[r]]$eps   
        } 
        
      }  
    }
  } 
  
# Flag those bootstrapped samples for which the estimation of the measurement system did not converge (if any)
  flag <- 0
  for (b in 1:allbsample){
    if (meanBoot[,,b][1]==-999) {
      flag <- c(flag, b)
    } else if (meanBoot[,,b][1]!=-999){
      flag <- flag
    }
  }
} 




if (length(flag)==1){
  noflag = seq(1, allbsample)
} else if (length(flag)>=1){
  flag = flag[-1] 
  noflag       <- seq(1, allbsample)
  noflag       <- noflag[-flag] 
}

nof          <- length(noflag)



##################################################################
# Save estimates of the different parameters of the 
# measurement system (point estimates and bootstrapped 
# standard errors)
##################################################################

# Load the estimates obtained on the true data 
setwd(dir_outputFM)
load("trueFM.R")

# Measurement error
 epsSE <- matrix(0, nZ, 2)
 for (i in 1:nZ){
   epsSE[i,1] <- eps[i]
   epsSE[i,2]   <- sd(epsBoot[i,], na.rm=TRUE) 
 }
write.csv(epsSE, file="epsSE.csv")



# Mixture weights  
if (parametric == 1) {
  probSE <- matrix(0, 4, 2)
  
for (g in 1:2){
  probSE[1,g] <- prob.mix[[g]][1]
  probSE[2,g] <- apply(probBoot[,,g], 1, sd, na.rm=TRUE)[1]
  probSE[3,g] <- prob.mix[[g]][2]
  probSE[4,g] <- apply(probBoot[,,g], 1, sd,na.rm=TRUE)[2]
} 
write.csv(probSE, file="probSE.csv")
}


# Means
if (parametric == 1) {
mean_sd <- array(0, dim=c(nM, nFI, nG))
for (g in 1:nG){
  for (m in 1:nM){
    for (f in 1:nFI){
      mean_sd[m,f,g]      <- sd(meanBoot[m,f,,g], na.rm=TRUE)
    }
  }
} 

meanSE <- array(0, dim=c(nM*2, nFI, nG))

for (i in 1:nM){
  for (g in 1:nG){
    meanSE[(i*2-1),,g] <- mean.mix[[g]][i,]
    meanSE[(i*2),,g]   <- mean_sd[i,,g]
  }
} 
write.csv(meanSE, file="meanSE.csv")
} 

if (parametric == 0) {
  mean_sd <- array(0, dim=c(1, nFI))
  for (f in 1:nFI){
   mean_sd[1,f]      <- sd(meanBoot[1,f,], na.rm=TRUE)
 }

  
  meanSE <- matrix(0, 2, nFI)
  meanSE[1, ] <- mean.mix
  meanSE[2,]  <- mean_sd
  write.csv(meanSE, file="meanSE.csv")
} 

# Covariances 
if (parametric == 1){
  cov_sd <- array(0,dim=c(nFI*2, nFI, nG))
  for (g in 1:nG){  
    for (i in 1:(nFI*2)){
      for (j in 1:nFI){
        cov_sd[i,j,g]      <- sd(covBoot[i,j,,g], na.rm=TRUE)
      }
    }
  } 
  
  covSE <- array(0, dim=c(nFI*4, nFI, nG))
  for (g in 1:nG){
    for (i in 1:(nFI*2)){
      covSE[(i*2-1),,g] <- cov.mix[[g]][i,]
      covSE[(i*2),,g]   <- cov_sd[i,,g]
    } 
  }
  
  write.csv(covSE, file="covSE.csv")
  
}
if (parametric == 0){
  cov_sd <- array(0,dim=c(nFI, nFI, nG))
  for (g in 1:nG){
    for (i in 1:nFI){
      for (j in 1:nFI){
        cov_sd[i,j,g]      <- sd(covBoot[i,j,g,], na.rm=TRUE)
      }
    }
  }  
  
  
  covSE <- array(0, dim=c(nFI*2, nFI, nG))
  for (g in 1:nG){
    for (i in 1:(nFI)){
      covSE[(i*2-1),,g] <- cov.mix[[g]][i,]
      covSE[(i*2),,g]   <- cov_sd[i,,g]
    } 
  }
  
  write.csv(covSE, file="covSE.csv") 
}


# Factor Loadings with SE 
lambda_sd <- matrix(0, nZ, nF)
for (i in 1:nZ){
  for (j in 1:nF){
    lambda_sd[i,j]      <- sd(lambdaBoot[i,j,], na.rm=TRUE)
  }
}

lambdaSE <- matrix(0, (nZ*2), nF)
for (i in 1:nZ){
  lambdaSE[(i*2-1),] <- lambda[i,]
  lambdaSE[(i*2),] <- lambda_sd[i,]
}

write.csv(lambdaSE, file="lambdaSE.csv")

# Factor Loadings without SE 
write.csv(lambda, file="lambda.csv")


# Total implied means for each group 
if (parametric == 1){
  totmean <- array(0, dim=c(3, nFI, nG)) 
  intertotmean <- rep(0, allbsample)
  for (g in 1:nG){
    totmean[1,,g] <- prob.mix[[g]]%*%mean.mix[[g]]
    for (f in 1:nFI){
      intertotmean  <- probBoot[1,,g]*meanBoot[1,f,,g] 
      for (m in 2:nM) intertotmean <- intertotmean + probBoot[m,,g]*meanBoot[m,f,,g] 
      totmean[2,f,g] <- sd(intertotmean, na.rm=TRUE)
      totmean[3,f,g] <- paste("[", round(quantile(intertotmean, .025, na.rm=TRUE),3), ",", round(quantile(intertotmean, .975, na.rm=TRUE),3), "]", sep="")    
    }
  }
  
write.csv(totmean, file="totmeanSE.csv")

# Overall covariance of factors 
cov_f          <- list()

dcov        <- list()
for (g in 1:nG) dcov[[g]]    <- list(cov.mix[[g]][1:nF, ], cov.mix[[g]][(nF+1):(nF*2),]) 

  for (g in 1:nG) {
    cov_f[[g]]     <- matrix(0, nF, nF)
    for (i in 1:nF){
      for (j in 1:nF){
        cov_f[[g]][i,j]  <- prob.mix[[g]][1] * (dcov[[g]][[1]][i, j]) + prob.mix[[g]][2] * (dcov[[g]][[2]][i, j] ) + 
          ( (prob.mix[[g]][1] * mean.mix[[g]][1,i] * mean.mix[[g]][1,j]  + prob.mix[[g]][2] * mean.mix[[g]][2,i] * mean.mix[[g]][2,j])  - 
              (prob.mix[[g]][1] * mean.mix[[g]][1,i]  + prob.mix[[g]][2] * mean.mix[[g]][2,i]) * (prob.mix[[g]][1] * mean.mix[[g]][1,j]  + 
                                                                                    prob.mix[[g]][2] * mean.mix[[g]][2,j])) 
      }
    }
} 

cor_control <- cov2cor( cov_f[[1]])
cor_treat    <- cov2cor( cov_f[[2]])
write.csv(cor_control, file="cor_control.csv")
write.csv(cor_treat, file="cor_treat.csv")

}