function output=merger_s_draw_reallocate(id1,id2,side,R,type_sim)
% This function compute all counterfactual output for a merger between 
% firm id1 and id2. id1 corresponds to the high iq firm and id2 is a row vector 
% corresponds to the (relatively) low iq firms. ("side=1"==choose 
% auctions on the INC side; "side=2"==choose those on the DEC side; 
% "side=0"==all auctions)
%-------------------------------------------------------------------------%
%                             Bidder IDs                                  %
%-------------------------------------------------------------------------%
                                                                          %
% High Type Firms (Strategic firms):                                      %
% Brownsville=3,Bryan=4,Calpine=5,Reliant=19,Tenaska Gateway=24,          %
% TXU also 28=27                                                          %                            
% Low Type Firms:                                                         %
% Central Power and Light=6,Guadalupe=15,Tenaska Frontier=23,             %
% West Texas Utilities=29,Air Liquide America=102,Extex Laporte=117,      %
% AES deepwater=101,Lamar Power Partners=16,Cogen Lyondell=9,             %
% Brazos Electric Power=2,Gregory Power Partners=118,                     %
% Tractebel Power Inc=26,BP Energy=1,City of Garland=8,                   %
                                                                          %
%-------------------------------------------------------------------------%

%-------------------------------------------------------------------------%
%                        (1) Set Model Primitives                         %
%-------------------------------------------------------------------------%
format shortG                                                             %
bidders_CH = [4,5,19,27,6,15,29,24,23,8,16,9];                            % players in CH
% gamma = [-0.547  15.625];                                                 % parameters from estimation
gamma = [-0.726 14.594];
mergefirms=[id1,id2];                                                     % mergefirms(1) acquires mergefirms(2:end)
bidders_CH_merger=find_firms_merger(bidders_CH,mergefirms);               % find firms in CH after merger
K=20;                                                                          %
%-------------------------------------------------------------------------%
%                            (2) Load Data                                %
%-------------------------------------------------------------------------%
                                                                          %
dat = dlmread('full_pqs_combined_TXU.csv',',');                           %
dat2 = dlmread('totdemand_mcprice_combined.csv',',');                     %
dat3 = dlmread('mcosts_dec_20pct_combined_TXU.csv',',');                  %
dat4 = dlmread('firm_size_new.csv',',');                                  %
dat5 = dlmread('tqcall_reallocate.csv',',');   

aucid = dat5(:,1);
%aucid = aucid+0.25;
tqcall_allocate = dat5(:,2:end);

%{
disp('aucid');
disp(aucid);
disp(size(aucid));
pause;
disp('tqcall_allocate');
disp(tqcall_allocate(1,:));
disp(size(tqcall_allocate));

pause;
%}
                                                                          %
time_pq = dat(:,1);                                                       % auction IDs in bids data
p = dat(:,2);                                                             % price unit of bids 
qinc = dat(:,3);                                                          % incremental bids
bidderid = dat(:,4);                                                      % firm IDs in the bids data
qcum = dat(:,5);                                                          % cumulative bids
                                                                          %
time_dem = dat2(:,1);                                                     % auction IDs in total demand and market clearing price data set
totdem = dat2(:,2);                                                       % total demand 
mktcp = dat2(:,3);                                                        % actual market clearing price
                                                                          %
time_mc = dat3(:,1);                                                      % auction IDs in MC data
mc_unit = dat3(:,2);                                                      % price unit in marginal cost
mc_cum = dat3(:,5);                                                       % cumlative marginal cost
mc_inc_q = dat3(:,4);                                                     % incremental marginal cost
qse_id = dat3(:,3);                                                       % firm IDs in the MC data
                                                                          %
sizeid = dat4(:,1);                                                       % firm ID for firm size
firm_size_all = dat4(:,2);                                                % firm size
                                                                          %
%-------------------------------------------------------------------------% 
%              (3) Find the Auctions That Are Studied                     %
%-------------------------------------------------------------------------%
                                                                          %
aucvec = unique(time_pq);                                                 % step0: Following instruction from Dr. Puller
aucvec = [aucvec(1:25);aucvec(28:100);aucvec(116:119);aucvec(121:139);... %
    aucvec(143:end)];                                                     %
                                                                          %
aucvec_use=find_auc_CH(bidders_CH,aucvec,time_pq,bidderid,time_mc,qse_id);% step1: all bidders in CH appear in these auctions
                                                                          %
aucvec_use=find_auc_QC(aucvec_use,bidders_CH,time_pq,time_mc,p,qinc,...   % step2: find auctions in which all contract  
    bidderid,mc_unit,mc_inc_q,qse_id);                                    % positions of players in CH can be found
aucvec_use=[aucvec_use(1:67);aucvec_use(69:88);aucvec_use(90:end)];       %
                                                                          %
aucvec_use=find_DEC_INC_ALL(side,aucvec_use,time_dem,totdem);             % "side=1"==choose INC side;"side=2"==choose DEC side;
                                                                          % "side=0"==all auctions
%-------------------------------------------------------------------------%
%                  (4) Simulate Firm Bids After Merger                    %                 
%-------------------------------------------------------------------------%
                                                                          %
[X, X_merger]=find_X_Xnew_merger_s(bidders_CH,bidders_CH_merger,...       % covariate matrix (X) after Merger
    sizeid,firm_size_all);                                                %
                                                                          %
time_pq_fringe=fringe_dat(aucvec_use,bidders_CH,time_pq,p,qinc,bidderid); % find fringe firm bids
time_fringe = time_pq_fringe(:,1);                                        % auction ID for fringe data
p_fringe_all = time_pq_fringe(:,3);                                       % price unit of fringe bids
q_fringe_all = time_pq_fringe(:,4);                                       % fringe bids% find mc after merger
                                                                          %
[time_id_mc_mat,dat_ahead,dat_ahead_merger]=mc_merger(aucvec_use,time_mc,mc_unit,mc_inc_q,mc_cum,...   %
    qse_id,mergefirms);   
%disp('dat_ahead_merger');
%disp(dat_ahead_merger);
%pause;
%
time_mc_merger = time_id_mc_mat(:,1);                                     % auction ID in the MC data after merger
mc_unit_merger = time_id_mc_mat(:,3);                                     % price unit of marginal cost in MC data after merger
mc_inc_merger = time_id_mc_mat(:,4);                                      % incremental marginal cost in MC data after merger 
mc_cum_merger = time_id_mc_mat(:,5);                                      % cumulative marginal cost in MC data after merger 
qseid_merger = time_id_mc_mat(:,2);                                       % firm ID in the MC data after merger

qcont_mat_all = see_contract(aucvec_use,bidders_CH,time_pq,time_mc,...    % find contract position before merger
    p,qinc,bidderid,mc_unit,mc_inc_q,qse_id);                             %
time_qcont = qcont_mat_all(:,1);                                          % IDs of auctions in the contract position data set
qcont_mat = qcont_mat_all(:,2:end);                                       % qcont_mat(13,4) contract position of the 4th bidder in CH at auction #13
                                                                          %
qcont_mat_merger=find_qcon_merger(qcont_mat_all,bidders_CH,mergefirms);   % find contract position after merger
time_qcont_merger=qcont_mat_merger(:,1);                                  %
qcont_merger_mat=qcont_mat_merger(:,2:end);                               %
                                                                          %
[time_id_bids_merger_mat,n_pgrid] = find_bids_pre_draw(gamma,aucvec_use,time_dem,...     % bids after merger
    mktcp,time_mc_merger,time_fringe,time_qcont_merger,mc_unit_merger,... %
    mc_inc_merger,qseid_merger,p_fringe_all,q_fringe_all,...              %
    bidders_CH_merger,qcont_merger_mat,X_merger,K);                         %
                                                                          %
time_merger = time_id_bids_merger_mat(:,1);                               % auction ID in the bids data set after merger
p_merger = time_id_bids_merger_mat(:,3);                                  % bids price unit in the bids data set after merger
qinc_merger = time_id_bids_merger_mat(:,4:4+K);                               % incremental bids in the bids data set after merger
qcum_merger = time_id_bids_merger_mat(:,5+K:end);                               % cumulative bids in the bids data set after merger
bidderid_merger = time_id_bids_merger_mat(:,2);                           % bidder ID in the bids data set after merger
                                                                          %
im1000=find(mc_unit==-1000);                                              % MC has the convention that the first price point is at -1000, rather than
mc_unit(im1000)=-10001;                                                   % at -10001, which is the convention with bids. Change these prices to -10001 to be consistent with bids
i1000=find(mc_unit==1000);                                                %
mc_unit(i1000)=10001;                                                     %
im1000_merger=find(mc_unit_merger==-1000);                                %
mc_unit_merger(im1000_merger)=-10001;                                     %
i1000_merger=find(mc_unit_merger==1000);                                  %
mc_unit_merger(i1000_merger)=10001;                                       %
                                                                          %
%-------------------------------------------------------------------------%
%                   (5) Calculate Output After Merger                     %
%-------------------------------------------------------------------------%
                                                                          %
%output=[];                                                                % matrix recording outcomes for each auction

tcost_mat=[];
mktcp_mat=[];
tqcall_mat=[];
tcost_allo_mat=[];

indcost_mat = [];
indprofit_mat = [];
qcall_mat = [];
                                                                          %
for j1 = 1:length(aucvec_use)                                             %
                                                                          %
%~~~~~~~~~~~~~~~~~~ (5.1) load data for this auction ~~~~~~~~~~~~~~~~~~~~~% 
                                                                          %
    
                                                                          
    thisauc=aucvec_use(j1);                                               % ID of this auction
%    disp('thisauc');
%    disp(thisauc);
%    pause;

   %%%% find tqcalled when reallocate generation
   a=find(aucid==thisauc);
%   disp('a');
%   disp(a);
%   pause
    tqcall_allo_sim = tqcall_allocate(find(aucid==thisauc),:);
    
%    disp('tqcall_allo_sim');
%    disp(tqcall_allo_sim);
%    disp(size(tqcall_allo_sim));
%    pause;
                                                                          %
    totdemauc = totdem(find(time_dem==thisauc));                          % total demand
                                                                          %
    pauc = p(find(time_pq==thisauc));                                     % real bids
    qinc_auc = qinc(find(time_pq==thisauc));                              % 
    bidderidauc = bidderid(find(time_pq==thisauc));                       % 
    biddervecauc = unique(bidderidauc);                                   % 
                                                                          %
    iauc3 = find(ismember(time_mc,thisauc).*ismember(qse_id,biddervecauc));% find the marginal cost data 
    mcp_auc = mc_unit(iauc3);                                             % for firms that submitted bids
    mcq_auc = mc_inc_q(iauc3);                                            % 
    qseidauc = qse_id(iauc3);                                             % 
                                                                          %
    mcp_auc_merger=mc_unit_merger(find(time_mc_merger==thisauc));         %
    mcq_auc_merger=mc_inc_merger(find(time_mc_merger==thisauc));          %
    qseid_auc_merger=qseid_merger(find(time_mc_merger==thisauc));         % 
                                                                          %
    qcont_merger_mat_auc = qcont_merger_mat...                            %
        (find(time_qcont_merger==thisauc),:);                             % contract positions of CH bidders 
                                                                          % in this auction after merger
    %%%%%%%%%%%%%%%%%% changed by Dongni on Oct 4 %%%%%%%%%%%%%%%%%%%%%%%%%%%%   
%output_auc_merger_avg=zeros(length(bidders_CH_merger),6);
%tcost_merger_avg = 0;
%tqcall_merger_avg = 0;
    tcost_mat(j1,1) = thisauc;
    mktcp_mat(j1,1) = thisauc;
    tqcall_mat(j1,1) = thisauc;
    tcost_allo_mat(j1,1) = thisauc;
    
    indcost_sim = [];
    indprofit_sim = [];
    qcall_sim = [];
for r = 1:R
    
    type_r = type_sim(:,r);
    %disp('type_r');
    %disp(type_r);
    %pause;


    
    tqcall_allo=tqcall_allo_sim(r);
    
    p_auc_merger = p_merger(find(time_merger==thisauc));                  % bids after merger                                                    
    bidderid_auc_merger = bidderid_merger(find(time_merger==thisauc));    %   
    qinc_auc_merger_r = qinc_merger(find(time_merger==thisauc),:); 
    
    qinc_auc_merger = [];   
    for j = 1:length(bidders_CH_merger)
        %if type_r(j)>20
        %    type_r(j)=20;
        %end
        q_this = qinc_auc_merger_r((j-1)*n_pgrid+1:j*n_pgrid,(type_r(j)+1));
        qinc_auc_merger = [qinc_auc_merger;q_this];
    end                                                                          
                                                                          
%~~~~~~~~~~~~~ (5.2) find market clearing price after merger ~~~~~~~~~~~~~%
                                                                          %
    [pauc_merger_all,qauc_merger_all,bidderidauc_merger_all]=...          % replace CH players' real bid with bids
        replace_bids_merger(bidders_CH,bidders_CH_merger,pauc,qinc_auc,...%    
        bidderidauc,p_auc_merger,qinc_auc_merger,bidderid_auc_merger);    %
                                                                          %
    [aggqmerger, aggpmerger] = agg_supply(pauc_merger_all,qauc_merger_all);
    mktcp_merger = find_mktclr_new(aggqmerger,aggpmerger,totdemauc);      % market clearing price after merger
                                                                          %
%~~~~~~~~~~~~~~~~~~ (5.3) simulate output after merger ~~~~~~~~~~~~~~~~~~~%
                                                                          %
    %output_auc=[];                                                        % record output for this auction
    tqcall_merger=0;                                                      % record quantity called in this auction
    tcost_merger=0;                                                       % record total cost for this auction
                                                                          %
    biddervecauc_merger = unique(bidderidauc_merger_all);                 % unique bidder ID after merger in this auction
                                                                          %
    bidder_auc = [];%
    indcost_auc = [];
    indprofit_auc = [];
    qcall_auc = [];     
    
    for k1=1:length(biddervecauc_merger)                                  %
                                                                          %
        thisbidder_merger = biddervecauc_merger(k1);                      %
                                                                          %
        if ismember(thisbidder_merger,bidders_CH_merger)                  %
        mcpbidder_merger = mcp_auc_merger(find(qseid_auc_merger==...      %
            thisbidder_merger));                                          %
        mcqbidder_merger = mcq_auc_merger(find(qseid_auc_merger==...      %
            thisbidder_merger));                                          %
        pbidder_merger = pauc_merger_all(find(bidderidauc_merger_all ==...%
            thisbidder_merger));                                          %
        qbidder_merger = qauc_merger_all(find(bidderidauc_merger_all ==...%
            thisbidder_merger));                                          %
        else                                                              %
        mcpbidder_merger = mcp_auc(find(qseidauc==thisbidder_merger));    %
        mcqbidder_merger = mcq_auc(find(qseidauc==thisbidder_merger));    %
        pbidder_merger = pauc(find(bidderidauc==thisbidder_merger));      %
        qbidder_merger = qinc_auc(find(bidderidauc==thisbidder_merger));  % incremental quantity
        end                                                               %
                                                                          %
        if max(mcqbidder_merger)==0 & max(qbidder_merger)>0               % if mc cannot INC that much so assumed mc is the bids 
            mcqbidder_merger = qbidder_merger;                            %
            mcpbidder_merger = pbidder_merger;                            %
        end                                                               %
                                                                          %
        ybidder_merger = cumsum(qbidder_merger);                          % cumulative bids for this bidder after merger                 
        mcqcumbidder_merger = cumsum(mcqbidder_merger);                   % cumulative mc for this bidder after merger
        qcall_merger = find_qcall_new(mktcp_merger,aggqmerger,...         % quantity called of this bidder
            aggpmerger,totdemauc,ybidder_merger,pbidder_merger);          %
        indcost_merger = find_individualcost(mcqcumbidder_merger,...      % production cost of this bidder
            mcpbidder_merger,qcall_merger,thisbidder_merger);             %
        tqcall_merger=tqcall_merger+qcall_merger;                         % quantity called of this auction
        tcost_merger=tcost_merger+indcost_merger;                         % total cost of this auction
                                                                          %
        if ismember(thisbidder_merger,bidders_CH_merger)                  %
            qcont_bidder_merger=qcont_merger_mat_auc...                   %
                (find(bidders_CH_merger==thisbidder_merger));             %
            [profit_merger,totcost_merger] = find_profit1...              %
                (mcqcumbidder_merger,mcpbidder_merger,qcall_merger,...    %
                mktcp_merger,qcont_bidder_merger,thisbidder_merger);      %
        end                                                               %
                                                                          %
%%%% figure out tcost after rellocating generation  

        if ismember(thisbidder_merger,id1)
            indcost_merger_allo = find_individualcost(mcqcumbidder_merger,...      % production cost of this bidder
            mcpbidder_merger,tqcall_allo,thisbidder_merger); 
        end
                                                                          
                                                                          
                                                                          
                                                                          
%-------------------------------------------------------------------------%
%                            (6) Record Output                            %
%-------------------------------------------------------------------------%
                                                                          %            
        if ismember(thisbidder_merger,bidders_CH_merger)                  % record output if this firm is in CH
            %output_auc_bidder_merger=[thisbidder_merger ...               %
            %    qcont_bidder_merger mktcp_merger qcall_merger ...         %
            %    indcost_merger profit_merger];                            %
            %output_auc=[output_auc;output_auc_bidder_merger];             %
            
            bidder_auc=[bidder_auc;thisbidder_merger];
            indcost_auc=[indcost_auc;indcost_merger];
            indprofit_auc = [indprofit_auc;profit_merger];
            qcall_auc = [qcall_auc;qcall_merger]; 
            
        end                                                               %
    end
    %output_auc_merger_avg=output_auc_merger_avg+output_auc;
    %tcost_merger_avg = tcost_merger_avg+tcost_merger;
    %tqcall_merger_avg = tqcall_merger_avg+tqcall_merger;
    tcost_mat(j1,r+1) = tcost_merger;
    mktcp_mat(j1,r+1) = mktcp_merger;
    tqcall_mat(j1,r+1) = tqcall_merger;
    tcost_allo_mat(j1,r+1) = indcost_merger_allo;
        
    indcost_sim = [indcost_sim indcost_auc];
    indprofit_sim = [indprofit_sim indprofit_auc];
    qcall_sim = [qcall_sim qcall_auc];
end

    indcost_sim = [bidder_auc indcost_sim];
    indprofit_sim = [bidder_auc indprofit_sim];
    qcall_sim = [bidder_auc qcall_sim];
    %output_auc_merger_avg=output_auc_merger_avg/R;
    %tcost_merger_avg = tcost_merger_avg/R;
    %tqcall_merger_avg = tqcall_merger_avg/R;


%a=ones(size(output_auc,1),1);                                             %                                            %
%output=[output;[a*thisauc output_auc_merger_avg a*totdemauc a*tqcall_merger_avg...       %
%    a*tcost_merger_avg]];  


   a=ones(size(bidder_auc,1),1);                                         %
    
   indcost_mat = [indcost_mat; [a*thisauc indcost_sim]];
   indprofit_mat = [indprofit_mat; [a*thisauc indprofit_sim]];
   qcall_mat = [qcall_mat;[a*thisauc qcall_sim]];
    

%
end% for j1 = 1:samplelength

%{
column1=output(:,1);
column2=output(:,2);
column3=output(:,3);
column4=output(:,4);
column5=output(:,5);
column6=output(:,6);
column7=output(:,7);
column8=output(:,8);
column9=output(:,9);
column10=output(:,10);

filename=['merger_s_draw ' num2str(id1) ' acquires ' num2str(id2)...           %
    '_' num2str(side) '.csv'];                                            %
fid = fopen(filename,'W');
fprintf(fid,'%s,%s,%s,%s,%s,%s,%s,%s,%s,%s\n','aucID','bidderID',...
    'qcont','mktcp','qcall','cost','profit','totdem','tqcalled','tcost');
 for a=1:length(column1)
     fprintf(fid,'%g,%g,%g,%g,%g,%g,%g,%g,%g,%g\n',...
         column1(a),column2(a),column3(a),column4(a),column5(a),...
         column6(a),column7(a),column8(a),column9(a),column10(a));
 end
fclose(fid);                                               %

filename2 = ['merger_s_draw_tcost ' num2str(id1) ' acquires ' num2str(id2)...           %
    '_' num2str(side) '.csv'];      
xlswrite(filename2,tcost_mat);

filename3 = ['merger_s_draw_mktcp ' num2str(id1) ' acquires ' num2str(id2)...           %
    '_' num2str(side) '.csv'];      
xlswrite(filename3,mktcp_mat);

filename4 = ['merger_s_draw_tqcall ' num2str(id1) ' acquires ' num2str(id2)...           %
    '_' num2str(side) '.csv'];      
xlswrite(filename4,tqcall_mat);

filename5 = ['merger_s_draw_indcost ' num2str(id1) ' acquires ' num2str(id2)...           %
    '_' num2str(side) '.csv'];      
xlswrite(filename5,indcost_mat);

filename6 = ['merger_s_draw_indprofit ' num2str(id1) ' acquires ' num2str(id2)...           %
    '_' num2str(side) '.csv'];      
xlswrite(filename6,indprofit_mat);

filename7 = ['merger_s_draw_indqcall ' num2str(id1) ' acquires ' num2str(id2)...           %
    '_' num2str(side) '.csv'];      
xlswrite(filename7,qcall_mat);
%}
filename8 = ['merger_s_draw_tcost_allo_' num2str(id1) '_acquires_' num2str(id2)...           %
    '_' num2str(side) '.csv'];      
xlswrite(filename8,tcost_allo_mat);
end                                                                       %
%-------------------------------------------------------------------------%
