function all_plots()

% HELP: This function creates all the plots reported in the paper. For each
% plot it loads the corresponding data and generates the picture.

%% Figures 4 and 8 are not reported here as these correspond to data that we cannot make public

%% Figure 7: Estimated CDFs

clear
% find firm size in CH
dat4 = dlmread('firm_size_new.csv',',');
id = dat4(:,1);
firm_size_all = dat4(:,2);
bidders_CH = [4,5,19,27,6,15,29,24,23,8,16,9];

firm_size = find_firm_size_CH(id,firm_size_all,bidders_CH);
firm_size = firm_size/2600;
X = firm_size;

gamma = [-0.726240 14.593903];
% Tao
np=size(gamma,2); % number of parameters

% Compute only for firms that will be plotted
tao1  = exp(gamma*[1;X(1:np-1,1)]);
tao2  = exp(gamma*[1;X(1:np-1,2)]);
tao3  = exp(gamma*[1;X(1:np-1,3)]);
tao8  = exp(gamma*[1;X(1:np-1,8)]);
tao11  = exp(gamma*[1;X(1:np-1,11)]);

% Plot

K=20;

pd1=makedist('Poisson','lambda',tao1);
pd2=makedist('Poisson','lambda',tao2);
pd3=makedist('Poisson','lambda',tao3);
pd8=makedist('Poisson','lambda',tao8);
pd11=makedist('Poisson','lambda',tao11);

x = 0:1:K;

s1=pdf(pd1,x);
s2=pdf(pd2,x);
s3=pdf(pd3,x);
s8=pdf(pd8,x);
s11=pdf(pd11,x);

s1=s1./sum(s1);
s2=s2./sum(s2);
s3=s3./sum(s3);
s8=s8./sum(s8);
s11=s11./sum(s11);

figure;

plot(x,cumsum(s1),'Color',[0,0,0],'LineWidth',2)
ylim([0 1]);
hold on;
plot(x,cumsum(s8),'Color',[0,0,0]+0.1,'LineWidth',2)
hold on;
plot(x,cumsum(s11),'Color',[0,0,0]+0.3,'LineWidth',2)
hold on;
plot(x,cumsum(s2),'Color',[0,0,0]+0.5,'LineWidth',2)
hold on;
plot(x,cumsum(s3),'Color',[0,0,0]+0.7,'LineWidth',2)
hold on;

xlabel('Type','Interpreter','latex','FontSize',18)
ax = gca;
ax.XTick = 0:2:x(end);
ylabel('Cummulative probability','Interpreter','latex','FontSize',18)
grid('on')

hLegend =legend({'$11\%$','36\%','54\%','$80\%$','$100\%$'},'Interpreter','latex',...
    'Position',[0.78, 0.50, 0, 0],'box','off');
hlt = text(...
    'Parent', hLegend.DecorationContainer, ...
    'String', 'Size relative', ...
    'HorizontalAlignment', 'center', ...
    'VerticalAlignment', 'bottom', ...
    'Position', [0.38, 1.1, 0], ...
    'Units', 'normalized','Interpreter','latex');
hkt = text(...
    'Parent', hLegend.DecorationContainer, ...
    'String', 'to largest firm', ...
    'HorizontalAlignment', 'center', ...
    'VerticalAlignment', 'bottom', ...
    'Position', [0.45, 0.98, 0], ...
    'Units', 'normalized','Interpreter','latex');

set(gcf,'position',[255 1364 570 450])

print('-depsc','-tiff','-r300','fig7')
print('-dpng','-r300','fig7')
hold off

%% Figure profits (Online Appendix)

clear
Actual = [79; 45.3; 40.9; 39.3; 37; 16.2; 14.7; ...
    12.6; 8.1; 7.7; 5.9; 4.9];
% horizontal bar-plot
barpairs = [Actual,100-Actual]; % get paired values for perc-box and 100-perc-box
Labels = {'Reliant'; 'City of Bryan'; ...
    'Tenaska Gateway Partners' ;'TXU' ;'Calpine';...
    'Cogen Lyondell Corp' ;'Lamar Power Partners'; ...
    'City of Garland' ;'West Texas Utilities'; ...
    'Central Power and Light'; 'Guadalupe Power Partners'; ...
    'Tenaska Frontier Partners'};
BR3 = [98.5 100 99.6 96.7 97.9 100 99.6 99.6 100 98.7 99 99.3]';
% horizontal bar-plot
barpairs2 = [BR3,100-BR3]; % get paired values for perc-box and 100-perc-box

h = barh(barpairs,'stacked'); %multi-box "stacked" bar plot
set(h(1),'FaceColor',[0.7,0.8,1]); % set color of perc-box blue
set(h(2),'FaceColor',[1,1,1]); % set color of 100-perc-box white
set(gca,'yticklabel',Labels)

% print('-depsc','-tiff','-r300','actual_profits')
% print('-dpng','-r300','actual_profits')

h2 = barh([barpairs2],'stacked'); %multi-box "stacked" bar plot
set(h2(1),'FaceColor',[0.7,0.8,1]); % set color of perc-box blue
set(h2(2),'FaceColor',[1,1,1]); % set color of 100-perc-box white
set(gca,'yticklabel',Labels)
% print('-depsc','-tiff','-r300','figd1')
% print('-dpng','-r300','figd1')

%% Sample selection  (Online Appendix)

clear
% find firm size in CH
dat4 = dlmread('firm_size_new.csv',',');
params = dlmread('in_out2.csv',',');

id = dat4(:,1);
firm_size_all = dat4(:,2);
bidders_CH = [4,5,19,27,6,15,29,24,23,8,16,9];

firm_size = find_firm_size_CH(id,firm_size_all,bidders_CH);
firm_size = firm_size/2600;

X = firm_size;
Xmin = min(X);
Xmax = max(X);
gamma = [-0.726240 14.593903]; 

tao_s = exp(params(:,1) + Xmin*params(:,2));
tao_b = exp(params(:,1) + Xmax*params(:,2));

ET_s = zeros(length(params),1);
ET_l = zeros(length(params),1);

K=20;
x = 0:1:K;
for i=1:length(params)
    pd1=makedist('Poisson','lambda',tao_s(i));
    s1=pdf(pd1,x);
    s1=s1./sum(s1);
    ET_s(i) = sum(x.* s1);
end

for i=1:length(params)
    pd1b=makedist('Poisson','lambda',min(tao_b(i),80));
    s1b=pdf(pd1b,x);
    s1b=s1b./sum(s1b);
    ET_l(i) = sum(x.* s1b);
end

tao_sb  = exp(gamma*[1;min(X)]);
tao_bb  = exp(gamma*[1;max(X)]);

pd_sb=makedist('Poisson','lambda',tao_sb);
pd_bb=makedist('Poisson','lambda',tao_bb);

s1_sb=pdf(pd_sb,x);
s1_sb=s1_sb./sum(s1_sb);

s1_bb=pdf(pd_bb,x);
s1_bb=s1_bb./sum(s1_bb);

% CDF plot

% Create cummulative sum
aET_s = round(ET_s);
[as,bs] = hist(aET_s,unique(aET_s));
prob_s = as./sum(as);
cs = cumsum(prob_s);
cs(1,6:21) = 1;

aET_b = round(ET_l);
[ab,bb] = hist(aET_b,unique(aET_b));
prob_b = ab./sum(ab);
cb = cumsum(prob_b);

figure;
b11 = plot(x,cumsum(s1_sb),':','Color',[0,0,0]+0.3,'LineWidth',2);
hold on;
b12 = plot(x,cs,'d','Color',[0,0,0]+0.5,'LineWidth',2);
hold on;
b21 = plot(x,cumsum(s1_bb),'--','Color',[0,0,0]+0.3,'LineWidth',2);
hold on;
b22 = plot(x,cb,'X','Color',[0,0,0]+0.5,'LineWidth',2);
hold on;

xlabel('Type','Interpreter','latex','FontSize',18)
ax = gca;
ax.XTick = 0:2:x(end);
ylabel('Cummulative probability','Interpreter','latex','FontSize',18)
grid('on')

hLegend =legend({'Smallest firm, baseline estimates','Smallest firm, sample selection exercise','Largest firm, baseline estimates','Largest firm, sample selection exercise'},'Interpreter','latex',...
    'Position',[0.65, 0.25, 0, 0],'box','off');

set(gcf,'position',[255 1364 570 450])

% print('-depsc','-tiff','-r300','figf1')
% print('-dpng','-r300','figf1')
hold off

%% Learning  (Online Appendix)

clear
% find firm size in CH
dat4 = dlmread('firm_size_new.csv',',');
id = dat4(:,1);
firm_size_all = dat4(:,2);
bidders_CH = [4,5,19,27,6,15,29,24,23,8,16,9];

firm_size = find_firm_size_CH(id,firm_size_all,bidders_CH);
firm_size = firm_size/2600;

weekind = [
    36
    37
    38
    39
    40
    41
    42
    43
    44
    45
    46
    47
    48
    49
    50
    51
    52
    53
    54]';
week=weekind/max(weekind);

% Estimation with size and week
gamma = [-0.675	13.779	0.041];

taos = zeros(1,2);
taob = taos;

taos(1,1) = exp(gamma*[1;firm_size(1,1);week(1,1)]);
taos(1,2) = exp(gamma*[1;firm_size(1,1);week(1,end)]);

taob(1,1) = exp(gamma*[1;firm_size(1,3);week(1,1)]);
taob(1,2) = exp(gamma*[1;firm_size(1,3);week(1,end)]);    

K=20;
x = 0:1:K;

% Small firm

pd1s=makedist('Poisson','lambda',taos(1,1));
pd2s=makedist('Poisson','lambda',taos(1,2));

s1s=pdf(pd1s,x);
s2s=pdf(pd2s,x);

s1s=s1s./sum(s1s);
s2s=s2s./sum(s2s);

% big firm 

pd1b=makedist('Poisson','lambda',taob(1,1));
pd2b=makedist('Poisson','lambda',taob(1,2));

s1b=pdf(pd1b,x);
s1b=s1b./sum(s1b);

s2b=pdf(pd2b,x);
s2b=s2b./sum(s2b);

figure;

plot(x,cumsum(s1s),':','Color',[0,0,0]+0.3,'LineWidth',2)
ylim([0 1]);
hold on;
plot(x,cumsum(s2s),'d','Color',[0,0,0]+0.5,'LineWidth',2)
hold on;

plot(x,cumsum(s1b),'--','Color',[0,0,0]+0.3,'LineWidth',2)
ylim([0 1]);
hold on;
plot(x,cumsum(s2b),'X','Color',[0,0,0]+0.5,'LineWidth',2)
hold on;

xlabel('Type','Interpreter','latex','FontSize',18)
ax = gca;
ax.XTick = 0:2:x(end);
ylabel('Cummulative probability','Interpreter','latex','FontSize',18)
grid('on')

hLegend =legend({'Smallest firm, first week','Smallest firm, last week',...
    'Largest firm, first week','Largest firm, last week'},'Interpreter','latex',...
    'Position',[0.75, 0.50, 0, 0],'box','off');

set(gcf,'position',[255 1364 570 450])

%
% print('-depsc','-tiff','-r300','learning_cdf')
% print('-dpng','-r300','learning_cdf')
hold off

%% Different time slot  (Online Appendix)

clear
% find firm size in CH
dat4 = dlmread('../../Plots/firm_size_new.csv',',');
id = dat4(:,1);
firm_size_all = dat4(:,2);
bidders_CH = [4,5,19,27,6,15,29,24,23,8,16,9];

firm_size = find_firm_size_CH(id,firm_size_all,bidders_CH);
firm_size = firm_size/2600;
X = firm_size;

gamma = [-0.726240 14.593903];
gamma1 =  [-0.511057 14.519828];

K=20;
x = 0:1:K;
np = size(gamma,2);
% Construct cdf
tao1b  = exp(gamma*[1;X(1:np-1,1)]);
tao2b  = exp(gamma*[1;X(1:np-1,2)]);
tao3b  = exp(gamma*[1;X(1:np-1,3)]);
tao8b  = exp(gamma*[1;X(1:np-1,8)]);
tao11b  = exp(gamma*[1;X(1:np-1,11)]);

pd1b=makedist('Poisson','lambda',tao1b);
pd2b=makedist('Poisson','lambda',tao2b);
pd3b=makedist('Poisson','lambda',tao3b);
pd8b=makedist('Poisson','lambda',tao8b);
pd11b=makedist('Poisson','lambda',tao11b);

s1b=pdf(pd1b,x);
s2b=pdf(pd2b,x);
s3b=pdf(pd3b,x);
s8b=pdf(pd8b,x);
s11b=pdf(pd11b,x);

s1b=s1b./sum(s1b);
s2b=s2b./sum(s2b);
s3b=s3b./sum(s3b);
s8b=s8b./sum(s8b);
s11b=s11b./sum(s11b);

% H19
tao11  = exp(gamma1*[1;X(1:np-1,1)]);
tao21  = exp(gamma1*[1;X(1:np-1,2)]);
tao31  = exp(gamma1*[1;X(1:np-1,3)]);
tao81  = exp(gamma1*[1;X(1:np-1,8)]);
tao111  = exp(gamma1*[1;X(1:np-1,11)]);

pd11=makedist('Poisson','lambda',tao11);
pd21=makedist('Poisson','lambda',tao21);
pd31=makedist('Poisson','lambda',tao31);
pd81=makedist('Poisson','lambda',tao81);
pd111=makedist('Poisson','lambda',tao111);

s11=pdf(pd11,x);
s21=pdf(pd21,x);
s31=pdf(pd31,x);
s81=pdf(pd81,x);
s111=pdf(pd111,x);

s11=s11./sum(s11);
s21=s21./sum(s21);
s31=s31./sum(s31);
s81=s81./sum(s81);
s111=s111./sum(s111);


figure;

plot(x,cumsum(s1b),'Color','k','LineWidth',2)
ylim([0 1]);
hold on;
plot(x,cumsum(s11),'--','Color',[0,0,0]+0.6,'LineWidth',2)
hold on;
plot(x,cumsum(s8b),'Color','k','LineWidth',2)
hold on;
plot(x,cumsum(s81),'--','Color',[0,0,0]+0.6,'LineWidth',2)
hold on;
plot(x,cumsum(s2b),'Color','k','LineWidth',2)
hold on;
plot(x,cumsum(s21),'--','Color',[0,0,0]+0.6,'LineWidth',2)
hold on;
plot(x,cumsum(s3b),'Color','k','LineWidth',2)
hold on;
plot(x,cumsum(s31),'--','Color',[0,0,0]+0.6,'LineWidth',2)
hold on;


xlabel('Type','Interpreter','latex','FontSize',18)
ax = gca;
ax.XTick = 0:2:x(end);
ylabel('Cummulative probability','Interpreter','latex','FontSize',18)
grid('on')

hLegend =legend({'6pm', '7pm'},'Interpreter','latex',...
    'Position',[0.78, 0.50, 0, 0],'box','off');
hlt = text(...
    'Parent', hLegend.DecorationContainer, ...
    'String', 'Sample', ...
    'HorizontalAlignment', 'center', ...
    'VerticalAlignment', 'bottom', ...
    'Position', [0.38, 1, 0], ...
    'Units', 'normalized','Interpreter','latex');

set(gcf,'position',[255 1364 570 450])

% print('-depsc','-tiff','-r300','h19')
% print('-dpng','-r300','h19')
hold off

end
