## ======================================
## Figure 8: Trends in LA, the rest of CA, and Southern CA (dotted)
## in hospitalizations for foodborne and (non-foodborne) digestive
## system disorders from 1995-1999
## ======================================

  rm(list=ls())
  
  #Assume base R is running
  my.wd <- getSrcDirectory(function(x){x})
  
  #Check for errors
  if(grepl("error", tolower(class(my.wd)[1])) | my.wd==""){
    #Try to access working directory through R Studio API
    my.wd <- tryCatch(dirname(rstudioapi::getActiveDocumentContext()$path),
                      error = function(e) e)
    
  }
  
  #Set working directory
  setwd(my.wd)

  
## ==========================
## Read in data
## ==========================  
  
  #Hospitalizations
  hosp.cty.yr.1983.2009 <- read.csv("../Data/hosp_county_year_1983_2009.csv", stringsAsFactors = FALSE)
  
  #Population
  county.pop.1964.2015 <- read.csv("../Data/county_population_1964_2015.csv", stringsAsFactors = FALSE)
  
## ==========================
## Aggregate hospitalizations and population at zip5 level
## ==========================  

  #SoCal county names
  so.cal.names <- c("Imperial", "Kern", "Orange", "San Bernardino", "San Diego", "San Luis Obispo", "Santa Barbara",
                    "Riverside", "Ventura")
  
  #LA indicator
  hosp.cty.yr.1983.2009$la <- as.numeric(hosp.cty.yr.1983.2009$county.name=="Los Angeles")
  
  #Aggregate population LA vs non-LA
  la.pop <- aggregate(pop~year+ifelse(Name=="Los Angeles", 1, 0), data = county.pop.1964.2015, FUN = sum)
  names(la.pop)[2] <- "la"
  
  #Aggregate population LA vs SoCal
  socal.pop <- aggregate(pop~year, data = subset(county.pop.1964.2015, Name%in%so.cal.names), FUN = sum)
  
  #Aggregate fbi counts
  fbi.yearly <- aggregate(cbind(jl.codes.mdc6.filter, control.jl.codes.filter)~la+year,
                        data = hosp.cty.yr.1983.2009, subset=year%in%1995:1999,FUN = sum)
  socal.yearly <-  aggregate(cbind(jl.codes.mdc6.filter, control.jl.codes.filter)~year,
                             data = subset(hosp.cty.yr.1983.2009, county.name%in%so.cal.names), 
                             subset=year%in%1995:1999,FUN = sum)

  ## Merge population
  fbi.yearly <- merge(fbi.yearly, la.pop, by = c("la", "year"))
  fbi.yearly <- fbi.yearly[order(fbi.yearly$la),]
  socal.yearly <- merge(socal.yearly, socal.pop, by = "year")

  #Create rates
  fbi.yearly$fbi.rate <- (fbi.yearly$jl.codes.mdc6.filter/fbi.yearly$pop)*100000
  fbi.yearly$ctrl.rate <- (fbi.yearly$control.jl.codes.filter/fbi.yearly$pop)*100000
  socal.yearly$fbi.rate <-  (socal.yearly$jl.codes.mdc6.filter/socal.yearly$pop)*100000
  socal.yearly$ctrl.rate <-  (socal.yearly$control.jl.codes.filter/socal.yearly$pop)*100000
  
## ==========================
## Plots
## ========================== 
  
  par(mfrow = c(1,2), mar=c(3,3,2,1), mgp=c(1.5,0.5,0), tcl=-0.3)
  
  #Colors
  la.color <- rgb(1,0,0,0.8)
  ca.color <- rgb(0,0,1,0.8)
    
  #Plot foodborne
  plot(fbi.yearly$year[fbi.yearly$la==0], fbi.yearly$fbi.rate[fbi.yearly$la==0], 
       type = "n", 
       lty = 1,
       ylim = c(2.3,4.8),
       #ylim = c(2,7),
       col = ca.color,
       ylab = "Hospitalization rate", xlab = "Year",
      main = "Foodborne")

  abline(v=1997.5,col=rgb(0,0,0,0.4),lwd=0.5)

  lines(fbi.yearly$year[fbi.yearly$la==0], fbi.yearly$fbi.rate[fbi.yearly$la==0],
        col=rgb(0,0,1,0.8),lty=5)
  lines(fbi.yearly$year[fbi.yearly$la==1], fbi.yearly$fbi.rate[fbi.yearly$la==1], type = "l", lty = 1, col =rgb(1,0,0,0.8),lwd=1.5)
  lines(socal.yearly$year, socal.yearly$fbi.rate, type = "l", lty = 3, col=rgb(1,0,1,1),lwd=1.5)
  
  text(1998.3,4.6, "LA enacts\ngrading",cex=0.8,col=rgb(0,0,0,0.8))
    text(x = 1995.3, y = 4.15, label = "LA", cex = 0.8, col = "red")
    text(x = 1995.7, y = 3.1, label = "Southern CA", cex = 0.8, col = "purple")
    text(x = 1995.3, y = 2.4, label = "CA", cex = 0.8, col = "blue")


  #Plot nonfoodborne
  plot(fbi.yearly$year[fbi.yearly$la==0], fbi.yearly$ctrl.rate[fbi.yearly$la==0], 
       type = "n", 
       lty = 1,
       col = ca.color,
       ylim = c(570,660),
       #ylim = c(560,660),
       ylab = "Hospitalization rate", xlab = "Year",
       main = "Digestive System")

  abline(v=1997.5,col=rgb(0,0,0,0.4),lwd=0.5)
  lines(fbi.yearly$year[fbi.yearly$la==1], fbi.yearly$ctrl.rate[fbi.yearly$la==1],
        col=rgb(1,0,0,0.8),lwd=1.5)
  lines(fbi.yearly$year[fbi.yearly$la==0], fbi.yearly$ctrl.rate[fbi.yearly$la==0],
        lty=5, col = rgb(0,0,1,0.8))
  lines(socal.yearly$year, socal.yearly$ctrl.rate,
        lty=3, col=rgb(1,0,1,1))
