/* ============================================================================================================
	Name of file: 	Second - Harmonizing WKFRC.do
	
	Author: 		Adam Leive - leive@wharton.upenn.edu
					Michael Richards - michael.r.richards@vanderbilt.edu
					Sebastian Tello - daniel.s.tello@vanderbilt.edu				
					
	Project: 		Opiods
	
	Introduction:	This file Harmonizes the data across years that has been cleaned indepdently. 
	
	Last Edited: 	- TTA 12/18/2015 11:19 AM
	
	Files Used:		Raw data from FL Workforce		
				
	Files Created:  		
	
	============================================================================================================ */
	
	set more off 
	* ======================================================
					* Calling the directory.
	* ======================================================
	 di "Enter user name: adam,michael,sebastian, tello"
	 di "Enter word: " _request(user)

	while ("$user" != "adam" & "$user" != "michael" & "$user" != "sebastian" & "$user" != "tello")  {

	display ">>>>Not an acceptable responde. Please Try again<<<<"
	di "Enter user name: adam,michael,sebastian, tello"
	di "Enter word: " _request(user)

}

	else {

	if "$user" == "adam" {
	do ".../Dropbox/Florida Project/Dofiles/FL Directory.do"
	}
	
	if "$user" == "michael" {
	do "~/Dropbox/Vanderbilt/Research/Florida Project/Dofiles/FL Directory.do"
	}
	
	if "$user" == "sebastian" {
	do "C:/Users/Daniel/Dropbox/Florida Project/Dofiles/FL Directory.do"
	}
	
	if "$user" == "tello" {
	do "D:/Dropbox/Florida Project/Dofiles/FL Directory.do"
	}
	
	}
	
	
	* ======================================================
					* Data
	* ======================================================
	
	
	
	* Note that for the years 2013 and on, the coding of specialty is the questionnair
	* is very different form the previous years. However, it seem that in the coding
	* of the variable, it was using the same values as the old-coding
	* so I just use the old-code for all the years.
	* I see the percentage if people being neuro being somewhat the same
	* I think that's reassuring..
	
		* Getting Age
		 forvalues i=2006/2015 {
		 use "$wkfrc/WKFRC-`i'/lic.wkfrc-`i'.dta", clear
		 keep docid1 docid2 dob year sex
		  generate birthday=date(dob,"MDY")
		 format birthday  %d
		 generate age= int((mdy(1,1,`i') - birthday ) / 365.25)
		 tempfile age`i'
		 save `age`i''
		}
		
		* Getting Lic Number
		 forvalues i=2006/2015 {
		 use "$wkfrc/WKFRC-`i'/lic.wkfrc-`i'.dta", clear
		 keep docid1 docid2 doctype year licnum
		 tempfile lic`i'
		 save `lic`i''
		}

	
	use "$wkfrc/WKFRC-2006/survey.wkfrc-2006clean.dta", clear

	keep docid1 docid2 year workinfl howmany* counties* retire* spec*  

	tempfile d2006
	save `d2006'

	use "$wkfrc/WKFRC-2008/survey.wkfrc-2008clean.dta", clear

	keep docid1 docid2 year workinfl howmany* counties* retire* spec* change*  main*

	tempfile d2008
	save `d2008'

	use "$wkfrc/WKFRC-2009/survey.wkfrc-2009clean.dta", clear
		
	*rename whywhymovein5yrs whymovein5yrs
	keep docid1 docid2 year workinfl howmany* counties* retire* spec* change* new* whynotwork* timespent* main* move* whymove*

	tempfile d2009
	save `d2009'

	use "$wkfrc/WKFRC-2010/survey.wkfrc-2010clean.dta", clear

	keep docid1 docid2 year workinfl howmany* counties* retire* spec* change* new* whynotwork* timespent* main* move* whymove*

	tempfile d2010
	save `d2010'

	use "$wkfrc/WKFRC-2011/survey.wkfrc-2011clean.dta", clear

	keep docid1 docid2 year workinfl howmany* counties* retire* spec* change* new* whynotwork* timespent* main* move* whymove*

	tempfile d2011
	save `d2011'

	use "$wkfrc/WKFRC-2012/survey.wkfrc-2012clean.dta", clear

	keep docid1 docid2 year workinfl howmany* counties* retire* spec* change* new* whynotwork* timespent* main* move* whymove*

	tempfile d2012
	save `d2012'

	use "$wkfrc/WKFRC-2013/survey.wkfrc-2013clean.dta", clear

	keep docid1 docid2 year workinfl howmany* counties* retire* spec* change* new* whynotwork* timespent* main* move* whymove*

	tempfile d2013
	save `d2013'


	use "$wkfrc/WKFRC-2014/survey.wkfrc-2014clean.dta", clear
 
	keep docid1 docid2 year workinfl howmany* counties* retire* spec* change* new* whynotwork* timespent* main* move* whymove*

	tempfile d2014
	save `d2014'


	use "$wkfrc/WKFRC-2015/survey.wkfrc-2015clean.dta", clear

	keep docid1 docid2 year workinfl howmany* counties* retire* spec* change* new* whynotwork* timespent* main* move* whymove*

	tempfile d2015
	save `d2015'



	append using `d2006'
	append using `d2008'
	append using `d2009'
	append using `d2010'
	append using `d2011'
	append using `d2012'
	append using `d2013'
	append using `d2014'

	count
	forvalues i=2006/2015 {
	merge 1:1 docid1 docid2 year using `age`i'', update
	drop if _merge==2
	drop _merge
	}
	count

	count
	forvalues i=2006/2015 {
	merge 1:1 docid1 docid2 year using `lic`i'', update
	drop if _merge==2
	drop _merge
	}
	count

	
	* one age is 204 (we'll delete that)
	replace age = . if age==204
	
	* Sex Variable
	replace sex="0" if sex=="F"
	replace sex="1" if sex=="M"
	destring sex, replace
	label define sex 0 "Female" 1 "Male"
	label values sex sex
	label var sex "Sex"
	
	
	label var year "Year"
	label var docid1 "Dod ID 1"
	label var docid2 "Dod ID 2"
	
	/* Fixing the missing values in workinfl */
	replace workinfl=0 if whynotworkinfl10!=. & workinfl==.
	replace workinfl=0 if whynotworkinfl!=. & workinfl==.
	replace workinfl=1 if howmanymonths13!=. & workinfl==.
	label var workinfl "Work in FL Harmonized"
	* there are still some people who their workinfl variable is missing although they have some information. 
	* Not sure what to do with this people, I would drop them, but leave them here just in case. 
	
	* Harmonizing How Many Months
	gen 	howmanymonths1=howmanymonths
	replace howmanymonths1= 0 if  (howmanymonths09==1 | howmanymonths09==2) | (howmanymonths10==1 | howmanymonths10==2) | (howmanymonths13==1 | howmanymonths13==2) 
	replace howmanymonths1= 1 if  (howmanymonths09==3 | howmanymonths09==4) | (howmanymonths10==3 | howmanymonths10==4) | (howmanymonths13==3 | howmanymonths13==4) 
	replace howmanymonths1= 2 if  (howmanymonths09==5 | howmanymonths09==6) | (howmanymonths10==5 | howmanymonths10==6) | (howmanymonths13==5 | howmanymonths13==6) 
	label var howmanymonths1 "Months worked in FL Harmonized 06-15"
	
	gen 	howmanymonths2=howmanymonths09
	replace howmanymonths2=howmanymonths10 if howmanymonths2==.
	replace howmanymonths2=howmanymonths13 if howmanymonths2==.
	label var howmanymonths2 "Months worked in FL Harmonized 09-15"
	
	drop howmanymonths howmanymonths09 howmanymonths10 howmanymonths13
	
	label define q22009 ///
	1 "1-2 Months" ///
	2 "3-4 Months" ///
	3 "5-6 Months" ///
	4 "7-8 Month" ///
	5 "9-10 Months" ///
	6 "11-12 Months"
	label values howmanymonths2 q22009

	
	
	
	* Harmozing WhynotworkinFl *
	replace whynotworkinfl10 = 1 if whynotworkinfl==1
	replace whynotworkinfl10 = 3 if whynotworkinfl==2
	replace whynotworkinfl10 = 4 if whynotworkinfl==3
	replace whynotworkinfl10 = 6 if whynotworkinfl==4
	replace whynotworkinfl10 = 7 if whynotworkinfl==5
	replace whynotworkinfl10 = 8 if whynotworkinfl==6
	label var whynotworkinfl10 "Reasons not work in FL Harmonized 09-15 "
	drop whynotworkinfl
	
	* The issue here is that the options change within the three years, but not sure how to harmonize it other than that.
	
	label define whynotworkinfl10 ///
	1 "Retired" ///
	2 "Malpractice Insurance Rate" ///
	3 "Liability Exposure"  ///
	4 "Medicare/Medicaid Reimbursement Rates" ///
	5 "Private Health Plan Reimbursment Rates" ///
	6 "Planning to move to Florida" ///
	7 "Do not maintain a full-time residence in Florida" ///
	8 "Other"
	label values whynotworkinfl10 whynotworkinfl10

	
	
	order docid1 docid2 year workinfl howmanymonths* whynot*
	
	
	/* Code to Fix Specialties in This year */
	* hspecialty will have the 2nd, 3rd,.. etc specialty cleaned. No repeated. I dont delete the other variables
	* because there is information attached to those variables, as in if speicalty2=1  then the next question is about that specialty*

	clonevar temp1 = specialty_2ndloc
	clonevar temp2 = specialty_3ndloc

	replace specialty_2ndloc= . if specialty==specialty_2ndloc
	replace specialty_3ndloc= . if specialty==specialty_3ndloc

	gen hspecialty2 = specialty2
	gen hspecialty3 = specialty3

	replace hspecialty2=. if hspecialty2==specialty
	replace hspecialty3=. if hspecialty3==specialty
	replace specialty_3ndloc=. if specialty_2ndloc==specialty_3ndloc

	replace hspecialty2= hspecialty3 if hspecialty2==.
	replace hspecialty3 = . if hspecialty2==hspecialty3
	replace hspecialty2= specialty_2ndloc if hspecialty2==.
	replace specialty_2ndloc = . if hspecialty2==specialty_2ndloc
	replace hspecialty2= specialty_3ndloc if hspecialty2==.
	replace specialty_3ndloc= . if specialty_3ndloc==hspecialty2

	replace hspecialty3= specialty_2ndloc if hspecialty3==.
	replace specialty_2ndloc = . if specialty_2ndloc==hspecialty3
	replace hspecialty3= specialty_3ndloc if hspecialty3==.
	replace specialty_3ndloc = . if specialty_3ndloc==hspecialty3

	gen hspecialty4= specialty_2ndloc if specialty_2ndloc!=.
	replace specialty_2ndloc=. if specialty_2ndloc==hspecialty4
	replace hspecialty4= specialty_3ndloc if hspecialty4==.
	replace specialty_3ndloc=. if specialty_3ndloc==hspecialty4

	gen hspecialty5= specialty_3ndloc if specialty_3ndloc!=.

	drop specialty_3ndloc specialty_2ndloc
	ren temp1 specialty_2ndloc
	ren temp2 specialty_3ndloc
	
	/* Standarizing the Specialty Variables */

	gen 	spec_prim = specialtyx1 if year<=2012 
	replace spec_prim = specialty if year>=2013
	replace spec_prim = speciality if spec_prim==.
	replace spec_prim = speciality if spec_prim==0 
	

	gen 	spec_2 = specialtyx2 if year<=2009 
	replace spec_2= specialtyx21 if year>=2010 & year<=2012
	replace spec_2 = hspecialty2 if year>=2013
	

	gen 	spec_3 = specialtyx3 if year<=2009 
	replace spec_3= specialtyx22 if year>=2010 & year<=2012
	replace spec_3 = hspecialty3 if year>=2013
	
	gen 	spec_4 = specialtyx4 if year<=2009 
	replace spec_4 = specialtyx23 if year>=2010 & year<=2012
	replace spec_4 = hspecialty4 if year>=2013

	gen 	spec_5 = specialtyx5 if year<=2009 
	replace spec_5 = specialtyx24 if year>=2010 & year<=2012
	replace spec_5 = hspecialty5 if year>=2013

	gen 	spec_6 = specialtyx6 if year<=2009 
	replace spec_6 = specialtyx25 if year>=2010 & year<=2012
	label var spec_6 "Sixth Specialty Harmonized"
	*Not that for the last three years I don't have anyone who has more than 5 specialties mostly because even if they did, I couldn't know.
	
	* There are a non-trivial amount of observations that have spec_prim either 0, missing or 999. I'm going to convert them all to missing. 
	
	foreach var of varlist  speciality spec_prim spec_2 spec_3 spec_4 spec_5 spec_6  {
	replace `var' =. if `var'==0 | `var'==999
	}
	
	
	/* We clean the speciality for the years 2013 and on because
	it had a differnt coding than the previous years. Now there is an issue with the first question, so there are two main questions about
	speciality, one is what is you primary specialty and th other one iswhat is your specialty at your primary location. I've decided
	that your primary specialty is going to be what you report to be your primary specialty (which is usually the same as the one you practice on you prumary location) however this leads to an issue 
	that spec_prim now needs to be moves as the second specialty and so on.. and also, if the reported primary specialty is the same as say.. the 4th specialty, then i need to re-adjust to specialtyies are not repeated, anyways, they following code fixes that issue */
 
	gen flag=1 if speciality!=spec_prim & (speciality!=.& speciality!=0)

	replace speciality=spec_prim if speciality==. | speciality==0

	replace spec_prim=. if spec_prim ==speciality

	replace spec_prim=spec_2 if spec_prim==.
	replace spec_2=. if spec_prim==spec_2
	replace spec_2=spec_3 if spec_2==.
	replace spec_3=. if spec_3==spec_2
	replace spec_3=spec_4 if spec_3==.
	replace spec_4=. if spec_4==spec_3
	replace spec_4=spec_5 if spec_4==.
	replace spec_5=. if spec_5==spec_4
	replace spec_5=spec_6 if spec_5==.
	replace spec_6=. if spec_5==spec_6

	replace spec_prim=. if speciality==spec_prim
	replace spec_2=. if speciality==spec_2
	replace spec_3=. if speciality==spec_3
	replace spec_4=. if speciality==spec_4
	replace spec_5=. if speciality==spec_5
	replace spec_6=. if speciality==spec_6

	replace spec_2=spec_3 if spec_2==.
	replace spec_3=. if spec_3==spec_2
	replace spec_3=spec_4 if spec_3==.
	replace spec_4=. if spec_4==spec_3
	replace spec_4=spec_5 if spec_4==.
	replace spec_5=. if spec_5==spec_4
	replace spec_5=spec_6 if spec_5==.
	replace spec_6=. if spec_5==spec_6

	 
	replace speciality=spec_prim if speciality==. 
	replace spec_prim=. if spec_prim==speciality
	replace spec_prim=spec_2 if spec_prim==.
	replace spec_2=. if spec_prim==spec_2
	replace spec_2=spec_3 if spec_2==.
	replace spec_3=. if spec_3==spec_2
	replace spec_3=spec_4 if spec_3==.
	replace spec_4=. if spec_4==spec_3
	replace spec_4=spec_5 if spec_4==.
	replace spec_5=. if spec_5==spec_4
	replace spec_5=spec_6 if spec_5==.
	replace spec_6=. if spec_5==spec_6
	
	ren spec_6 spec_7
	ren spec_5 spec_6
	ren spec_4 spec_5
	ren spec_3 spec_4
	ren spec_2 spec_3
	ren spec_prim spec_2
	ren speciality spec_prim
	label var spec_prim "Primary Specialty Harmonized"
	label var spec_2 "Secondary Specialty Harmonized"
	label var spec_3 "Third Specialty Harmonized"
	label var spec_4 "Fourth Specialty Harmonized"
	label var spec_5 "Fifth Specialty Harmonized"
	label var spec_6 "Sixth Specialty Harmonized"
	label var spec_7 "Seventh Specialty Harmonized"

	gen 	retire = 1 if whynotworkinfl10==1
	replace retire = 0 if whynotworkinfl10!=1 &  whynotworkinfl10!=. & workinfl!=.
	replace retire = 0 if workinfl==1
	label var retire "Retired"
	
	* There are other Timespent patients variables
	label values timespent1 timespent
	label values timespent2 timespent
	label values timespent3 timespent
	
	clonevar timespent1_c= timespent1
	replace timespent1 =1  if timespent1>=0 & timespent1<=5 & year>=2013 & timespent1!=.
	replace timespent1 =2  if timespent1>=6 & timespent1<=10 & year>=2013 & timespent1!=.
	replace timespent1 =3  if timespent1>=11 & timespent1<=15 & year>=2013 & timespent1!=.
	replace timespent1 =4  if timespent1>=16 & timespent1<=20 & year>=2013 & timespent1!=.
	replace timespent1 =5  if timespent1>=21 & timespent1<=25 & year>=2013 & timespent1!=.
	replace timespent1 =6  if timespent1>=26 & timespent1<=30 & year>=2013 & timespent1!=.
	replace timespent1 =7  if timespent1>=31 & timespent1<=35 & year>=2013 & timespent1!=.
	replace timespent1 =8  if timespent1>=36 & timespent1<=40 & year>=2013 & timespent1!=.
	replace timespent1 =9  if timespent1>=41 & timespent1<=45 & year>=2013 & timespent1!=.
	replace timespent1 =10 if timespent1>=46 & timespent1<=50 & year>=2013 & timespent1!=.
	replace timespent1 =11 if timespent1>=51 & timespent1<=54 & year>=2013 & timespent1!=.
	replace timespent1 =12 if timespent1>=55 & timespent1<=60 & year>=2013 & timespent1!=.
	replace timespent1 =13 if timespent1>=61 & timespent1!=. & year>=2013
	
	label var timespent1_c  "Time Spent in Patient Care for 2013-2015"
	
	clonevar timespent2_c= timespent2
	replace timespent2 =1  if timespent2>=0 & timespent2<=5 & year>=2013 & timespent2!=.
	replace timespent2 =2  if timespent2>=6 & timespent2<=10 & year>=2013 & timespent2!=.
	replace timespent2 =3  if timespent2>=11 & timespent2<=15 & year>=2013 & timespent2!=.
	replace timespent2 =4  if timespent2>=16 & timespent2<=20 & year>=2013 & timespent2!=.
	replace timespent2 =5  if timespent2>=21 & timespent2<=25 & year>=2013 & timespent2!=.
	replace timespent2 =6  if timespent2>=26 & timespent2<=30 & year>=2013 & timespent2!=.
	replace timespent2 =7  if timespent2>=31 & timespent2<=35 & year>=2013 & timespent2!=.
	replace timespent2 =8  if timespent2>=36 & timespent2<=40 & year>=2013 & timespent2!=.
	replace timespent2 =9  if timespent2>=41 & timespent2<=45 & year>=2013 & timespent2!=.
	replace timespent2 =10 if timespent2>=46 & timespent2<=50 & year>=2013 & timespent2!=.
	replace timespent2 =11 if timespent2>=51 & timespent2<=54 & year>=2013 & timespent2!=.
	replace timespent2 =12 if timespent2>=55 & timespent2<=60 & year>=2013 & timespent2!=.
	replace timespent2 =13 if timespent2>=61 & timespent2!=. & year>=2013
	
	label var timespent2_c  "Time Spent in Administrative Matter for 2013-2015"
	
	clonevar timespent3_c= timespent3
	replace timespent3 =1  if timespent3>=0 & timespent3<=5 & year>=2013 & timespent3!=.
	replace timespent3 =2  if timespent3>=6 & timespent3<=10 & year>=2013 & timespent3!=.
	replace timespent3 =3  if timespent3>=11 & timespent3<=15 & year>=2013 & timespent3!=.
	replace timespent3 =4  if timespent3>=16 & timespent3<=20 & year>=2013 & timespent3!=.
	replace timespent3 =5  if timespent3>=21 & timespent3<=25 & year>=2013 & timespent3!=.
	replace timespent3 =6  if timespent3>=26 & timespent3<=30 & year>=2013 & timespent3!=.
	replace timespent3 =7  if timespent3>=31 & timespent3<=35 & year>=2013 & timespent3!=.
	replace timespent3 =8  if timespent3>=36 & timespent3<=40 & year>=2013 & timespent3!=.
	replace timespent3 =9  if timespent3>=41 & timespent3<=45 & year>=2013 & timespent3!=.
	replace timespent3 =10 if timespent3>=46 & timespent3<=50 & year>=2013 & timespent3!=.
	replace timespent3 =11 if timespent3>=51 & timespent3<=54 & year>=2013 & timespent3!=.
	replace timespent3 =12 if timespent3>=55 & timespent3<=60 & year>=2013 & timespent3!=.
	replace timespent3 =13 if timespent3>=61 & timespent3!=. & year>=2013
	
	label var timespent3_c  "Time Spent in Research and Teaching for 2013-2015"
	
	 
	label var timespent1 "Time Spent in Patient Care Harmonized"
	label var timespent2 "Time Spent in Administrative Matters Harmonized"
	label var timespent3 "Time Spent in Research and Teaching Harmonized"

	* There are other howmany patients variables
	/* label define howmanypatients ///
	1 "0-25" ///
	2 "26-50" ///
	3 "51-75" ///
	4 "76-100" ///
	5 "101-125" ///
	6 "126-150" ///
	7 "151-175" ///
	8 "176-200" ///
	9 "201 or more"  */
	label values howmanypatients howmanypatients
	clonevar howmanypatients13 = howmanypatients
	replace howmanypatients = 1 if howmanypatients>=0 & howmanypatients<=25 & howmanypatients!=. & year>=2013
	replace howmanypatients = 2 if howmanypatients>=26 & howmanypatients<=50 & howmanypatients!=. & year>=2013
	replace howmanypatients = 3 if howmanypatients>=51 & howmanypatients<=75 & howmanypatients!=. & year>=2013
	replace howmanypatients = 4 if howmanypatients>=76 & howmanypatients<=100 & howmanypatients!=. & year>=2013
	replace howmanypatients = 5 if howmanypatients>=101 & howmanypatients<=125 & howmanypatients!=. & year>=2013
	replace howmanypatients = 6 if howmanypatients>=126 & howmanypatients<=150 & howmanypatients!=. & year>=2013
	replace howmanypatients = 7 if howmanypatients>=151 & howmanypatients<=175 & howmanypatients!=. & year>=2013
	replace howmanypatients = 8 if howmanypatients>=176 & howmanypatients<=200 & howmanypatients!=. & year>=2013
	replace howmanypatients = 9 if howmanypatients>=201  & howmanypatients!=. & year>=2013

	label var howmanypatients "How many patients per week Prim Location Harmonized 09-15"
	
	label define mainpractice10 ///
	1 "Office Practice - Solo Practice" ///
	2 "Office Practice - Group Practice - Single Specialty" ///
	3 "Office Practice - Group Practice - Multi-Specialty" ///
	4 "Federally Qualified Community Health Center" ///
	5 "Nursing Home / Extended Care Facility" /// 
	6 "Volunteer Free Clinic" ///
	7 "Hospital - Hospital Based Physician (Non-Emergency)" ///
	8 "Hospital - Other" ///
	10 "County Health Department" ///
	11 "Urgent Care Center"  ///
	12 "Ambulatory Surgery Center" ///
	13 "Hospital Emergency Room" ///
	14 "Hospital - Outpatient Dept" ///
	15 "Hospital - Hospitalist" ///
	16 "Other" ///
	17 "Medical School or Parent University"
	
	label values mainpractice10 mainpractice10
	* There are other mainpractice variables for 2008 and 2009 here I clean it.
	* Basically the mainpractice09 variable has the option to input
	*  medical school or univesity that the newer variable doesn't have.
	
	
	replace mainpractice10 = 1 if mainpractice09==1 & year==2009
	replace mainpractice10 = 2 if mainpractice09==2 & year==2009
	replace mainpractice10 = 3 if mainpractice09==3 & year==2009
	replace mainpractice10 = 4 if mainpractice09==4 & year==2009
	replace mainpractice10 = 5 if mainpractice09==5 & year==2009
	replace mainpractice10 = 17 if mainpractice09==6 & year==2009
	replace mainpractice10 = 7 if mainpractice09==7 & year==2009
	replace mainpractice10 = 8 if mainpractice09==8 & year==2009
	replace mainpractice10 = 6 if mainpractice09==9 & year==2009
	replace mainpractice10 = 10 if mainpractice09==10 & year==2009
	replace mainpractice10 = 11 if mainpractice09==11 & year==2009
	replace mainpractice10 = 12 if mainpractice09==12 & year==2009
	replace mainpractice10 = 13 if mainpractice09==13 & year==2009
	replace mainpractice10 = 14 if mainpractice09==14 & year==2009
	replace mainpractice10 = 15 if mainpractice09==15 & year==2009
	replace mainpractice10 = 16 if mainpractice09==16 & year==2009
	
	* mainpractice we are renaming  because the values are very different from the 2009 onwards and it only affects 2008
	ren mainpractice mainpractice08
		
	drop		 mainpractice09
	label var mainpractice10 "Majority of Practice occurs in"
	


	gen 	mainpracgroup = 1 if mainpractice10>=1 & mainpractice10<=3 & mainpractice10!=. 
	replace mainpracgroup = 2 if mainpractice10==7 | mainpractice10==8 | mainpractice10==13 | mainpractice10==14 | mainpractice10==15 | mainpractice10==16
	replace mainpracgroup = 3 if (mainpractice10>=4 & mainpractice10<=6 & mainpractice10!=.) |  mainpractice10==10 | mainpractice10==11 | mainpractice10==12 | mainpractice10==16
	
	label var mainpracgroup "Majority of Practice Summarized Harmonized"
	label define mainpracgroup 1 "Office Solo" 2 "Hospitals" 3 "Others"
	label values mainpracgroup mainpracgroup

	tab  retirewhy retireish, m
	replace retirewhy=. if retireish==. | retireish==0 
	gen retirewhy2 = retirewhy
	replace retirewhy2 = 0 if retireish==0
	label var retirewhy2 "Reasons for Retirement Harmonized"
	label define retirewhy2 ///
	0 "Not retired" ///
	1 "Time to retire" ///
	2 "Family" /// 
	3 "Compensation" ///
	4 "Malpractice Insurance Rates" ///
	5 "Liability Exposure" ///
	6 "Medicare/Medicaid Reimbursement Rates" ///
	7 "Private Health Plan Reimbursement Rates" ///
	8 "Other" 
	drop retirewhy
	ren retirewhy2 retirewhy
	label values retirewhy retirewhy2
	
	gen 	agegrp1=1 if age>=0 & age<=29 & age!=.
	replace agegrp1=2 if age>=30 & age<=39 & age!=.
	replace agegrp1=3 if age>=40 & age<=49 & age!=.
	replace agegrp1=4 if age>=50 & age<=59 & age!=.
	replace agegrp1=5 if age>=60 & age<=69 & age!=.
	replace agegrp1=6 if age>=70  & age!=.
	
	label var agegrp1 "Age Groups (6)"
	label define agegrp1 1 "0-29" 2 "30-39" 3 "40-49" 4 "50-59" 5 "60-69" 6 "70+"
	label values agegrp1 agegrp1

	gen 	agegrp2=1 if age>=0 & age<=30 & age!=.
	replace agegrp2=2 if age>=40 & age<=60 & age!=.
	replace agegrp2=3 if age>=60 & age!=.
	
	label var agegrp2 "Age Groups (3)"
	label define agegrp2 1 "0-30" 2 "40-60" 3 "60+"
	label values agegrp2 agegrp2
	
	
	gen double uniqueid = docid1*1000000+docid2 
	xtset uniqueid year
	bys uniqueid: egen minyear=min(year)
	
	
	/* ==== Create your specialty dummies  ======== */
	
	gen anypainmed1 = .
	replace anypainmed1 =1 if ///
	spec_prim==48  | ///
	spec_prim==181 | ///
	spec_prim==530 | ///
	spec_prim==341 | ///
	spec_prim==402 | ///
	spec_prim==463 
	replace anypainmed1 =0 if (anypainmed1==. & spec_prim!=.) 
	
	label var anypainmed1 "Primary Specialty: Any Pain Med"

	gen painmed1 = . if anypainmed1==.
	replace	painmed1=1 if spec_prim==530  
	replace painmed1=0 if (painmed1==. & spec_prim!=.) 
	label var painmed1 "Primary Specialty: Pain Medicine (530)"
	
	gen oripainmed1= painmed1 if minyear==year
	bys uniqueid: egen oripainmed12=mean(oripainmed1)
	drop oripainmed1
	ren oripainmed12 oripainmed1
	label var oripainmed1 "Primary Specialty: Pain Med - First Appearance"
	
	gen orianypainmed1= anypainmed1 if minyear==year
	bys uniqueid: egen orianypainmed12=mean(orianypainmed1)
	drop orianypainmed1
	ren orianypainmed12 orianypainmed1
	label var oripainmed1 "Primary Specialty: Any Pain Med - First Appearance"
	
	
	gen anypainmed2 = .
	replace anypainmed2 =1 if ///
	spec_prim==48  | ///
	spec_prim==181 | ///
	spec_prim==530 | ///
	spec_prim==341 | ///
	spec_prim==402 | ///
	spec_prim==463 | ///	
	spec_2==48  | ///
	spec_2==181 | ///
	spec_2==530 | ///
	spec_2==341 | ///
	spec_2==402 | ///
	spec_2==463 | ///	
	spec_3==48  | ///
	spec_3==181 | ///
	spec_3==530 | ///
	spec_3==341 | ///
	spec_3==402 | ///
	spec_3==463 | ///	
	spec_4==48  | ///
	spec_4==181 | ///
	spec_4==530 | ///
	spec_4==341 | ///
	spec_4==402 | ///
	spec_4==463 | ///	
	spec_5==48  | ///
	spec_5==181 | ///
	spec_5==530 | ///
	spec_5==341 | ///
	spec_5==402 | ///
	spec_5==463 | ///	
	spec_6==48  | ///
	spec_6==181 | ///
	spec_6==530 | ///
	spec_6==341 | ///
	spec_6==402 | ///
	spec_6==463 | ///
	spec_7==48  | ///
	spec_7==181 | ///
	spec_7==530 | ///
	spec_7==341 | ///
	spec_7==402 | ///
	spec_7==463 	
	replace anypainmed2 =0 if (anypainmed2==. & spec_prim!=.) 
	
	label var anypainmed2 "Any Specialty: Any Pain Med"

	gen painmed2 = . if anypainmed2==.
	replace	painmed2=1 if spec_prim==530 | ///
	spec_2==530 | ///
	spec_3==530 | ///
	spec_4==530 | ///
	spec_5==530 | ///
	spec_6==530 | ///
	spec_7==530 
	replace painmed2=0 if (painmed2==. & spec_prim!=.) 
	label var painmed2 "Any Specialty: Pain Medicine"
	
		
	gen oripainmed2= painmed2 if minyear==year
	bys uniqueid: egen oripainmed22=mean(oripainmed2)
	drop oripainmed2
	ren oripainmed22 oripainmed22
	label var oripainmed2 "Any Specialty: Pain Med - First Appearance"
	
	gen orianypainmed2= anypainmed2 if minyear==year
	bys uniqueid: egen orianypainmed22=mean(orianypainmed2)
	drop orianypainmed2
	ren orianypainmed22 orianypainmed2
	label var oripainmed2 "Any Specialty: Any Pain Med - First Appearance"
	
	
	* ======== Neuro Specialty =================
	* Note that for the years 2013 and on, the coding of specialty is the questionnair
	* is very different form the previous years. However, it seem that in the coding
	* of the variable, it was using the same values as the old-coding
	* so I just use the old-code for all the years.
	* I see the percentage if people being neuro being somewhat the same
	* I think that's reassuring..

		gen neuro1  = .
		replace neuro1 =1 if ///
		spec_prim==160  |  ///
		spec_prim==180  |  ///
		spec_prim==185  |  ///
		spec_prim==187  |  ///
		spec_prim==183  |  ///
		spec_prim==186  |  ///
		spec_prim==181  | ///
		spec_prim==188   
		replace neuro1 =0 if (neuro1==. & spec_prim!=.) 

		label var neuro1 "Primary Specialty Neuro"

		gen neuro2  = .
		replace neuro2 =1 if ///
		spec_prim==160  |  ///
		spec_prim==180  |  ///
		spec_prim==185  |  ///
		spec_prim==187  |  ///
		spec_prim==183  |  ///
		spec_prim==186  |  ///
		spec_prim==181  | ///
		spec_prim==188  | /// 
		spec_2==160  |  ///
		spec_2==180  |  ///
		spec_2==185  |  ///
		spec_2==187  |  ///
		spec_2==183  |  ///
		spec_2==186  |  ///
		spec_2==181  | ///
		spec_2==188  | ///
		spec_3==160  |  ///
		spec_3==180  |  ///
		spec_3==185  |  ///
		spec_3==187  |  ///
		spec_3==183  |  ///
		spec_3==186  |  ///
		spec_3==181  | ///
		spec_3==188  | ///   
		spec_4==160  |  ///
		spec_4==180  |  ///
		spec_4==185  |  ///
		spec_4==187  |  ///
		spec_4==183  |  ///
		spec_4==186  |  ///
		spec_4==181  | ///
		spec_4==188  | ///  
		spec_5==160  |  ///
		spec_5==180  |  ///
		spec_5==185  |  ///
		spec_5==187  |  ///
		spec_5==183  |  ///
		spec_5==186  |  ///
		spec_5==181  | ///
		spec_5==188  | /// 
		spec_6==160  |  ///
		spec_6==180  |  ///
		spec_6==185  |  ///
		spec_6==187  |  ///
		spec_6==183  |  ///
		spec_6==186  |  ///
		spec_6==181  | ///
		spec_6==188  | ///  
		spec_7==160  |  ///
		spec_7==180  |  ///
		spec_7==185  |  ///
		spec_7==187  |  ///
		spec_7==183  |  ///
		spec_7==186  |  ///
		spec_7==181  | ///
		spec_7==188 
		replace neuro2 =0 if (neuro2==. & spec_prim!=.) 
		label var neuro2 "Any Specialty Neuro"
		
		
	gen orineuro1= neuro1 if minyear==year
	bys uniqueid: egen orineuro12=mean(orineuro1)
	drop orineuro1
	ren orineuro12 orineuro1
	label var orineuro1 "Prim Specialty: Neuro - First Appearance"
	
	gen orineuro2= neuro2 if minyear==year
	bys uniqueid: egen orineuro22=mean(orineuro2)
	drop orineuro2
	ren orineuro22 orineuro2
	label var orineuro2 "Any Specialty: Neuro - First Appearance"

	/* Counties Cleaning */
	replace counties = countiesx1 if year<=2012
	replace counties2=countiesx2 if year<=2009
	replace counties2=countiesx21 if year>=2010 & year<=2012
	
	replace counties3=countiesx3 if year<=2009
	replace counties3=countiesx22 if year>=2010 & year<=2012
	
	replace countiesx4=countiesx23 if year>=2010 & year<=2012
	replace countiesx5=countiesx24 if year>=2010 & year<=2012
	replace countiesx6=countiesx25 if year>=2010 & year<=2012

	drop countiesx1  countiesx2 countiesx3  countiesx2*  
	
	ren counties counties1
	ren countiesx4 counties4
	ren countiesx5 counties5
	ren countiesx6 counties6 
	label var  counties4 "Fourth County"
	label var  counties5 "Fifth County"
	label var  counties6 "Sixth County"
	label values counties1 countyfl
	label values counties2 countyfl
	label values counties3 countyfl
	
	label define spec ///
	20 "ALLERGY AND IMMUNOLOGY" ///
	40 "ANESTHESIOLOGY" ///
	41 "ANES: ADULT CARDIOTHORACIC ANESTHESIOLOGY" ///
	45 "ANES:CRITICAL CARE MEDICINE" ///
	48 "ANES: PAIN MEDICINE" ///
	42 "ANES: PEDIATRIC ANESTHESIOLOGY" ///
	43 "ANES: HOSPICE AND PALLIATIVE MEDICINE" ///
	60 "COLON AND RECTAL SURGERY" ///
	80 "DERMATOLOGY" ///
	100 "DERM: DERMATOPATHOLOGY" ///
	81 "DERM: PROCEDURAL DERMATOLOGY" ///
	82 "DERM: PEDIATRIC DERMATOLOGY" ///
	110 "EMERGENCY MEDICINE" ///
	111 "EMER: HOSPICE AND PALLIATIVE MEDICINE" ///
	112 "EMER: MEDICAL TOXICOLOGY" ///
	113 "EMER: PEDIATRIC EMERGENCY MEDICINE" ///
	114 "EMER: SPORTS MEDICINE" ///
	115 "EMER: UNDERSEA AND HYPERBARIC MEDICINE" ///
	120 "FAMILY MEDICINE" ///
	125 "FM: GERIATRIC MEDICINE" ///
	127 "FM:SPORTS MEDICINE" ///
	128 "FM:SLEEP MEDICINE" ///
	129 "FM:HOSPICE AND PALLIATIVE MEDICINE" ///
	130 "FM:ADOLESCENT MEDICINE" ///
	140 "INTERNAL MEDICINE" ///
	141 "IM: CARDIOVASCULAR DISEASE" ///
	154 "IM:CLINICAL CARDIAC ELECTROPHYSIOLOGY" ///
	142 "IM:CRITICAL CARE MEDICINE" ///
	143 "IM:ENDOCRINOLOGY, DIABETES, AND METABOLISM" ///
	144 "IM:GASTROENTEROLOGY" ///
	151 "IM:GERIATRIC MEDICINE" ///
	145 "IM:HEMATOLOGY" ///
	155 "IM:HEMATOLOGY AND ONCOLOGY" ///
	146 "IM:INFECTIOUS DISEASE" ///
	152 "IM:INTERVENTIONAL CARDIOLOGY" ///
	148 "IM:NEPHROLOGY" ///
	147 "IM:ONCOLOGY" ///
	149 "IM:PULMONARY DISEASE" ///
	156 "IM:PULMONARY DISEASE AND CRITICAL CARE MEDICINE" ///
	150 "IM:RHEUMATOLOGY" ///
	157 "IM:SPORTS MEDICINE" ///
	158 "IM:TRANSPLANT HEPATOLOGY" ///
	520 "IM:SLEEP MEDICINE" ///
	153 "IM:ADOLESCENT MEDICINE" ///
	159 "IM:HOSPICE AND PALLIATIVE MEDICINE" ///
	521 "IM:MEDICAL ONCOLOGY" ///
	130 "MEDICAL GENETICS" ///
	190 "MG: MOLECULAR GENETIC PATHOLOGY" ///
	191 "MG:MEDICAL BIOCHEMICAL GENETICS" ///
	160 "NEUROLOGICAL SURGERY" ///
	163 "ENDOVASCULAR SURGICAL" ///
	180 "NEUROLOGY" ///
	185 "NEURO: CHILD NEUROLOGY" ///
	187 "NEURO:CLINICAL NEUROPHYSIOLOGY" ///
	183 "NEURO:NEUROMUSCULAR MEDICINE" ///
	186 "NEURO:NEURODEVELOPMENTAL DISABILITIES" ///
	181 "NEURO:PAIN MEDICINE" ///
	188 "NEURO:VASCULAR NEUROLOGY" ///
	200 "NUCLEAR MEDICINE" ///
	220 "OBSTETRICS AND GYNECOLOGY" ///
	221 "OBS: CRITICAL CARE MEDICINE" ///
	222 "OBS:GYNECOLOGIC ONCOLOGY" ///
	223 "OBS:HOSPICE AND PALLIATIVE MEDICINE" ///
	224 "OBS:MATERNAL AND FETAL MEDICINE" ///
	225 "OBS:REPRODUCTIVE ENDOCRINOLOGY/INFERTILITY" ///
	240 "OPHTHALMOLOGY" ///
	260 "ORTHOPAEDIC SURGERY" ///
	261 "ORTHO: ADULT RECONSTRUCTIVE ORTHOPAEDICS" ///
	262 "ORTHO:FOOT AND ANKLE ORTHOPAEDICS" ///
	263 "ORTHO:HAND SURGERY" ///
	270 "ORTHO:MUSCULOSKELETAL ONCOLOGY" ///
	268 "ORTHO:ORTHOPAEDIC SPORTS MEDICINE" ///
	267 "ORTHO:ORTHOPAEDIC SURGERY OF THE SPINE" ///
	269 "ORTHO: ORTHOPAEDIC TRAUMA" ///
	265 "ORTHO: PEDIATRIC ORTHOPAEDICS" ///
	280 "OTOLARYNGOLOGY" ///
	286 "OTO: NEUROTOLOGY" ///
	287 "OTO:PLASTIC SURGERY WITHIN THE HEAD AND	NECK" ///
	289 "OTO:SLEEP MEDICINE" ///
	288 "OTO:PEDIATRIC OTOLARYNGOLOGY" ///
	530 "PAIN MEDICINE" ///
	300 "PATHOLOGY-ANATOMIC AND CLINICAL" ///
	305 "PAT: BLOOD BANKING/TRANSFUSION MEDICINE" ///
	306 "PAT:CHEMICAL PATHOLOGY" ///
	307 "PAT:CYTOPATHOLOGY" ///
	310 "PAT:FORENSIC PATHOLOGY" ///
	311 "PAT:HERMATOLOGY" ///
	314 "PAT:MEDICAL MICROBIOLOGY" ///
	315 "PAT:NEUROPATHOLOGY" ///
	316 "PAT:PEDIATRIC PATHOLOGY" ///
	301 "PAT:SURGICAL(SELECTIVE) PATHOLOGY" ///
	317 "PAT:DERMATOPATHOLOGY" ///
	318 "PAT:MOLECULAR GENETIC PATHOLOGY" ///
	320 "PEDIATRICS" ///
	321 "PED: ADOLESCENT MEDICINE" ///
	329 "PED: NEONATAL-PERINATAL MEDICINE" ///
	325 "PED: PEDIATRIC CARDIOLOGY" ///
	323 "PED: PEDIATRIC CRITICAL CARE MEDICINE" ///
	324 "PED: PEDIATRIC EMERGENCY MEDICINE" ///
	326 "PED: PEDIATRIC ENDOCRINOLOGY" ///
	332 "PED: PEDIATRIC GASTROENTEROLOGY" ///
	327 "PED: PEDIATRIC HEMATOLOGY/ONCOLOGY" ///
	335 "PED: PEDIATRIC INFECTIOUS DISEASES" ///
	328 "PED: PEDIATRIC NEPHROLOGY" ///
	330 "PED: PEDIATRIC PULMONOLOGY" ///
	331 "PED: PEDIATRIC RHEUMATOLOGY" ///
	333 "PED: PEDIATRIC SPORTS MEDICINE" ///
	336 "PED: DEVELOPMENTAL- BEHAVIORAL PEDIATRICS" ///
	337 "PED: CHILD ABUSE PEDIATRICS" ///
	338 "PED: HOSPICE AND PALLIATIVE MEDICINE" ///
	339 "PED: MEDICAL TOXICOLOGY" ///
	334 "PED: NEURODEVELOPMENTAL DISABILITIES" ///
	522 "PED: SLEEP MEDICINE" ///
	523 "PED: PEDIATRIC TRANSPLANT HEPATOLOGY" ///
	340 "PMED: PHYSICAL MEDICINE AND REHABILITATION" ///
	341 "PMED: PAIN MEDICINE" ///
	346 "PMED: PEDIATRIC REHABILITATION" ///
	345 "PMED: SPINAL CORD INJURY MEDICINE" ///
	347 "PMED: HOSPICE AND PALLIATIVE MEDICINE" ///
	348 "PMED: NEUROMUSCULAR MEDICINE" ///
	349 "PMED: SPORTS MEDICINE" ///
	360 "PLASTIC SURGERY" ///
	361 "PSUR: CRANIOFACIAL SURGERY" ///
	363 "PSUR:HAND SURGERY" ///
	364 "PSUR:PLASTIC SURGERY WITHIN THE HEAD AND	NECK" ///
	380 "PREVENTIVE MEDICINE" ///
	399 "PMED: MEDICAL TOXICOLOGY" ///
	398 "PMED:UNDERSEA AND HYPERBARIC MEDICINE" ///
	400 "PSYCHIATRY" ///
	401 "PSY: ADDICTION PSYCHIATRY" ///
	405 "PSY: CHILD AND ADOLESCENT PSYCHIATRY" ///
	406 "PSY: FORENSIC PSYCHIATRY" ///
	407 "PSY: GERIATRIC PSYCHIATRY" ///
	402 "PSY: PAIN MEDICINE" ///
	409 "PSY: PSYCHOSOMATIC MEDICINE" ///
	430 "RADIATION ONCOLOGY" ///
	420 "RADIOLOGY DIAGNOSTIC" ///
	421 "RADIAG: ABDOMINAL RADIOLOGY" ///
	429 "RADIAG: CARDIOTHORACIC RADIOLOGY" ///
	422 "RADIAG: ENDOVASCULAR SURGICAL NEURORADIOLOGY" ///
	426 "RADIAG: MUSCULOSKELETAL RADIOLOGY" ///
	423 "RADIAG: NEURORADIOLOGY" ///
	425 "RADIAG: NUCLEAR RADIOLOGY" ///
	424 "RADIAG: PEDIATRIC RADIOLOGY" ///
	427 "RADIAG: VASCULAR AND INTERVENTIONAL RADIOLOGY" ///
	430 "RADIAG: THERAPEUTIC RADIOLOGICAL PHYSICS" ///
	431 "RADIAG: MEDICAL NUCLEAR PHYSICS" ///
	432 "RADIAG: DIAGNOSTIC RADIOLOGICAL PHYSICS" ///
	433 "RADIAG: HOSPICE AND PALLIATIVE MEDICINE" ///
	434 "RADIAG: GENEARL DIAGNOSTIC RADIOLOGY" ///
	435 "RADIAG: MAMMOGRAPHY" ///
	436 "RADIAG: PAIN MANAGEMENT" ///
	520 "SLEEP MEDICINE" ///
	440 "SURGERY-GENERAL" ///
	443 "SUR: HAND SURGERY" ///
	445 "SUR:PEDIATRIC SURGERY" ///
	442 "SUR:SURGICAL CRITICAL CARE" ///
	450 "SUR:VASCULAR SURGERY" ///
	451 "SUR:HOSPICE AND PALLIATIVE MEDICINE" ///
	460 "THORACIC SURGERY" ///
	466 "TSUR: CONGENITAL CARDIAC SURGERY" ///
	480 "UROLOGY" ///
	485 "URO: PEDIATRIC UROLOGY" ///
	0 "INTERNAL MEDICINE/PEDIATRICS" 
	label values spec_prim spec
	label values spec_2 spec
	label values spec_3 spec
	label values spec_4 spec
	label values spec_5 spec
	label values spec_6 spec
	label values spec_7 spec
	
	
	gen 	specsum = 1 if spec_prim==20  
	replace specsum = 2 if spec_prim>=40 & spec_prim<=50 
	replace specsum = 3 if spec_prim>=60 & spec_prim<=70 
	replace specsum = 4 if spec_prim>=80 & spec_prim<=100 
	replace specsum = 5 if spec_prim>=110 & spec_prim<=119 
	replace specsum = 6 if spec_prim>=120 & spec_prim<=130 
	replace specsum = 7 if spec_prim>=140 & spec_prim<=160 | spec_prim==520 | spec_prim==521 
	replace specsum = 8 if spec_prim>=180 & spec_prim<=190 
	replace specsum = 9 if spec_prim>=220 & spec_prim<=230
	replace specsum = 10 if spec_prim==240
	replace specsum = 11 if spec_prim>=280 & spec_prim<=290 
	replace specsum = 12 if spec_prim>=320 & spec_prim<=335 | spec_prim==522 | spec_prim==523
	replace specsum = 13 if spec_prim>=340 & spec_prim<=349 
	replace specsum = 14 if spec_prim>=380 & spec_prim<=399
	replace specsum = 15 if spec_prim>=400 & spec_prim<=409 
	replace specsum = 16 if spec_prim>=420 & spec_prim<=436
	replace specsum = 17 if spec_prim>=440 & spec_prim<=451
	replace specsum = 18 if spec_prim==530
	label define specsum ///
	1 "Allergy and Immunology" ///
	2 "Anesthesiology" ///
	3 "Colon and Rectal Surgery" ///
	4 "Dermatology" ///
	5 "Emergency Medicine" /// 
	6 "Family Medicine" ///
	7 "Internal Medicine" ///
	8 "Neurology" ///
	9 "Obstetrics and Gynecology" ///
	10 "Ophthalmology" ///
	11 "Otolaryngology" ///
	12 "Pediatrics" ///
	13 "Physical Medicine and Rehab" /// 
	14 "Preventive Medicine" ///
	15 "Psychiatry" ///
	16 "Radiology Diagnostic" ///
	17 "Surgery General" ///
	18 "Pain Medicine"
	label values specsum specsum
	
 

	/* Labeling the year dummies*/
	
	xi i.year
	forvalues i=2008/2015 {
	label var _Iyear_`i' "`i'"
	}
	
	
	replace whymovein5yrs = 1 if whymovein5yrs ==1 & year==2009
	replace whymovein5yrs = 4 if whymovein5yrs ==2 & year==2009
	replace whymovein5yrs = . if whymovein5yrs ==3 & year==2009
	replace whymovein5yrs = 7 if whymovein5yrs ==4 & year==2009
	replace whymovein5yrs = 8 if whymovein5yrs ==5 & year==2009
	replace whymovein5yrs = 9 if whymovein5yrs ==6 & year==2009
	
	label define q19a2009 ///
	1 "Family" ///
	2 "Compensation" ///
	3 "Malpractice Insurance Rate" ///
	4 "Liability Exposure" ///
	5 "Medicare/Medicaid Reimbursement Rates" ///
	6 "Private Health Plan Reimbursement Rates" ///
	7 "Looking for a change" ///
	8 "Education-training in another state" ///
	9 "Other"
	label values whymovein5yrs  q19a2009



	drop minyear dob birthday changescope* special* hspec*
	
	
	label var age "Age"
	label var uniqueid "Unique ID"
	
	label var docid1 "Lic Num Part 1"
	label var docid2 "File Number from FL DPT"
	label var licnum "Lic Num Part 2"
	tab retirewhy, gen(retdum)
	tab mainpractice10, gen(mp)
	tab mainpracgroup, gen(mpg)
	* tab retirewhy2, gen(ret2dum)
	*NOTE: var doesn't exist, above code suggests it has been renamed to "retirewhy" 

	* Adding the first half of NPIs
	count
	merge m:1 docid1 docid2 using "$data/NPI_XW/npimerge1.dta", update 
	drop if _merge==2
	drop _merge
	order npi uniqueid docid1 docid2 licnum flag year age* sex  workinfl howmanymonths* whynot* spec_*  counties* timespent* howmanyp* mainprac* ret*	
	count
	* Adding the second half of NPIS these are observations that for a single license in a profession they had several NPIS attached to that observation
	merge m:1 docid1 docid2 using "$data/NPI_XW/npimerge2.dta", update
	drop if _merge==2
	* There are 94 observations that appear in the workforce licen file but dont appear in our clean workforce. This is probably because I dropped some people for various reasons. 
	drop _merge
	count
	* This indicates that about 37.72% of our sample we do not have NPIs 
	* So out of our clean unique individuals 47,573 have NPis and 28,809 dont. Sample total of unique people: 76,382
	
	* Adding disciplinary action 
	merge m:1 docid1 docid2 using "$data/Disciplinary proceedings/disciplinarymerge.dta", update 
	drop if _merge==2
	drop _merge
	
	
	
	
		
	save "$wkfrc/workforce_cleaned.dta", replace
	
	
	
	