classdef SteadyStateReducedFormRA < handle
    
    properties (GetAccess = public, SetAccess = public)
        calibration         % the calibration being used
        ssmean              % mean value MP
        sigma               % risk aversion
        delta               % capital share
        beta                % discount factor
        R                   % nominal interest rate
        q                   % asset price
        Y                   % Aggregate Output
		
        frac_cons=-1       % fraction of borrowing constrained using MC
    end
    
    properties (Access=protected)   % play with those if things don't work...
        verbose   = true            % switch to enable debug output
        tol = 1e-5;                 % max relative deviation for convergence
        weight_new = 1; 
    end
    
    properties (Dependent=true, SetAccess=protected)% play with those if things don't work...
        C                   % Aggregate Consumption
        A                   % Aggregate Savings
    end
    
    methods
        
        function self = SteadyStateReducedFormRA(calibr)
            % Constructor. pass it a calibration structure
            self.calibration = calibr;
            self.ssmean = calibr.ssmean;
            self.sigma = calibr.sigma;
            self.delta = calibr.delta;
			if isfield(calibr, 'beta')
				self.beta = calibr.beta;
			end
			self.R = calibr.R;
            self.calculate_steady_state();
        end
        
        function res = get.Y(self)
            res = self.ssmean;
        end
        
        function res = get.C(self)
            res = self.Y;
        end
        
        function res = get.A(self)
            res = self.q*self.R;
        end
        
    end
    
    methods(Access = protected)
        
        function calculate_steady_state(self)
            self.beta = 1/self.R;
            self.q = self.delta*self.Y/(self.R-1);
        end
                
    end
    
end