

**import data

****************************************
***analysis of rationality violations
****************************************

sum mono* if hyp==1
sum mono* if hyp==0

sum multiple* if hyp==1
sum multiple* if hyp==0

ranksum mono1, by(hyp)

ranksum mono2, by(hyp)


*********************************************************
***Callen et al.'s preference for certainty (task numbers follow order in instructions)
*********************************************************

tab task1 task2

tab task1 task2 if hyp==1
tab task1 task2 if hyp==0

**generate the utility values of probability equivalent and uncertainty equivalent
gen u_p = task1
gen u_u = (task2 - 0.5)/0.5

**test equality for hypothetical and real treatments
ttest u_p = u_u if hyp==1
signrank u_p = u_u if hyp==1

ttest u_p = u_u if hyp==0
signrank u_p = u_u if hyp==0

sort hyp
by hyp: ttest u_p = u_u


**hypothetical versus real
ttest u_p, by(hyp)
ranksum u_p, by(hyp)

ttest u_u, by(hyp)
ranksum u_u, by(hyp)


**test against rationality benchmarks
ttest u_u=0.33 if hyp==1
signrank u_u=0.33 if hyp==1

ttest u_u=0.33 if hyp==0
signrank u_u=0.33 if hyp==0

ttest u_p=0.33
signrank u_p=0.33 if hyp==1


*********************************************************
***Random switching patterns, lottery equivalents
*********************************************************

sum task4, d

**create utility value
gen u_l = task4/0.5


**test LE-derived utility against PE and UE
ttest u_l = u_p
signrank u_l = u_p

ttest u_l = u_u
signrank u_l = u_u



*********************************************************
***Hershey and Schoemaker 1985
*********************************************************

sum task3 task7, d


**teste matched tasks against benchmark
ttest task3=150
signrank  task3=150

ttest task7=0.5
signrank task7=0.5

*********************************************************
***Summary statistics
*********************************************************

sum task1 if hyp==1, d

sum task2 if hyp==1, d


sum task1 if hyp==0, d

sum task2 if hyp==0, d


sum task3 if hyp==0, d

sum task4 if hyp==0, d


sum task5 if hyp==0, d


sum task7 if hyp==0, d



