clear
import excel "C:\Users\PCavallino\Box Sync\Capital Flows and FX Intervention\Data\Dataset.xlsx", sheet("Quarterly Dataset Small") cellrange(C11:AH95) clear
save "C:\Users\PCavallino\Box Sync\Capital Flows and FX Intervention\Data\RawQuarterlyDataSmall.dta", replace
gen t = tq(1994q4) + C - 1
tsset t, quarterly
gen vix_US=log(O)
egen mvix_US=mean(vix_US)
gen vix_EU=log(S)
egen mvix_EU=mean(vix_EU)
gen vix_s=0.7*vix_EU+0.3*vix_US
egen mvix_s=mean(vix_s)
reg vix_EU vix_US
predict vix_EU_ext
egen mvix_EU_ext=mean(vix_EU_ext)
gen i=(1+D/100)^(1/4)-1
gen i_EU=(1+I/100)^(1/4)-1
gen i_US=(1+L/100)^(1/4)-1
gen lH=log(H)
gen cpi=(lH-L.lH)
gen lK=log(K)
gen cpi_EU=(lK-L.lK)
gen lN=log(N)
gen cpi_US=(lN-L.lN)
gen cpi_s=0.7*cpi_EU+0.3*cpi_US
gen r_EU=i_EU-F.cpi_EU
gen r_US=i_US-F.cpi_US
gen r_s=0.7*r_EU+0.3*r_US
gen r=i-F.cpi
gen e_EU=log(F)
tsfilter hp eHP_EU=e_EU, smooth(1600)
gen e_US=log(E)
tsfilter hp eHP_US=e_US, smooth(1600)
gen re_EU=log(F*K/H)
egen mre_EU=mean(re_EU)
tsfilter hp reHP_EU=re_EU, smooth(1600)
gen re_US=log(E*N/H)
tsfilter hp reHP_US=re_US, smooth(1600)
gen e_s=0.7*e_EU+0.3*e_US
gen re_s=0.7*re_EU+0.3*re_US
gen eHP_s=0.7*eHP_EU+0.3*eHP_US
gen reHP_s=0.7*reHP_EU+0.3*reHP_US
gen e_eff=log(1/R)
tsfilter hp eHP_eff=e_eff, smooth(1600)
gen re_effCPI=log(1/P)
tsfilter hp reHP_effCPI=re_effCPI, smooth(1600)
gen re_effPPI=log(1/Q)
tsfilter hp reHP_effPPI=re_effPPI, smooth(1600)
gen lG=log(G)
tsfilter hp y=lG, smooth(1600)
gen lJ=log(J)
tsfilter hp y_EU=lJ, smooth(1600)
gen lM=log(M)
tsfilter hp y_US=lM, smooth(1600)
gen y_s=0.7*y_EU+0.3*y_US
gen Res=-T/100
gen inf=-U/100
gen inf_no=-V/100
gen inf_wre=-W/100
gen inf_dc=-X/100
gen inf_p=-Y/100
gen inf_dp=-Z/100
gen NX=AA/100
gen CA=AB/100
gen BT=AC/100
reg NX t
predict nx, resid
reg CA t
predict ca, resid
reg BT t
predict bt, resid
gen lAD=log(AD+AE-AF)
tsfilter hp c=lAD, smooth(1600)
gen lAG=log(AG+AH)
tsfilter hp c_EU=lAG, smooth(1600)
drop in 1
drop C D E F H I J K L M N O P Q R S T U lK lH lN lG lM lJ G V W X Y Z AA AB AC AD AE AF AG AH CA 
save QuarterlyDatasetSmall, replace
